/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.core.util.KotlinIdeaCoreBundle;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B0\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000f\b\u0002\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0094\u0002J\r\u0010\u001b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\r\u0010\u001c\u001a\u00070\t\u00a2\u0006\u0002\b\u001dH\u0016J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/K2EnableUnsupportedFeatureFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lcom/intellij/psi/PsiElement;", "element", "module", "Lcom/intellij/openapi/module/Module;", "languageFeature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "alternativeActionText", "", "Lcom/intellij/codeInspection/util/IntentionName;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/config/LanguageFeature;Ljava/lang/String;)V", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "configurator$delegate", "Lkotlin/Lazy;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getText", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "isAvailable", "", "isFileUnderTestRoot", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nK2EnableUnsupportedFeatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2EnableUnsupportedFeatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/K2EnableUnsupportedFeatureFix\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,57:1\n184#2,2:58\n*S KotlinDebug\n*F\n+ 1 K2EnableUnsupportedFeatureFix.kt\norg/jetbrains/kotlin/idea/quickfix/K2EnableUnsupportedFeatureFix\n*L\n29#1:58,2\n*E\n"})
public final class K2EnableUnsupportedFeatureFix
extends KotlinQuickFixAction<PsiElement> {
    @NotNull
    private final Module module;
    @NotNull
    private final LanguageFeature languageFeature;
    @Nullable
    private final String alternativeActionText;
    @NotNull
    private final Lazy configurator$delegate;

    public K2EnableUnsupportedFeatureFix(@NotNull PsiElement element, @NotNull Module module, @NotNull LanguageFeature languageFeature, @Nullable String alternativeActionText) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)languageFeature, (String)"languageFeature");
        super(element);
        this.module = module;
        this.languageFeature = languageFeature;
        this.alternativeActionText = alternativeActionText;
        this.configurator$delegate = LazyKt.lazy(() -> K2EnableUnsupportedFeatureFix.configurator_delegate$lambda$0(this));
    }

    public /* synthetic */ K2EnableUnsupportedFeatureFix(PsiElement psiElement, Module module, LanguageFeature languageFeature, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(psiElement, module, languageFeature, string);
    }

    private final KotlinProjectConfigurator getConfigurator() {
        Lazy lazy = this.configurator$delegate;
        return (KotlinProjectConfigurator)lazy.getValue();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            boolean isTestFile = this.isFileUnderTestRoot(project, file);
            KotlinProjectConfigurator kotlinProjectConfigurator = this.getConfigurator();
            if (kotlinProjectConfigurator == null) break block0;
            kotlinProjectConfigurator.changeGeneralFeatureConfiguration(this.module, this.languageFeature, LanguageFeature.State.ENABLED, isTestFile);
        }
    }

    @NotNull
    public String getText() {
        String string = this.alternativeActionText;
        if (string == null) {
            Object[] objectArray = new Object[]{this.languageFeature.getPresentableName()};
            string = KotlinIdeaCoreBundle.message("fix.enable.feature.support.text", objectArray);
        }
        String actionText = string;
        return actionText;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.languageFeature.getPresentableName()};
        return KotlinIdeaCoreBundle.message("fix.enable.feature.support.family", objectArray);
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getConfigurator() != null;
    }

    private final boolean isFileUnderTestRoot(Project project, KtFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        return Intrinsics.areEqual((Object)KotlinProjectStructureUtils.getKotlinSourceRootType(projectFileIndex, virtualFile2), (Object)TestSourceKotlinRootType.INSTANCE);
    }

    private static final KotlinProjectConfigurator configurator_delegate$lambda$0(K2EnableUnsupportedFeatureFix this$0) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = KotlinProjectConfigurator.Companion.getEP_NAME().lazySequence();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                boolean bl = false;
                if (!it.isApplicable(this$0.module)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

