/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.CleanupFix;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0094\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MissingConstructorBracketsFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/CleanupFix$ModCommand;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;)V", "getFamilyName", "", "invoke", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.fir.frontend-independent"})
public final class MissingConstructorBracketsFix
extends PsiUpdateModCommandAction<KtPrimaryConstructor>
implements CleanupFix.ModCommand {
    public MissingConstructorBracketsFix(@NotNull KtPrimaryConstructor element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"add.empty.brackets.after.primary.constructor", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtPrimaryConstructor element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        PsiElement psiElement = element.getConstructorKeyword();
        if (psiElement == null) {
            return;
        }
        PsiElement constructorKeyword = psiElement;
        if (element.getValueParameterList() != null) {
            return;
        }
        int endOffset = PsiUtilsKt.getEndOffset((PsiElement)constructorKeyword);
        Project project = constructorKeyword.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPrimaryConstructor constructorKeywordWithBrackets = new KtPsiFactory(project, false, 2, null).createPrimaryConstructor("constructor()");
        constructorKeyword.replace((PsiElement)constructorKeywordWithBrackets);
        updater2.moveCaretTo(endOffset + 1);
    }
}

