/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J#\u0010\u001b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0094\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "<init>", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "showDialog", "", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "project", "Lcom/intellij/openapi/project/Project;", "element", "rhs", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getFamilyName", "", "getText", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "doRemove", "mode", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$RemoveMode;", "invoke", "Lorg/jetbrains/kotlin/psi/KtFile;", "RemoveMode", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nRemoveUnusedValueFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveUnusedValueFix.kt\norg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,93:1\n73#2:94\n*S KotlinDebug\n*F\n+ 1 RemoveUnusedValueFix.kt\norg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix\n*L\n32#1:94\n*E\n"})
public final class RemoveUnusedValueFix
extends KotlinQuickFixAction<KtBinaryExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RemoveUnusedValueFix(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super((PsiElement)expression);
    }

    private final void showDialog(KtProperty variable, Project project, KtBinaryExpression element, KtExpression rhs) {
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doRemove(RemoveMode.KEEP_INITIALIZE, element, rhs);
            return;
        }
        Object[] objectArray = new Object[]{String.valueOf(variable.getName())};
        String message2 = "<html><body>" + KotlinBundle.message((String)"there.are.possible.side.effects.found.in.expressions.assigned.to.the.variable.0", (Object[])objectArray) + "</body></html>";
        ApplicationManager.getApplication().invokeLater(() -> RemoveUnusedValueFix.showDialog$lambda$0(variable, message2, project, this, element, rhs));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"remove.redundant.assignment", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    private final void doRemove(RemoveMode mode, KtBinaryExpression element, KtExpression rhs) {
        switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1: {
                element.delete();
                break;
            }
            case 2: {
                element.replace((PsiElement)rhs);
            }
        }
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        boolean isSideEffectFree;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)this.getElement();
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression element = ktBinaryExpression;
        KtExpression ktExpression = element.getLeft();
        KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        if (ktSimpleNameExpression == null) {
            return;
        }
        KtSimpleNameExpression lhs = ktSimpleNameExpression;
        KtExpression ktExpression2 = element.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression rhs = ktExpression2;
        PsiElement psiElement = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)lhs).resolve();
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (ktProperty == null) {
            return;
        }
        KtProperty variable = ktProperty;
        Pseudocode pseudocode = PseudocodeUtilsKt.getContainingPseudocode((KtElement)((KtElement)rhs), (BindingContext)ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL));
        Pseudocode pseudocode2 = pseudocode;
        boolean bl = pseudocode2 != null && (pseudocode2 = pseudocode2.getElementValue((KtElement)rhs)) != null && (pseudocode2 = pseudocode2.getCreatedAt()) != null ? PseudocodeUtilsKt.getSideEffectFree((Instruction)((Instruction)pseudocode2)) : (isSideEffectFree = false);
        if (!isSideEffectFree) {
            this.showDialog(variable, project, element, rhs);
        } else {
            this.doRemove(RemoveMode.REMOVE_ALL, element, rhs);
        }
    }

    private static final void showDialog$lambda$0$0(RemoveUnusedValueFix this$0, int $exitCode, KtBinaryExpression $element, KtExpression $rhs) {
        this$0.doRemove(RemoveMode.values()[$exitCode], $element, $rhs);
    }

    private static final void showDialog$lambda$0(KtProperty $variable, String $message, Project $project, RemoveUnusedValueFix this$0, KtBinaryExpression $element, KtExpression $rhs) {
        int exitCode = Messages.showYesNoCancelDialog((Project)$variable.getProject(), (String)$message, (String)QuickFixBundle.message((String)"side.effects.warning.dialog.title", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.remove", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.transform", (Object[])new Object[0]), (String)QuickFixBundle.message((String)"side.effect.action.cancel", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        WriteCommandAction.runWriteCommandAction((Project)$project, () -> RemoveUnusedValueFix.showDialog$lambda$0$0(this$0, exitCode, $element, $rhs));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = ((DiagnosticWithParameters2)Errors.UNUSED_VALUE.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"<get-psiElement>(...)");
            KtBinaryExpression expression = (KtBinaryExpression)psiElement;
            if (!KtPsiUtil.isAssignment((PsiElement)((PsiElement)expression))) {
                return null;
            }
            if (!(expression.getLeft() instanceof KtSimpleNameExpression)) {
                return null;
            }
            return new RemoveUnusedValueFix(expression);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedValueFix$RemoveMode;", "", "<init>", "(Ljava/lang/String;I)V", "REMOVE_ALL", "KEEP_INITIALIZE", "CANCEL", "kotlin.idea"})
    public static final class RemoveMode
    extends Enum<RemoveMode> {
        public static final /* enum */ RemoveMode REMOVE_ALL = new RemoveMode();
        public static final /* enum */ RemoveMode KEEP_INITIALIZE = new RemoveMode();
        public static final /* enum */ RemoveMode CANCEL = new RemoveMode();
        private static final /* synthetic */ RemoveMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RemoveMode[] values() {
            return (RemoveMode[])$VALUES.clone();
        }

        public static RemoveMode valueOf(String value) {
            return Enum.valueOf(RemoveMode.class, value);
        }

        @NotNull
        public static EnumEntries<RemoveMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = removeModeArray = new RemoveMode[]{RemoveMode.REMOVE_ALL, RemoveMode.KEEP_INITIALIZE, RemoveMode.CANCEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RemoveMode.values().length];
            try {
                nArray[RemoveMode.REMOVE_ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RemoveMode.KEEP_INITIALIZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

