/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.ReplaceCallFixKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J!\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ReplaceImplicitReceiverCallFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "notNullNeeded", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.fir.frontend-independent"})
public final class ReplaceImplicitReceiverCallFix
extends PsiUpdateModCommandAction<KtExpression> {
    private final boolean notNullNeeded;

    public ReplaceImplicitReceiverCallFix(@NotNull KtExpression element, boolean notNullNeeded) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        this.notNullNeeded = notNullNeeded;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"replace.with.safe.this.call", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull KtExpression element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        String elvis = ReplaceCallFixKt.elvisOrEmpty(element, this.notNullNeeded);
        Project project = context2.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        Object[] objectArray = new Object[]{element};
        KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)("this?.$0" + elvis), (Object[])objectArray, (boolean)false, (int)4, null);
        PsiElement replacement = element.replace((PsiElement)newExpression2);
        if (((CharSequence)elvis).length() > 0) {
            Intrinsics.checkNotNull((Object)replacement);
            Project project2 = context2.project();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project(...)");
            ReplaceCallFixKt.moveCaretToEnd(replacement, project2, updater2);
        }
    }
}

