/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J#\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002J\u0014\u0010\u0013\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\"\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SpecifySuperTypeFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "superExpression", "superTypes", "", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtSuperExpression;Ljava/util/List;)V", "getText", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "specifySuperType", "superType", "createListPopupStep", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "Companion", "kotlin.idea"})
public final class SpecifySuperTypeFix
extends KotlinQuickFixAction<KtSuperExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> superTypes;

    public SpecifySuperTypeFix(@NotNull KtSuperExpression superExpression, @NotNull List<String> superTypes2) {
        Intrinsics.checkNotNullParameter((Object)superExpression, (String)"superExpression");
        Intrinsics.checkNotNullParameter(superTypes2, (String)"superTypes");
        super((PsiElement)superExpression);
        this.superTypes = superTypes2;
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message((String)"intention.name.specify.supertype", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (editor == null) {
            return;
        }
        KtSuperExpression ktSuperExpression = (KtSuperExpression)this.getElement();
        if (ktSuperExpression == null) {
            return;
        }
        KtSuperExpression superExpression = ktSuperExpression;
        CommandProcessor.getInstance().runUndoTransparentAction(() -> SpecifySuperTypeFix.invoke$lambda$0(this, superExpression, editor));
    }

    private final void specifySuperType(KtSuperExpression $this$specifySuperType, String superType) {
        Project project = $this$specifySuperType.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ApplicationUtilsKt.executeWriteCommand(project, KotlinBundle.message((String)"intention.name.specify.supertype", (Object[])new Object[0]), (Function0<Unit>)((Function0)() -> SpecifySuperTypeFix.specifySuperType$lambda$0($this$specifySuperType, superType)));
    }

    private final ListPopupStep<?> createListPopupStep(KtSuperExpression superExpression, List<String> superTypes2) {
        String string = KotlinBundle.message((String)"popup.title.choose.supertype", (Object[])new Object[0]);
        return (ListPopupStep)new BaseListPopupStep<String>(superTypes2, this, superExpression, string){
            final /* synthetic */ SpecifySuperTypeFix this$0;
            final /* synthetic */ KtSuperExpression $superExpression;
            {
                this.this$0 = $receiver;
                this.$superExpression = $superExpression;
                super($super_call_param$1, $superTypes);
            }

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                if (finalChoice) {
                    SpecifySuperTypeFix.access$specifySuperType(this.this$0, this.$superExpression, selectedValue);
                }
                return PopupStep.FINAL_CHOICE;
            }
        };
    }

    private static final void invoke$lambda$0(SpecifySuperTypeFix this$0, KtSuperExpression $superExpression, Editor $editor) {
        if (this$0.superTypes.size() == 1) {
            this$0.specifySuperType($superExpression, (String)CollectionsKt.first(this$0.superTypes));
        } else {
            JBPopupFactory.getInstance().createListPopup(this$0.createListPopupStep($superExpression, this$0.superTypes)).showInBestPositionFor($editor);
        }
    }

    private static final Unit specifySuperType$lambda$0(KtSuperExpression $this_specifySuperType, String $superType) {
        Object object = $this_specifySuperType.getLabelQualifier();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object label2 = object;
        Project project = $this_specifySuperType.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        $this_specifySuperType.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createExpression("super<" + $superType + ">" + (String)label2));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$specifySuperType(SpecifySuperTypeFix $this, KtSuperExpression $receiver, String superType) {
        $this.specifySuperType($receiver, superType);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SpecifySuperTypeFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nSpecifySuperTypeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecifySuperTypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/SpecifySuperTypeFix$Companion\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n249#2:109\n1642#3,10:110\n1915#3:120\n1916#3:122\n1652#3:123\n1642#3,10:124\n1915#3:134\n1807#3,3:135\n1916#3:139\n1652#3:140\n1#4:121\n1#4:138\n*S KotlinDebug\n*F\n+ 1 SpecifySuperTypeFix.kt\norg/jetbrains/kotlin/idea/quickfix/SpecifySuperTypeFix$Companion\n*L\n77#1:109\n82#1:110,10\n82#1:120\n82#1:122\n82#1:123\n91#1:124,10\n91#1:134\n92#1:135,3\n91#1:139\n91#1:140\n82#1:121\n91#1:138\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtSuperExpression> createAction(@NotNull Diagnostic diagnostic) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtSuperExpression ktSuperExpression = psiElement instanceof KtSuperExpression ? (KtSuperExpression)psiElement : null;
            if (ktSuperExpression == null) {
                return null;
            }
            KtSuperExpression superExpression = ktSuperExpression;
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)superExpression));
            if (ktQualifiedExpression == null) {
                return null;
            }
            KtQualifiedExpression qualifiedExpression = ktQualifiedExpression;
            KtExpression ktExpression = qualifiedExpression.getSelectorExpression();
            if (ktExpression == null) {
                return null;
            }
            KtExpression selectorExpression = ktExpression;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)superExpression;
            boolean $i$f$getStrictParentOfType = false;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            if (ktClassOrObject == null) {
                return null;
            }
            KtClassOrObject containingClassOrObject = ktClassOrObject;
            List superTypeListEntries = containingClassOrObject.getSuperTypeListEntries();
            if (superTypeListEntries.isEmpty()) {
                return null;
            }
            BindingContext context2 = ResolutionUtils.analyze((KtElement)superExpression, BodyResolveMode.PARTIAL);
            Iterable $this$mapNotNull$iv = superTypeListEntries;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv$iv;
                boolean bl2 = false;
                if (it.getTypeReference() == null) {
                    pair = null;
                } else {
                    KtTypeReference ktTypeReference = it.getTypeReference();
                    if (ktTypeReference == null || (ktTypeReference = ktTypeReference.getTypeElement()) == null) {
                        pair = null;
                    } else {
                        KotlinType kotlinType;
                        KtTypeReference typeReference;
                        KtTypeReference typeElement2 = ktTypeReference;
                        pair = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference) == null ? null : TuplesKt.to((Object)typeElement2, (Object)kotlinType);
                    }
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List superTypes2 = (List)destination$iv$iv;
            if (superTypes2.size() != superTypeListEntries.size()) {
                return null;
            }
            Project project = superExpression.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            Iterable $this$mapNotNull$iv2 = superTypes2;
            boolean $i$f$mapNotNull2 = false;
            Iterable $i$f$mapNotNullTo22 = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                String string;
                Object[] it;
                boolean bl;
                KotlinType kotlinType;
                KtTypeElement typeElement3;
                block22: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl4 = false;
                    Pair pair = (Pair)element$iv$iv;
                    boolean bl5 = false;
                    typeElement3 = (KtTypeElement)pair.component1();
                    kotlinType = (KotlinType)pair.component2();
                    Iterable $this$any$iv = superTypes2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Object[])element$iv;
                            boolean bl6 = false;
                            if (!(!Intrinsics.areEqual((Object)it.getSecond(), (Object)kotlinType) && TypeUtilsKt.isSubtypeOf((KotlinType)((KotlinType)it.getSecond()), (KotlinType)kotlinType))) continue;
                            bl = true;
                            break block22;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    string = null;
                } else if (FqNameUtilKt.getFqName(kotlinType) == null) {
                    string = null;
                } else {
                    String string2;
                    FqName fqName2;
                    String fqNameAsString = fqName2.asString();
                    String string3 = typeElement3.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    if (StringsKt.startsWith$default((String)string3, (String)fqNameAsString, (boolean)false, (int)2, null)) {
                        string2 = fqNameAsString;
                    } else {
                        String string4 = fqName2.shortName().asString();
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
                    }
                    String name2 = string2;
                    it = new Object[]{selectorExpression};
                    KtExpression newQualifiedExpression = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)psiFactory, (String)("super<" + name2 + ">.$0"), (Object[])it, (boolean)false);
                    BindingContext newContext = ExtendedResolutionApiKt.analyzeAsReplacement$default(newQualifiedExpression, (KtExpression)qualifiedExpression, context2, null, null, null, 28, null);
                    ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)newQualifiedExpression), (BindingContext)newContext);
                    string = (resolvedCall != null ? resolvedCall.getResultingDescriptor() : null) == null ? null : (!newContext.getDiagnostics().noSuppression().forElement((PsiElement)newQualifiedExpression).isEmpty() ? null : name2);
                }
                if (string == null) continue;
                String it$iv$iv = string;
                boolean bl7 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List superTypesForSuperExpression = (List)destination$iv$iv2;
            if (superTypesForSuperExpression.isEmpty()) {
                return null;
            }
            return new SpecifySuperTypeFix(superExpression, superTypesForSuperExpression);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

