/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.TypeOfAnnotationMemberFix;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u000e\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\tH\u0002J\f\u0010\n\u001a\u00020\u000b*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/TypeOfAnnotationMemberFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getArrayItemType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isItemTypeToFix", "", "kotlin.idea"})
public final class TypeOfAnnotationMemberFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final TypeOfAnnotationMemberFixFactory INSTANCE = new TypeOfAnnotationMemberFixFactory();

    private TypeOfAnnotationMemberFixFactory() {
    }

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement = diagnostic.getPsiElement();
        KtTypeReference ktTypeReference = psiElement instanceof KtTypeReference ? (KtTypeReference)psiElement : null;
        if (ktTypeReference == null) {
            return null;
        }
        KtTypeReference typeReference = ktTypeReference;
        KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)typeReference, BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        KotlinType kotlinType2 = this.getArrayItemType(type2);
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType itemType = kotlinType2;
        Object object = itemType.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = object.getName()) == null || (object = object.asString()) == null) {
            return null;
        }
        Object itemTypeName = object;
        if (!this.isItemTypeToFix(itemType)) {
            return null;
        }
        String fixedArrayTypeText = (String)itemTypeName + "Array";
        return new TypeOfAnnotationMemberFix(typeReference, fixedArrayTypeText).asIntention();
    }

    private final KotlinType getArrayItemType(KotlinType $this$getArrayItemType) {
        if (!KotlinBuiltIns.isArray((KotlinType)$this$getArrayItemType)) {
            return null;
        }
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull((List)$this$getArrayItemType.getArguments());
        if (typeProjection == null) {
            return null;
        }
        TypeProjection boxedType = typeProjection;
        if (boxedType.isStarProjection()) {
            return null;
        }
        return boxedType.getType();
    }

    private final boolean isItemTypeToFix(KotlinType $this$isItemTypeToFix) {
        return KotlinBuiltIns.isByte((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isChar((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isShort((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isInt((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isLong((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isFloat((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isDouble((KotlinType)$this$isItemTypeToFix) || KotlinBuiltIns.isBoolean((KotlinType)$this$isItemTypeToFix);
    }
}

