/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.DialogsKt;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringEventListener;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringListener;
import org.jetbrains.kotlin.idea.refactoring.RenderingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameConflictUtilsKt;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OperatorModifierChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u00de\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0007\u001a\n\u0010\n\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001aE\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u00022!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00060\u0012\u001a\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u001a\u001a\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\u001f\u001a\u00020\r*\u0004\u0018\u00010 2\b\b\u0001\u0010!\u001a\u00020\u0006\u001a\u0014\u0010\"\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$\u001a\n\u0010%\u001a\u00020\u0001*\u00020&\u001a\n\u0010'\u001a\u00020\u0001*\u00020(\u001a\u000e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020(\u001a\u000e\u0010+\u001a\u00020\r2\u0006\u0010*\u001a\u00020(\u001a\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/\u001a\u0016\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020-\u001a\f\u00103\u001a\u00020\u0006*\u000204H\u0000\u001a\f\u00105\u001a\u00020\u0006*\u000204H\u0000\u001a\f\u00106\u001a\u00020\u0006*\u000207H\u0000\u001a.\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00020;2\u0006\u0010\u0010\u001a\u00020<2\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010>2\b\b\u0001\u0010?\u001a\u00020\u0006\u001a8\u0010@\u001a\u001a\u0012\u0004\u0012\u00020B\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020B0C0A2\u0006\u0010\u0010\u001a\u00020<2\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010>H\u0002\u001a$\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00020;2\u0006\u0010\u0010\u001a\u00020<2\u000e\u0010=\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010>\u001a\f\u0010E\u001a\u000204*\u00020<H\u0000\u001a\n\u0010F\u001a\u00020\r*\u00020G\u001a4\u0010H\u001a\u00020\r*\u00020I2\u0006\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00020>\u001ay\u0010K\u001a\u0004\u0018\u0001HL\"\b\b\u0000\u0010L*\u00020/*\u0002HL2\u001a\u0010M\u001a\u0016\u0012\u0004\u0012\u0002HL\u0012\u0004\u0012\u00020O\u0012\u0006\u0012\u0004\u0018\u0001040N2\b\b\u0002\u0010P\u001a\u00020O2\u0019\b\u0002\u0010Q\u001a\u0013\u0012\u0004\u0012\u0002HL\u0012\u0004\u0012\u00020\r0\u0012\u00a2\u0006\u0002\bR2\u001b\b\u0002\u0010S\u001a\u0015\u0012\u0004\u0012\u0002HL\u0012\u0006\u0012\u0004\u0018\u0001HL0\u0012\u00a2\u0006\u0002\bR\u00a2\u0006\u0002\u0010T\u001a\u0016\u0010U\u001a\u0004\u0018\u00010\b*\u00020V2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007\u001a\u0016\u0010W\u001a\u0004\u0018\u00010\u0018*\u00020V2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007\u001a\f\u0010X\u001a\u0004\u0018\u00010Y*\u00020Z\"\u0015\u00108\u001a\u00020\u0001*\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006["}, d2={"canRefactor", "", "Lcom/intellij/psi/PsiElement;", "getOrCreateKotlinFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "fileName", "", "targetDir", "Lcom/intellij/psi/PsiDirectory;", "packageName", "getUsageContext", "isInKotlinAwareSourceRoot", "reportDeclarationConflict", "", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "declaration", "message", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "renderedDeclaration", "getLineStartOffset", "", "Lcom/intellij/psi/PsiFile;", "line", "(Lcom/intellij/psi/PsiFile;I)Ljava/lang/Integer;", "broadcastRefactoringExit", "project", "Lcom/intellij/openapi/project/Project;", "refactoringId", "validateElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "errorMessage", "invokeOnceOnCommandFinish", "action", "Lkotlin/Function0;", "isInterfaceClass", "Lcom/intellij/psi/PsiNamedElement;", "isAbstract", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "dropOverrideKeywordIfNecessary", "element", "dropOperatorKeywordIfNecessary", "getQualifiedTypeArgumentList", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "initializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "addTypeArgumentsIfNeeded", "expression", "typeArgumentList", "getThisLabelName", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "explicateAsTextForReceiver", "explicateAsText", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "isInjectedFragment", "(Lcom/intellij/psi/PsiFile;)Z", "checkSuperMethods", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "ignore", "", "actionString", "getSuperDescriptors", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "", "getSuperMethods", "resolveToExpectedDescriptorIfPossible", "showWithTransaction", "Lcom/intellij/openapi/ui/DialogWrapper;", "checkDeclarationConflict", "Lcom/intellij/psi/PsiMethod;", "callables", "replaceWithCopyWithResolveCheck", "T", "resolveStrategy", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "context", "preHook", "Lkotlin/ExtensionFunctionType;", "postHook", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/resolve/BindingContext;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/psi/KtExpression;", "toPsiDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "toPsiFile", "classForRefactor", "Lorg/jetbrains/kotlin/psi/KtClass;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nkotlinRefactoringUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinRefactoringUtil.kt\norg/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,438:1\n13225#2,2:439\n1401#2,2:462\n1807#3,3:441\n1642#3,10:444\n1915#3:454\n1916#3:456\n1652#3:457\n1786#3,3:458\n1586#3:465\n1661#3,3:466\n1#4:455\n1#4:464\n249#5:461\n*S KotlinDebug\n*F\n+ 1 kotlinRefactoringUtil.kt\norg/jetbrains/kotlin/idea/refactoring/KotlinRefactoringUtilKt\n*L\n74#1:439,2\n394#1:462,2\n228#1:441,3\n236#1:444,10\n236#1:454\n236#1:456\n236#1:457\n250#1:458,3\n299#1:465\n299#1:466,3\n236#1:455\n268#1:461\n*E\n"})
public final class KotlinRefactoringUtilKt {
    @Deprecated(message="Was moved to the common part", replaceWith=@ReplaceWith(expression="canRefactorElement()", imports={}))
    @ApiStatus.Internal
    public static final boolean canRefactor(@NotNull PsiElement $this$canRefactor) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$canRefactor, (String)"<this>");
            if (!$this$canRefactor.isValid()) {
                bl = false;
            } else if ($this$canRefactor instanceof PsiPackage) {
                PsiDirectory[] psiDirectoryArray = ((PsiPackage)$this$canRefactor).getDirectories();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
                Object[] $this$any$iv = psiDirectoryArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiDirectory it = (PsiDirectory)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!KotlinRefactoringUtilKt.canRefactor((PsiElement)it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            } else {
                bl = $this$canRefactor instanceof KtElement || $this$canRefactor instanceof PsiMember && Intrinsics.areEqual((Object)((PsiMember)$this$canRefactor).getLanguage(), (Object)JavaLanguage.INSTANCE) || $this$canRefactor instanceof PsiDirectory ? SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, true, false, 47, null), $this$canRefactor) : false;
            }
        }
        return bl;
    }

    @JvmOverloads
    @NotNull
    public static final KtFile getOrCreateKotlinFile(@NotNull String fileName, @NotNull PsiDirectory targetDir, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        PsiFile psiFile = targetDir.findFile(fileName);
        if (psiFile == null) {
            psiFile = (PsiFile)PackageUtilsKt.createKotlinFile(fileName, targetDir, packageName);
        }
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        return (KtFile)psiFile;
    }

    public static /* synthetic */ KtFile getOrCreateKotlinFile$default(String string, PsiDirectory psiDirectory, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            FqName fqName2 = PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory);
            string2 = fqName2 != null ? fqName2.asString() : null;
        }
        return KotlinRefactoringUtilKt.getOrCreateKotlinFile(string, psiDirectory, string2);
    }

    @NotNull
    public static final PsiElement getUsageContext(@NotNull PsiElement $this$getUsageContext) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$getUsageContext, (String)"<this>");
        if ($this$getUsageContext instanceof KtElement) {
            Class[] classArray = new Class[]{KtPropertyAccessor.class, KtProperty.class, KtNamedFunction.class, KtConstructor.class, KtClassOrObject.class};
            KtDeclarationStub ktDeclarationStub = (KtDeclarationStub)PsiTreeUtil.getParentOfType((PsiElement)$this$getUsageContext, (Class[])classArray);
            NavigatablePsiElement navigatablePsiElement = ktDeclarationStub != null ? (NavigatablePsiElement)ktDeclarationStub : (NavigatablePsiElement)((KtElement)$this$getUsageContext).getContainingFile();
            Intrinsics.checkNotNull((Object)navigatablePsiElement);
            psiElement = (PsiElement)navigatablePsiElement;
        } else {
            PsiElement psiElement2 = ConflictsUtil.getContainer((PsiElement)$this$getUsageContext);
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getContainer(...)");
        }
        return psiElement;
    }

    public static final boolean isInKotlinAwareSourceRoot(@NotNull PsiElement $this$isInKotlinAwareSourceRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinAwareSourceRoot, (String)"<this>");
        return !ProjectRootUtilsKt.isOutsideKotlinAwareSourceRoot($this$isInKotlinAwareSourceRoot.getContainingFile());
    }

    public static final void reportDeclarationConflict(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull PsiElement declaration, @NotNull Function1<? super String, String> message2) {
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(message2, (String)"message");
        String string = RefactoringUIUtil.getDescription((PsiElement)declaration, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
        conflicts.putValue((Object)declaration, message2.invoke((Object)StringsKt.capitalize((String)string)));
    }

    @Deprecated(message="Use org.jetbrains.kotlin.idea.base.psi.getLineStartOffset() instead", replaceWith=@ReplaceWith(expression="this.getLineStartOffset(line)", imports={"org.jetbrains.kotlin.idea.base.psi.getLineStartOffset"}), level=DeprecationLevel.ERROR)
    @Nullable
    public static final Integer getLineStartOffset(@NotNull PsiFile $this$getLineStartOffset, int line) {
        Document doc;
        Intrinsics.checkNotNullParameter((Object)$this$getLineStartOffset, (String)"<this>");
        Document document = $this$getLineStartOffset.getViewProvider().getDocument();
        if (document == null) {
            document = PsiDocumentManager.getInstance((Project)$this$getLineStartOffset.getProject()).getDocument($this$getLineStartOffset);
        }
        if ((doc = document) != null && line >= 0 && line < doc.getLineCount()) {
            int startOffset = doc.getLineStartOffset(line);
            PsiElement psiElement = $this$getLineStartOffset.findElementAt(startOffset);
            if (psiElement == null) {
                return startOffset;
            }
            PsiElement element = psiElement;
            if (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
                Class[] classArray = new Class[]{PsiWhiteSpace.class, PsiComment.class};
                PsiElement psiElement2 = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])classArray);
                return psiElement2 != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement2) : startOffset;
            }
            return startOffset;
        }
        return null;
    }

    public static final void broadcastRefactoringExit(@NotNull Project project, @NotNull String refactoringId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)refactoringId, (String)"refactoringId");
        ((KotlinRefactoringEventListener)project.getMessageBus().syncPublisher(KotlinRefactoringEventListener.Companion.getEVENT_TOPIC())).onRefactoringExit(refactoringId);
        ((KotlinRefactoringListener)project.getMessageBus().syncPublisher(KotlinRefactoringListener.Companion.getEVENT_TOPIC())).onRefactoringExit(refactoringId);
    }

    public static final void validateElement(@Nullable KtElement $this$validateElement, @NlsContexts.DialogMessage @NotNull String errorMessage) throws ConfigurationException {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if ($this$validateElement == null) {
            throw new ConfigurationException(errorMessage);
        }
        try {
            AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)$this$validateElement));
        }
        catch (Exception e) {
            throw new ConfigurationException(errorMessage);
        }
    }

    public static final void invokeOnceOnCommandFinish(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        SimpleMessageBusConnection simpleConnect = ApplicationManager.getApplication().getMessageBus().simpleConnect();
        Topic topic = CommandListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleConnect.subscribe(topic, (Object)new CommandListener(action2, simpleConnect){
            final /* synthetic */ Function0<Unit> $action;
            final /* synthetic */ SimpleMessageBusConnection $simpleConnect;
            {
                this.$action = $action;
                this.$simpleConnect = $simpleConnect;
            }

            public void beforeCommandFinished(CommandEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$action.invoke();
                this.$simpleConnect.disconnect();
            }
        });
    }

    public static final boolean isInterfaceClass(@NotNull PsiNamedElement $this$isInterfaceClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isInterfaceClass, (String)"<this>");
        PsiNamedElement psiNamedElement = $this$isInterfaceClass;
        return psiNamedElement instanceof KtClass ? ((KtClass)$this$isInterfaceClass).isInterface() : (psiNamedElement instanceof PsiClass ? ((PsiClass)$this$isInterfaceClass).isInterface() : (psiNamedElement instanceof KtPsiClassWrapper ? ((KtPsiClassWrapper)$this$isInterfaceClass).getPsiClass().isInterface() : false));
    }

    public static final boolean isAbstract(@NotNull KtNamedDeclaration $this$isAbstract) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isAbstract, (String)"<this>");
        if ($this$isAbstract.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            bl = true;
        } else {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$isAbstract));
            boolean bl2 = ktClassOrObject != null ? KotlinRefactoringUtilKt.isInterfaceClass((PsiNamedElement)ktClassOrObject) : false;
            bl = !bl2 ? false : ($this$isAbstract instanceof KtProperty ? ((KtProperty)$this$isAbstract).getInitializer() == null && ((KtProperty)$this$isAbstract).getDelegate() == null && ((KtProperty)$this$isAbstract).getAccessors().isEmpty() : ($this$isAbstract instanceof KtNamedFunction ? !((KtNamedFunction)$this$isAbstract).hasBody() : false));
        }
        return bl;
    }

    public static final void dropOverrideKeywordIfNecessary(@NotNull KtNamedDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)element, null, 1, null);
        CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        if (callableDescriptor == null) {
            return;
        }
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        if (callableDescriptor2.getOverriddenDescriptors().isEmpty()) {
            element.removeModifier(KtTokens.OVERRIDE_KEYWORD);
        }
    }

    public static final void dropOperatorKeywordIfNecessary(@NotNull KtNamedDeclaration element) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)element, null, 1, null);
            CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
            if (callableDescriptor == null) {
                return;
            }
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            BindingTraceContext diagnosticHolder = new BindingTraceContext(element.getProject());
            OperatorModifierChecker.INSTANCE.check((KtDeclaration)element, (DeclarationDescriptor)callableDescriptor2, (DiagnosticSink)diagnosticHolder, LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)element));
            Diagnostics diagnostics = diagnosticHolder.getBindingContext().getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"getDiagnostics(...)");
            Iterable $this$any$iv = (Iterable)diagnostics;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.INAPPLICABLE_OPERATOR_MODIFIER)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            element.removeModifier(KtTokens.OPERATOR_KEYWORD);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KtTypeArgumentList getQualifiedTypeArgumentList(@NotNull KtExpression initializer2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)initializer2, null, 1, null);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall call = resolvedCall;
        Map map2 = call.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getTypeArguments(...)");
        Map typeArgumentMap = map2;
        List list2 = call.getCandidateDescriptor().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
            boolean bl2 = false;
            if ((KotlinType)typeArgumentMap.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List typeArguments2 = (List)destination$iv$iv;
        String renderedList = CollectionsKt.joinToString$default((Iterable)typeArguments2, null, (CharSequence)"<", (CharSequence)">", (int)0, null, KotlinRefactoringUtilKt::getQualifiedTypeArgumentList$lambda$1, (int)25, null);
        Project project = initializer2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new KtPsiFactory(project, false, 2, null).createTypeArguments(renderedList);
    }

    public static final void addTypeArgumentsIfNeeded(@NotNull KtExpression expression, @NotNull KtTypeArgumentList typeArgumentList) {
        boolean bl;
        KtCallExpression callElement;
        block7: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)typeArgumentList, (String)"typeArgumentList");
            BindingContext context2 = ResolutionUtils.analyze((KtElement)expression, BodyResolveMode.PARTIAL_WITH_DIAGNOSTICS);
            Call call = CallUtilKt.getCallWithAssert((KtElement)((KtElement)expression), (BindingContext)context2);
            KtElement ktElement = call.getCallElement();
            KtCallExpression ktCallExpression = ktElement instanceof KtCallExpression ? (KtCallExpression)ktElement : null;
            if (ktCallExpression == null) {
                return;
            }
            callElement = ktCallExpression;
            if (call.getTypeArgumentList() != null) {
                return;
            }
            KtExpression ktExpression = call.getCalleeExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression callee = ktExpression;
            Iterable $this$all$iv = context2.getDiagnostics().forElement((PsiElement)callee);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER) && !Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.NEW_INFERENCE_NO_INFORMATION_FOR_PARAMETER)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        callElement.addAfter((PsiElement)typeArgumentList, (PsiElement)callElement.getCalleeExpression());
        KtTypeArgumentList ktTypeArgumentList = callElement.getTypeArgumentList();
        Intrinsics.checkNotNull((Object)ktTypeArgumentList);
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)ktTypeArgumentList, null, 2, null);
    }

    @NotNull
    public static final String getThisLabelName(@NotNull DeclarationDescriptor $this$getThisLabelName) {
        Intrinsics.checkNotNullParameter((Object)$this$getThisLabelName, (String)"<this>");
        if (!$this$getThisLabelName.getName().isSpecial()) {
            String string = $this$getThisLabelName.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return string;
        }
        if ($this$getThisLabelName instanceof AnonymousFunctionDescriptor) {
            KtSimpleNameExpression callee;
            KtCallElement callElement;
            KtCallElement ktCallElement;
            KtValueArgument argument2;
            KtFunction function;
            SourceElement sourceElement = ((AnonymousFunctionDescriptor)$this$getThisLabelName).getSource();
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
            PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
            KtFunction ktFunction = function = psiElement instanceof KtFunction ? (KtFunction)psiElement : null;
            PsiElement psiElement2 = ktFunction != null ? ktFunction.getParent() : null;
            Object object = psiElement2 instanceof KtValueArgument ? (KtValueArgument)psiElement2 : null;
            if (object == null) {
                KtFunction ktFunction2 = function;
                PsiElement psiElement3 = ktFunction2 != null ? ktFunction2.getParent() : null;
                KtLambdaExpression ktLambdaExpression = psiElement3 instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement3 : null;
                psiElement2 = ktLambdaExpression != null ? ktLambdaExpression.getParent() : null;
                object = psiElement2 instanceof KtValueArgument ? (KtValueArgument)psiElement2 : null;
            }
            KtValueArgument ktValueArgument = argument2 = object;
            if (ktValueArgument != null) {
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)ktValueArgument;
                boolean $i$f$getStrictParentOfType = false;
                ktCallElement = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallElement.class, (boolean)true);
            } else {
                ktCallElement = null;
            }
            KtCallElement ktCallElement2 = callElement = ktCallElement;
            KtExpression ktExpression = ktCallElement2 != null ? ktCallElement2.getCalleeExpression() : null;
            KtSimpleNameExpression ktSimpleNameExpression = callee = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
            if (callee != null) {
                String string = callee.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return string;
            }
        }
        return "";
    }

    @NotNull
    public static final String explicateAsTextForReceiver(@NotNull DeclarationDescriptor $this$explicateAsTextForReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$explicateAsTextForReceiver, (String)"<this>");
        String labelName = KotlinRefactoringUtilKt.getThisLabelName($this$explicateAsTextForReceiver);
        return ((CharSequence)labelName).length() == 0 ? "this" : "this@" + labelName;
    }

    @NotNull
    public static final String explicateAsText(@NotNull ImplicitReceiver $this$explicateAsText) {
        Intrinsics.checkNotNullParameter((Object)$this$explicateAsText, (String)"<this>");
        return KotlinRefactoringUtilKt.explicateAsTextForReceiver($this$explicateAsText.getDeclarationDescriptor());
    }

    public static final boolean isInjectedFragment(@NotNull PsiFile $this$isInjectedFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$isInjectedFragment, (String)"<this>");
        return InjectedLanguageManager.getInstance((Project)$this$isInjectedFragment.getProject()).isInjectedFragment($this$isInjectedFragment);
    }

    @NotNull
    public static final List<PsiElement> checkSuperMethods(@NotNull KtDeclaration declaration, @Nullable Collection<? extends PsiElement> ignore, @Nls @NotNull String actionString) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)actionString, (String)"actionString");
        if (!declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return CollectionsKt.listOf((Object)declaration);
        }
        Pair<CallableDescriptor, Map<PsiElement, CallableDescriptor>> pair = KotlinRefactoringUtilKt.getSuperDescriptors(declaration, ignore);
        CallableDescriptor declarationDescriptor = (CallableDescriptor)pair.component1();
        Map overriddenElementsToDescriptor = (Map)pair.component2();
        if (overriddenElementsToDescriptor.isEmpty()) {
            return CollectionsKt.listOf((Object)declaration);
        }
        return KotlinRefactoringUtilKt.checkSuperMethods$askUserForMethodsToSearch(actionString, declaration, declarationDescriptor, overriddenElementsToDescriptor);
    }

    private static final Pair<CallableDescriptor, Map<PsiElement, CallableDescriptor>> getSuperDescriptors(KtDeclaration declaration, Collection<? extends PsiElement> ignore) {
        String progressTitle = KotlinBundle.message((String)"find.usages.progress.text.declaration.superMethods", (Object[])new Object[0]);
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = ActionUtil.underModalProgress((Project)project, (String)progressTitle, () -> KotlinRefactoringUtilKt.getSuperDescriptors$lambda$0(declaration, ignore));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"underModalProgress(...)");
        return (Pair)object;
    }

    @NotNull
    public static final List<PsiElement> getSuperMethods(@NotNull KtDeclaration declaration, @Nullable Collection<? extends PsiElement> ignore) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return CollectionsKt.listOf((Object)declaration);
        }
        Map overriddenElementsToDescriptor = (Map)KotlinRefactoringUtilKt.getSuperDescriptors(declaration, ignore).component2();
        return overriddenElementsToDescriptor.isEmpty() ? CollectionsKt.listOf((Object)declaration) : CollectionsKt.toList((Iterable)overriddenElementsToDescriptor.keySet());
    }

    @NotNull
    public static final DeclarationDescriptor resolveToExpectedDescriptorIfPossible(@NotNull KtDeclaration $this$resolveToExpectedDescriptorIfPossible) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveToExpectedDescriptorIfPossible, (String)"<this>");
        DeclarationDescriptor descriptor2 = ResolutionUtils.unsafeResolveToDescriptor$default($this$resolveToExpectedDescriptorIfPossible, null, 1, null);
        DeclarationDescriptor declarationDescriptor = ExpectActualUtilKt.liftToExpected(descriptor2);
        if (declarationDescriptor == null) {
            declarationDescriptor = descriptor2;
        }
        return declarationDescriptor;
    }

    public static final void showWithTransaction(@NotNull DialogWrapper $this$showWithTransaction) {
        Intrinsics.checkNotNullParameter((Object)$this$showWithTransaction, (String)"<this>");
        TransactionGuard.submitTransaction((Disposable)$this$showWithTransaction.getDisposable(), () -> KotlinRefactoringUtilKt.showWithTransaction$lambda$0($this$showWithTransaction));
    }

    /*
     * Unable to fully structure code
     */
    public static final void checkDeclarationConflict(@NotNull PsiMethod $this$checkDeclarationConflict, @NotNull String name, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Collection<? extends PsiElement> callables) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$checkDeclarationConflict, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
                Intrinsics.checkNotNullParameter(callables, (String)"callables");
                var4_4 = $this$checkDeclarationConflict.getContainingClass();
                if (var4_4 == null || (var5_5 = var4_4.findMethodsByName(name, true)) == null) break block4;
                var7_6 = var5_5;
                $i$f$firstOrNull = false;
                var10_10 = ((void)$this$firstOrNull$iv).length;
                for (var9_9 = 0; var9_9 < var10_10; ++var9_9) {
                    it = element$iv = $this$firstOrNull$iv[var9_9];
                    $i$a$-firstOrNull-KotlinRefactoringUtilKt$checkDeclarationConflict$1 = false;
                    if (it.getParameterList().getParametersCount() != 0) ** GOTO lbl-1000
                    v0 = callables;
                    Intrinsics.checkNotNull((Object)it);
                    if (!CollectionsKt.contains((Iterable)v0, (Object)((PsiElement)LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)((PsiElement)it))))) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = var6_14 = null;
            }
            if (var6_14 == null) break block4;
            it = var6_14;
            $i$a$-let-KotlinRefactoringUtilKt$checkDeclarationConflict$2 = false;
            KotlinRefactoringUtilKt.reportDeclarationConflict(conflicts, it, (Function1<? super String, String>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, checkDeclarationConflict$lambda$1$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
        }
    }

    @Nullable
    public static final <T extends KtExpression> T replaceWithCopyWithResolveCheck(@NotNull T $this$replaceWithCopyWithResolveCheck, @NotNull Function2<? super T, ? super BindingContext, ? extends DeclarationDescriptor> resolveStrategy, @NotNull BindingContext context2, @NotNull Function1<? super T, Unit> preHook, @NotNull Function1<? super T, ? extends T> postHook) {
        Intrinsics.checkNotNullParameter($this$replaceWithCopyWithResolveCheck, (String)"<this>");
        Intrinsics.checkNotNullParameter(resolveStrategy, (String)"resolveStrategy");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(preHook, (String)"preHook");
        Intrinsics.checkNotNullParameter(postHook, (String)"postHook");
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)resolveStrategy.invoke($this$replaceWithCopyWithResolveCheck, (Object)context2);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor originDescriptor = declarationDescriptor;
        PsiElement psiElement = ((PsiElement)$this$replaceWithCopyWithResolveCheck).copy();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt.replaceWithCopyWithResolveCheck");
        KtExpression elementCopy = (KtExpression)psiElement;
        preHook.invoke((Object)elementCopy);
        BindingContext newContext = ExtendedResolutionApiKt.analyzeAsReplacement$default(elementCopy, $this$replaceWithCopyWithResolveCheck, context2, null, null, null, 28, null);
        DeclarationDescriptor declarationDescriptor2 = (DeclarationDescriptor)resolveStrategy.invoke((Object)elementCopy, (Object)newContext);
        if (declarationDescriptor2 == null) {
            return null;
        }
        DeclarationDescriptor newDescriptor2 = declarationDescriptor2;
        return (T)(Intrinsics.areEqual((Object)RenameConflictUtilsKt.canonicalRender(originDescriptor), (Object)RenameConflictUtilsKt.canonicalRender(newDescriptor2)) ? (KtExpression)postHook.invoke((Object)elementCopy) : null);
    }

    public static /* synthetic */ KtExpression replaceWithCopyWithResolveCheck$default(KtExpression ktExpression, Function2 function2, BindingContext bindingContext, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            bindingContext = ResolutionUtils.analyze$default((KtElement)ktExpression, null, 1, null);
        }
        if ((n & 4) != 0) {
            function1 = KotlinRefactoringUtilKt::replaceWithCopyWithResolveCheck$lambda$0;
        }
        if ((n & 8) != 0) {
            function12 = KotlinRefactoringUtilKt::replaceWithCopyWithResolveCheck$lambda$1;
        }
        return KotlinRefactoringUtilKt.replaceWithCopyWithResolveCheck(ktExpression, function2, bindingContext, function1, function12);
    }

    @Deprecated(message="Use org.jetbrains.kotlin.idea.core.util.toPsiDirectory() instead", replaceWith=@ReplaceWith(expression="this.toPsiDirectory(project)", imports={"org.jetbrains.kotlin.idea.core.util.toPsiDirectory"}), level=DeprecationLevel.ERROR)
    @Nullable
    public static final PsiDirectory toPsiDirectory(@NotNull VirtualFile $this$toPsiDirectory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$toPsiDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PhysicalFileSystemUtilsKt.toPsiDirectory($this$toPsiDirectory, project);
    }

    @Deprecated(message="Use org.jetbrains.kotlin.idea.core.util.toPsiFile() instead", replaceWith=@ReplaceWith(expression="this.toPsiFile(project)", imports={"org.jetbrains.kotlin.idea.core.util.toPsiFile"}), level=DeprecationLevel.ERROR)
    @Nullable
    public static final PsiFile toPsiFile(@NotNull VirtualFile $this$toPsiFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$toPsiFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PhysicalFileSystemUtilsKt.toPsiFile($this$toPsiFile, project);
    }

    @Nullable
    public static final KtClass classForRefactor(@NotNull KtTypeReference $this$classForRefactor) {
        Intrinsics.checkNotNullParameter((Object)$this$classForRefactor, (String)"<this>");
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)$this$classForRefactor, BodyResolveMode.PARTIAL);
        KotlinType kotlinType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)$this$classForRefactor);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor2));
        KtClass ktClass = psiElement instanceof KtClass ? (KtClass)psiElement : null;
        if (ktClass == null) {
            return null;
        }
        KtClass declaration = ktClass;
        ClassifierDescriptor it = classifierDescriptor = declaration;
        boolean bl = false;
        return KotlinCommonRefactoringUtilKt.canRefactorElement((PsiElement)declaration) ? classifierDescriptor : null;
    }

    @JvmOverloads
    @NotNull
    public static final KtFile getOrCreateKotlinFile(@NotNull String fileName, @NotNull PsiDirectory targetDir) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        return KotlinRefactoringUtilKt.getOrCreateKotlinFile$default(fileName, targetDir, null, 4, null);
    }

    private static final CharSequence getQualifiedTypeArgumentList$lambda$1(KotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IdeDescriptorRenderers.SOURCE_CODE_NOT_NULL_TYPE_APPROXIMATION.renderType(TypeUtilsKt.unCapture((KotlinType)it));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> checkSuperMethods$getClassDescriptions(Map<PsiElement, ? extends CallableDescriptor> overriddenElementsToDescriptor) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = overriddenElementsToDescriptor.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void entry;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiElement element = (PsiElement)entry.getKey();
            CallableDescriptor descriptor2 = (CallableDescriptor)entry.getValue();
            PsiElement psiElement = element;
            if (psiElement instanceof KtNamedFunction || psiElement instanceof KtProperty || psiElement instanceof KtParameter) {
                DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
                string = RenderingUtilsKt.formatClassDescriptor(declarationDescriptor);
            } else if (psiElement instanceof PsiMethod) {
                PsiClass psiClass;
                if (((PsiMethod)element).getContainingClass() == null) {
                    throw new IllegalStateException(("Invalid element: " + element.getText()).toString());
                }
                string = RenderingUtilsKt.formatPsiClass(psiClass, true, false);
            } else {
                throw new IllegalStateException(("Unexpected element: " + PsiUtilsKt.getElementTextWithContext((PsiElement)element)).toString());
            }
            String description = string;
            collection.add("    " + description + "\n");
        }
        return (List)destination$iv$iv;
    }

    private static final List<PsiElement> checkSuperMethods$askUserForMethodsToSearch(String $actionString, KtDeclaration $declaration, CallableDescriptor declarationDescriptor, Map<PsiElement, ? extends CallableDescriptor> overriddenElementsToDescriptor) {
        List<String> superClassDescriptions = KotlinRefactoringUtilKt.checkSuperMethods$getClassDescriptions(overriddenElementsToDescriptor);
        Object[] objectArray = new Object[]{DescriptorRenderer.COMPACT_WITH_SHORT_TYPES.render((DeclarationDescriptor)declarationDescriptor), "\n" + CollectionsKt.joinToString$default((Iterable)superClassDescriptions, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), $actionString};
        String message2 = KotlinBundle.message((String)"override.declaration.x.overrides.y.in.class.list", (Object[])objectArray);
        Project project = $declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = IdeBundle.message((String)"title.warning", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon2 = Messages.getQuestionIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getQuestionIcon(...)");
        int exitCode = DialogsKt.showYesNoCancelDialog("CHECK_SUPER_METHODS_YES_NO_DIALOG", project, message2, string, icon2, 0);
        return switch (exitCode) {
            case 0 -> CollectionsKt.toList((Iterable)overriddenElementsToDescriptor.keySet());
            case 1 -> CollectionsKt.listOf((Object)$declaration);
            default -> CollectionsKt.emptyList();
        };
    }

    private static final Pair getSuperDescriptors$lambda$0(KtDeclaration $declaration, Collection $ignore) {
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default($declaration, null, 1, null);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
        CallableDescriptor declarationDescriptor2 = (CallableDescriptor)declarationDescriptor;
        if (declarationDescriptor2 instanceof LocalVariableDescriptor) {
            return TuplesKt.to((Object)declarationDescriptor2, (Object)MapsKt.emptyMap());
        }
        HashMap overriddenElementsToDescriptor = new HashMap();
        for (CallableDescriptor overriddenDescriptor : DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)declarationDescriptor2)) {
            PsiElement overriddenDeclaration;
            Project project = $declaration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Intrinsics.checkNotNull((Object)overriddenDescriptor);
            if (DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project, (DeclarationDescriptor)overriddenDescriptor) == null || !(overriddenDeclaration instanceof KtNamedFunction) && !(overriddenDeclaration instanceof KtProperty) && !(overriddenDeclaration instanceof PsiMethod) && !(overriddenDeclaration instanceof KtParameter)) continue;
            ((Map)overriddenElementsToDescriptor).put(overriddenDeclaration, overriddenDescriptor);
        }
        if ($ignore != null) {
            overriddenElementsToDescriptor.keySet().removeAll($ignore);
        }
        return TuplesKt.to((Object)declarationDescriptor2, overriddenElementsToDescriptor);
    }

    private static final void showWithTransaction$lambda$0(DialogWrapper $this_showWithTransaction) {
        $this_showWithTransaction.show();
    }

    private static final String checkDeclarationConflict$lambda$1$0(String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return s + " already exists";
    }

    private static final Unit replaceWithCopyWithResolveCheck$lambda$0(KtExpression ktExpression) {
        Intrinsics.checkNotNullParameter((Object)ktExpression, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final KtExpression replaceWithCopyWithResolveCheck$lambda$1(KtExpression ktExpression) {
        Intrinsics.checkNotNullParameter((Object)ktExpression, (String)"<this>");
        return ktExpression;
    }
}

