/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.copy;

import com.intellij.ide.util.DirectoryChooser;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.copy.CopyKotlinDeclarationDialog;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinDestinationFolderComboBox;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\u0015\u0018\u0000 52\u00020\u0001:\u00015B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\"\u001a\u00020\rH\u0016J\b\u0010#\u001a\u00020$H\u0014J\n\u0010%\u001a\u0004\u0018\u00010&H\u0014J\n\u00101\u001a\u0004\u0018\u00010(H\u0003J\b\u00102\u001a\u000203H\u0014J\b\u00104\u001a\u00020(H\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0013*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010'\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "defaultTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/psi/PsiDirectory;Lcom/intellij/openapi/project/Project;)V", "informationLabel", "Ljavax/swing/JLabel;", "classNameField", "Lcom/intellij/ui/EditorTextField;", "packageLabel", "packageNameField", "Lcom/intellij/ui/ReferenceEditorComboWithBrowseButton;", "openInEditorCheckBox", "Ljavax/swing/JCheckBox;", "kotlin.jvm.PlatformType", "destinationComboBox", "org/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog$destinationComboBox$1", "Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog$destinationComboBox$1;", "originalFile", "Lcom/intellij/psi/PsiFile;", "value", "Lcom/intellij/refactoring/MoveDestination;", "targetDirectory", "getTargetDirectory", "()Lcom/intellij/refactoring/MoveDestination;", "targetSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTargetSourceRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getPreferredFocusedComponent", "createCenterPanel", "Ljavax/swing/JPanel;", "createNorthPanel", "Ljavax/swing/JComponent;", "qualifiedName", "", "getQualifiedName", "()Ljava/lang/String;", "newName", "getNewName", "openInEditor", "", "getOpenInEditor", "()Z", "checkForErrors", "doOKAction", "", "getHelpId", "Companion", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nCopyKotlinDeclarationDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyKotlinDeclarationDialog.kt\norg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
public final class CopyKotlinDeclarationDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PsiDirectory defaultTargetDirectory;
    @NotNull
    private final Project project;
    @NotNull
    private final JLabel informationLabel;
    @NotNull
    private final EditorTextField classNameField;
    @NotNull
    private final JLabel packageLabel;
    private ReferenceEditorComboWithBrowseButton packageNameField;
    private final JCheckBox openInEditorCheckBox;
    @NotNull
    private final destinationComboBox.1 destinationComboBox;
    private final PsiFile originalFile;
    @Nullable
    private MoveDestination targetDirectory;
    @NonNls
    @NotNull
    private static final String RECENTS_KEY = "CopyKotlinDeclarationDialog.RECENTS_KEY";

    public CopyKotlinDeclarationDialog(@NotNull KtNamedDeclaration declaration, @Nullable PsiDirectory defaultTargetDirectory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true);
        this.defaultTargetDirectory = defaultTargetDirectory;
        this.project = project;
        this.informationLabel = new JLabel();
        this.classNameField = new EditorTextField("");
        this.packageLabel = new JLabel();
        this.openInEditorCheckBox = CopyFilesOrDirectoriesDialog.createOpenInEditorCB();
        this.destinationComboBox = new KotlinDestinationFolderComboBox(this){
            final /* synthetic */ CopyKotlinDeclarationDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public String getTargetPackage() {
                ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = CopyKotlinDeclarationDialog.access$getPackageNameField$p(this.this$0);
                if (referenceEditorComboWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
                    referenceEditorComboWithBrowseButton = null;
                }
                String string = referenceEditorComboWithBrowseButton.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return ((Object)StringsKt.trim((CharSequence)string)).toString();
            }

            protected boolean reportBaseInTestSelectionInSource() {
                return true;
            }
        };
        this.originalFile = declaration.getContainingFile();
        Object[] objectArray = new Object[]{UsageViewUtil.getType((PsiElement)((PsiElement)declaration)), UsageViewUtil.getLongName((PsiElement)((PsiElement)declaration))};
        this.informationLabel.setText(JavaRefactoringBundle.message((String)"copy.class.copy.0.1", (Object[])objectArray));
        this.informationLabel.setFont(this.informationLabel.getFont().deriveFont(1));
        this.init();
        Consumer consumer = (Consumer)Pass.create(arg_0 -> CopyKotlinDeclarationDialog._init_$lambda$1(arg_0 -> CopyKotlinDeclarationDialog._init_$lambda$0(this, arg_0), arg_0));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton = null;
        }
        this.destinationComboBox.setData(this.project, this.defaultTargetDirectory, consumer, (EditorComboBox)referenceEditorComboWithBrowseButton.getChildComponent());
        this.classNameField.setText(UsageViewUtil.getShortName((PsiElement)((PsiElement)declaration)));
        this.classNameField.selectAll();
    }

    @Nullable
    public final MoveDestination getTargetDirectory() {
        return this.targetDirectory;
    }

    @Nullable
    public final VirtualFile getTargetSourceRoot() {
        Object object = this.destinationComboBox.getComboBox().getSelectedItem();
        DirectoryChooser.ItemWrapper itemWrapper = object instanceof DirectoryChooser.ItemWrapper ? (DirectoryChooser.ItemWrapper)object : null;
        PsiFileSystemItem psiFileSystemItem = itemWrapper != null && (itemWrapper = itemWrapper.getDirectory()) != null ? (PsiFileSystemItem)itemWrapper : (PsiFileSystemItem)this.originalFile;
        Intrinsics.checkNotNull((Object)psiFileSystemItem);
        return ProjectRootsUtilKt.getSourceRoot(psiFileSystemItem);
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        return this.classNameField;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    @Nullable
    protected JComponent createNorthPanel() {
        String qualifiedName = this.getQualifiedName();
        this.packageNameField = (ReferenceEditorComboWithBrowseButton)new PackageNameReferenceEditorCombo(qualifiedName, this.project, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton = null;
        }
        referenceEditorComboWithBrowseButton.setTextFieldPreferredWidth(Math.max(qualifiedName.length() + 5, 40));
        this.packageLabel.setText(JavaRefactoringBundle.message((String)"destination.package", (Object[])new Object[0]));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.packageNameField;
        if (referenceEditorComboWithBrowseButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton2 = null;
        }
        this.packageLabel.setLabelFor((Component)referenceEditorComboWithBrowseButton2);
        JLabel label2 = new JLabel(RefactoringBundle.message((String)"target.destination.folder"));
        boolean isMultipleSourceRoots = ProjectRootUtilsKt.getSuitableDestinationSourceRoots(this.project).size() > 1;
        this.destinationComboBox.setVisible(isMultipleSourceRoots);
        label2.setVisible(isMultipleSourceRoots);
        label2.setLabelFor((Component)((Object)this.destinationComboBox));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.openInEditorCheckBox, "East");
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)this.informationLabel).addLabeledComponent(RefactoringBundle.message((String)"copy.files.new.name.label"), (JComponent)this.classNameField, 12);
        JComponent jComponent = this.packageLabel;
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton3 = this.packageNameField;
        if (referenceEditorComboWithBrowseButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton3 = null;
        }
        return formBuilder.addLabeledComponent(jComponent, (JComponent)referenceEditorComboWithBrowseButton3).addLabeledComponent((JComponent)label2, (JComponent)((Object)this.destinationComboBox)).addComponent((JComponent)panel).getPanel();
    }

    private final String getQualifiedName() {
        Object object;
        block3: {
            block2: {
                object = this.defaultTargetDirectory;
                if (object == null) break block2;
                PsiDirectory it = object;
                boolean bl = false;
                JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
                Intrinsics.checkNotNull((Object)javaDirectoryService);
                PsiPackage psiPackage = javaDirectoryService.getPackage(it);
                object = psiPackage;
                if (psiPackage != null && (object = object.getQualifiedName()) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getNewName() {
        String string = this.classNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public final boolean getOpenInEditor() {
        return this.openInEditorCheckBox.isSelected();
    }

    @NlsContexts.DialogMessage
    @Nls
    private final String checkForErrors() {
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton = null;
        }
        String packageName = referenceEditorComboWithBrowseButton.getText();
        String newName = this.getNewName();
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager manager = psiManager;
        Intrinsics.checkNotNull((Object)packageName);
        if (((CharSequence)packageName).length() > 0 && !KotlinCommonRefactoringUtilKt.hasIdentifiersOnly(new FqNameUnsafe(packageName))) {
            return JavaRefactoringBundle.message((String)"invalid.target.package.name.specified", (Object[])new Object[0]);
        }
        if (((CharSequence)newName).length() == 0) {
            return JavaRefactoringBundle.message((String)"no.class.name.specified", (Object[])new Object[0]);
        }
        try {
            this.targetDirectory = this.destinationComboBox.selectDirectory(new PackageWrapper(manager, packageName), false);
        }
        catch (IncorrectOperationException e) {
            return e.getMessage();
        }
        MoveDestination moveDestination = this.targetDirectory;
        if (moveDestination != null && (moveDestination = moveDestination.getTargetIfExists(this.defaultTargetDirectory)) != null) {
            MoveDestination it = moveDestination;
            boolean bl = false;
            String targetFileName = newName + "." + this.originalFile.getVirtualFile().getExtension();
            if (Intrinsics.areEqual((Object)it.findFile(targetFileName), (Object)this.originalFile)) {
                return KotlinBundle.message((String)"error.text.can.t.copy.class.to.the.containing.file", (Object[])new Object[0]);
            }
        }
        return null;
    }

    protected void doOKAction() {
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.packageNameField;
        if (referenceEditorComboWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"packageNameField");
            referenceEditorComboWithBrowseButton = null;
        }
        String packageName = referenceEditorComboWithBrowseButton.getText();
        String checkForErrors = this.checkForErrors();
        if (checkForErrors != null) {
            if (((CharSequence)checkForErrors).length() > 0) {
                Messages.showMessageDialog((Project)this.project, (String)checkForErrors, (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
            this.classNameField.requestFocusInWindow();
            return;
        }
        RecentsManager.getInstance((Project)this.project).registerRecentEntry(RECENTS_KEY, packageName);
        CopyFilesOrDirectoriesDialog.saveOpenInEditorState((boolean)this.openInEditorCheckBox.isSelected());
        super.doOKAction();
    }

    @NotNull
    protected String getHelpId() {
        return "refactoring.copyClass";
    }

    private static final Unit _init_$lambda$0(CopyKotlinDeclarationDialog this$0, String it) {
        this$0.setErrorText(it, (JComponent)((Object)this$0.destinationComboBox));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ ReferenceEditorComboWithBrowseButton access$getPackageNameField$p(CopyKotlinDeclarationDialog $this) {
        return $this.packageNameField;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/copy/CopyKotlinDeclarationDialog$Companion;", "", "<init>", "()V", "RECENTS_KEY", "", "kotlin.refactorings.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

