/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.cutPaste;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsProcessor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J!\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsIntentionAction;", "Lcom/intellij/refactoring/BaseRefactoringIntentionAction;", "Lcom/intellij/codeInspection/HintAction;", "processor", "Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsProcessor;", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "modificationCount", "", "<init>", "(Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsProcessor;Lcom/intellij/openapi/editor/RangeMarker;J)V", "startInWriteAction", "", "getText", "", "getFamilyName", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "showHint", "kotlin.idea"})
public final class MoveDeclarationsIntentionAction
extends BaseRefactoringIntentionAction
implements HintAction {
    @NotNull
    private final MoveDeclarationsProcessor processor;
    @NotNull
    private final RangeMarker bounds;
    private final long modificationCount;

    public MoveDeclarationsIntentionAction(@NotNull MoveDeclarationsProcessor processor2, @NotNull RangeMarker bounds, long modificationCount) {
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.processor = processor2;
        this.bounds = bounds;
        this.modificationCount = modificationCount;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.processor.getPastedDeclarations().size()};
        return KotlinBundle.message((String)"text.update.usages.to.reflect.declaration.0.move", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"family.name.update.usages.on.declarations.cut.paste", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return PsiModificationTracker.getInstance((Project)this.processor.getProject()).getModificationCount() == this.modificationCount;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.processor.performRefactoring();
    }

    public boolean showHint(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = RangeMarkersKt.getAsTextRange((RangeMarker)this.bounds);
        if (textRange == null) {
            return false;
        }
        TextRange range2 = textRange;
        if (editor.getCaretModel().getOffset() != range2.getEndOffset()) {
            return false;
        }
        if (PsiModificationTracker.getInstance((Project)this.processor.getProject()).getModificationCount() != this.modificationCount) {
            return false;
        }
        String hintText = this.getText() + "? " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        HintManager.getInstance().showQuestionHint(editor, hintText, range2.getEndOffset(), range2.getEndOffset(), () -> MoveDeclarationsIntentionAction.showHint$lambda$0(this));
        return true;
    }

    private static final boolean showHint$lambda$0(MoveDeclarationsIntentionAction this$0) {
        this$0.processor.performRefactoring();
        return true;
    }
}

