/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.helper;

import com.intellij.formatting.service.PostQuickFixTaskService;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinOptimizeImportsFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.helper.KotlinOptimizeImportsRefactoringHelper;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ/\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper;", "Lcom/intellij/refactoring/RefactoringHelper;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "()V", "prepareOperation", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Ljava/util/Set;", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/usageView/UsageInfo;Ljava/util/List;)Ljava/util/Set;", "performOperation", "", "project", "Lcom/intellij/openapi/project/Project;", "operationData", "CollectUnusedImportsTask", "OptimizeImportsTask", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKotlinOptimizeImportsRefactoringHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinOptimizeImportsRefactoringHelper.kt\norg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n12042#2:121\n14060#2:122\n14061#2:124\n12043#2:125\n1#3:123\n1#3:137\n1642#4,10:126\n1915#4:136\n1916#4:138\n1652#4:139\n777#4:140\n873#4,2:141\n*S KotlinDebug\n*F\n+ 1 KotlinOptimizeImportsRefactoringHelper.kt\norg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper\n*L\n88#1:121\n88#1:122\n88#1:124\n88#1:125\n88#1:123\n94#1:137\n94#1:126,10\n94#1:136\n94#1:138\n94#1:139\n95#1:140\n95#1:141,2\n*E\n"})
public final class KotlinOptimizeImportsRefactoringHelper
implements RefactoringHelper<Set<? extends KtFile>> {
    /*
     * WARNING - void declaration
     */
    private final Set<KtFile> prepareOperation(UsageInfo[] usages2) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        UsageInfo[] usageInfoArray = usages2;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            KtFile it$iv;
            PsiFile psiFile;
            void element$iv$iv;
            void element$iv = element$iv$iv = $this$forEach$iv$iv[j];
            boolean bl = false;
            void it = element$iv;
            boolean bl2 = false;
            if ((!it.isNonCodeUsage ? ((psiFile = it.getFile()) instanceof KtFile ? (KtFile)psiFile : null) : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<KtFile> prepareOperation(@NotNull UsageInfo[] usages2, @NotNull List<? extends PsiElement> elements) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable iterable = elements;
        Set<KtFile> set = this.prepareOperation(usages2);
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            PsiFile psiFile = it.getContainingFile();
            if ((psiFile instanceof KtFile ? (KtFile)psiFile : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!ProjectFileIndex.getInstance((Project)((PsiElement)CollectionsKt.first(elements)).getProject()).isInSourceContent(it.getVirtualFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return SetsKt.plus(set, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    public void performOperation(@NotNull Project project, @NotNull Set<? extends KtFile> operationData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(operationData, (String)"operationData");
        if (operationData.isEmpty()) {
            return;
        }
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> KotlinOptimizeImportsRefactoringHelper.performOperation$lambda$0(project));
        Set unusedImports = new LinkedHashSet();
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        ProgressManager progressManager2 = progressManager;
        CollectUnusedImportsTask collectTask2 = new CollectUnusedImportsTask(project, unusedImports, operationData, progressManager2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Set<SmartPsiElementPointer<KtImportDirective>> $unusedImports;
            final /* synthetic */ ProgressManager $progressManager;
            {
                this.$project = $project;
                this.$unusedImports = $unusedImports;
                this.$progressManager = $progressManager;
                super($project, $unusedImports, $operationData);
            }

            public void onSuccess() {
                OptimizeImportsTask progressTask = new OptimizeImportsTask(this.$project, this.$unusedImports);
                this.$progressManager.run((Task)progressTask);
            }
        };
        PostQuickFixTaskService.Companion.getInstance(project).runOrRegisterPostQuickFixTask(CollectionsKt.emptyList(), () -> KotlinOptimizeImportsRefactoringHelper.performOperation$lambda$1(progressManager2, collectTask2));
    }

    private static final void performOperation$lambda$0(Project $project) {
        PsiDocumentManager.getInstance((Project)$project).commitAllDocuments();
    }

    private static final Unit performOperation$lambda$1(ProgressManager $progressManager, performOperation.collectTask.1 $collectTask) {
        $progressManager.run((Task)$collectTask);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$CollectUnusedImportsTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "unusedImports", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "operationData", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Ljava/util/Set;)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "kotlin.refactorings.common"})
    @SourceDebugExtension(value={"SMAP\nKotlinOptimizeImportsRefactoringHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinOptimizeImportsRefactoringHelper.kt\norg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$CollectUnusedImportsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1661#2,3:121\n*S KotlinDebug\n*F\n+ 1 KotlinOptimizeImportsRefactoringHelper.kt\norg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$CollectUnusedImportsTask\n*L\n50#1:121,3\n*E\n"})
    public static class CollectUnusedImportsTask
    extends Task.Modal {
        @NotNull
        private final Set<SmartPsiElementPointer<KtImportDirective>> unusedImports;
        @NotNull
        private final Set<KtFile> operationData;

        public CollectUnusedImportsTask(@NotNull Project project, @NotNull Set<SmartPsiElementPointer<KtImportDirective>> unusedImports, @NotNull Set<? extends KtFile> operationData) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(unusedImports, (String)"unusedImports");
            Intrinsics.checkNotNullParameter(operationData, (String)"operationData");
            super(project, KotlinBundle.message((String)"optimize.imports.collect.unused.imports", (Object[])new Object[0]), true);
            this.unusedImports = unusedImports;
            this.operationData = operationData;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.setIndeterminate(false);
            int myTotalCount = this.operationData.size();
            Iterator iterator2 = ((Iterable)this.operationData).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int counter = n++;
                KtFile file = (KtFile)iterator2.next();
                ActionsKt.runReadAction(() -> CollectUnusedImportsTask.run$lambda$0(file, indicator, counter, myTotalCount, this));
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit run$lambda$0(KtFile $file, ProgressIndicator $indicator, int $counter, int $myTotalCount, CollectUnusedImportsTask this$0) {
            block3: {
                void $this$mapTo$iv;
                VirtualFile virtualFile = $file.getVirtualFile();
                if (virtualFile == null) {
                    return Unit.INSTANCE;
                }
                VirtualFile virtualFile2 = virtualFile;
                $indicator.setFraction((double)$counter / (double)$myTotalCount);
                $indicator.setText2(virtualFile2.getPresentableUrl());
                if (!$file.isValid()) {
                    return Unit.INSTANCE;
                }
                KotlinOptimizeImportsFacility.ImportData importData = KotlinOptimizeImportsFacility.Companion.getInstance().analyzeImports($file);
                Object object = importData;
                if (object == null || (object = object.getUnusedImports()) == null) break block3;
                Iterable iterable = (Iterable)object;
                Collection destination$iv = this$0.unusedImports;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    KtImportDirective ktImportDirective = (KtImportDirective)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)it)));
                }
                Set cfr_ignored_0 = (Set)destination$iv;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$OptimizeImportsTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "pointers", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "kotlin.refactorings.common"})
    public static final class OptimizeImportsTask
    extends Task.Modal {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Set<SmartPsiElementPointer<KtImportDirective>> pointers;
        @NotNull
        private static final Logger LOG;

        public OptimizeImportsTask(@NotNull Project project, @NotNull Set<? extends SmartPsiElementPointer<KtImportDirective>> pointers) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(pointers, (String)"pointers");
            super(project, KotlinBundle.message((String)"optimize.imports.task.removing.redundant.imports", (Object[])new Object[0]), false);
            this.pointers = pointers;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.setIndeterminate(false);
            int myTotal = this.pointers.size();
            Iterator iterator2 = ((Iterable)this.pointers).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                String presentableUrl;
                VirtualFile virtualFile;
                int counter = n++;
                SmartPsiElementPointer pointer = (SmartPsiElementPointer)iterator2.next();
                indicator.setFraction((double)counter / (double)myTotal);
                if ((VirtualFile)ActionsKt.runReadAction(() -> OptimizeImportsTask.run$lambda$0(pointer)) == null) continue;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile.getPresentableUrl(), (String)"getPresentableUrl(...)");
                indicator.setText2(presentableUrl);
                ApplicationManager.getApplication().invokeAndWait(() -> OptimizeImportsTask.run$lambda$1$0(this, presentableUrl, pointer));
            }
        }

        private static final Unit run$lambda$1$0$0(SmartPsiElementPointer $pointer) {
            try {
                KtImportDirective ktImportDirective = (KtImportDirective)$pointer.getElement();
                if (ktImportDirective != null) {
                    ktImportDirective.delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return Unit.INSTANCE;
        }

        private static final void run$lambda$1$0(OptimizeImportsTask this$0, String $presentableUrl, SmartPsiElementPointer $pointer) {
            Project project = this$0.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Object[] objectArray = new Object[]{$presentableUrl};
            ApplicationUtilsKt.executeWriteCommand(project, KotlinBundle.message((String)"delete.0", (Object[])objectArray), (Function0<Unit>)((Function0)() -> OptimizeImportsTask.run$lambda$1$0$0($pointer)));
        }

        private static final VirtualFile run$lambda$0(SmartPsiElementPointer $pointer) {
            return PsiUtilCore.getVirtualFile((PsiElement)$pointer.getElement());
        }

        static {
            Logger logger = Logger.getInstance((String)("#" + OptimizeImportsTask.class.getName()));
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/helper/KotlinOptimizeImportsRefactoringHelper$OptimizeImportsTask$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.refactorings.common"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

