/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline.codeInliner;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.MutableCodeToInline;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.ReplacementPerformer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000bH$\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u00028\u00002\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0013\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/codeInliner/AbstractSimpleReplacementPerformer;", "TElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/codeInliner/ReplacementPerformer;", "codeToInline", "Lorg/jetbrains/kotlin/idea/refactoring/inline/codeInliner/MutableCodeToInline;", "elementToBeReplaced", "<init>", "(Lorg/jetbrains/kotlin/idea/refactoring/inline/codeInliner/MutableCodeToInline;Lorg/jetbrains/kotlin/psi/KtElement;)V", "createDummyElement", "mainExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtElement;", "rangeToElement", "range", "Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "(Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;)Lorg/jetbrains/kotlin/psi/KtElement;", "doIt", "postProcessing", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.refactorings.common"})
public abstract class AbstractSimpleReplacementPerformer<TElement extends KtElement>
extends ReplacementPerformer<TElement> {
    public AbstractSimpleReplacementPerformer(@NotNull MutableCodeToInline codeToInline, @NotNull TElement elementToBeReplaced) {
        Intrinsics.checkNotNullParameter((Object)codeToInline, (String)"codeToInline");
        Intrinsics.checkNotNullParameter(elementToBeReplaced, (String)"elementToBeReplaced");
        super(codeToInline, elementToBeReplaced);
    }

    @NotNull
    protected abstract TElement createDummyElement(@NotNull KtExpression var1);

    @NotNull
    protected TElement rangeToElement(@NotNull PsiChildRange range2) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        boolean bl = Intrinsics.areEqual((Object)range2.getFirst(), (Object)range2.getLast());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiElement psiElement = range2.getFirst();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type TElement of org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.AbstractSimpleReplacementPerformer");
        return (TElement)((KtElement)psiElement);
    }

    @Override
    @NotNull
    public final TElement doIt(@NotNull Function1<? super PsiChildRange, PsiChildRange> postProcessing) {
        Intrinsics.checkNotNullParameter(postProcessing, (String)"postProcessing");
        boolean bl = this.getCodeToInline().getStatementsBefore().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        KtExpression ktExpression = this.getCodeToInline().getMainExpression();
        if (ktExpression == null) {
            throw new IllegalStateException("mainExpression mustn't be null".toString());
        }
        KtExpression mainExpression = ktExpression;
        TElement dummyElement = this.createDummyElement(mainExpression);
        PsiElement replaced = ((PsiElement)this.getElementToBeReplaced()).replace((PsiElement)dummyElement);
        this.getCodeToInline().performPostInsertionActions(CollectionsKt.listOf((Object)replaced));
        Intrinsics.checkNotNull((Object)replaced);
        return this.rangeToElement((PsiChildRange)postProcessing.invoke((Object)PsiChildRange.Companion.singleElement(replaced)));
    }
}

