/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.AnalysisResult;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorWithException;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractableCodeDescriptorWithConflicts;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionData;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionEngineHelper;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionResult;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u0003*\u000e\b\u0002\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00010\u0005*\u000e\b\u0003\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00010\u0007*\u000e\b\u0004\u0010\b*\b\u0012\u0004\u0012\u0002H\u00010\t*\u000e\b\u0005\u0010\n*\b\u0012\u0004\u0012\u0002H\u00010\u000b2\u00020\fB3\u0012*\u0010\r\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0015\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0016J1\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00028\u00012\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\u00180\u001c\u00a2\u0006\u0002\u0010\u001dR5\u0010\r\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00050\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngine;", "KotlinType", "ExtractionData", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionData;", "Config", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionGeneratorConfiguration;", "Result", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionResult;", "Descriptor", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractableCodeDescriptor;", "DescriptorWithConflicts", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractableCodeDescriptorWithConflicts;", "", "helper", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngineHelper;", "<init>", "(Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngineHelper;)V", "getHelper", "()Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngineHelper;", "performAnalysis", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/AnalysisResult;", "extractionData", "(Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionData;)Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/AnalysisResult;", "run", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "onFinish", "Lkotlin/Function1;", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionData;Lkotlin/jvm/functions/Function1;)V", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nIExtractionEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IExtractionEngine.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1586#2:173\n1661#2,3:174\n1#3:177\n*S KotlinDebug\n*F\n+ 1 IExtractionEngine.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IExtractionEngine\n*L\n105#1:173\n105#1:174,3\n*E\n"})
public abstract class IExtractionEngine<KotlinType, ExtractionData extends IExtractionData, Config extends IExtractionGeneratorConfiguration<KotlinType>, Result extends IExtractionResult<KotlinType>, Descriptor extends IExtractableCodeDescriptor<KotlinType>, DescriptorWithConflicts extends IExtractableCodeDescriptorWithConflicts<KotlinType>> {
    @NotNull
    private final IExtractionEngineHelper<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> helper;

    public IExtractionEngine(@NotNull IExtractionEngineHelper<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> helper2) {
        Intrinsics.checkNotNullParameter(helper2, (String)"helper");
        this.helper = helper2;
    }

    @NotNull
    public final IExtractionEngineHelper<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> getHelper() {
        return this.helper;
    }

    @NotNull
    public abstract AnalysisResult<KotlinType> performAnalysis(@NotNull ExtractionData var1);

    /*
     * WARNING - void declaration
     */
    public final void run(@NotNull Editor editor, @NotNull ExtractionData extractionData, @NotNull Function1<? super Result, Unit> onFinish) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(extractionData, (String)"extractionData");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        Project project = extractionData.getProject();
        ExtractionData adjustExtractionData = this.helper.adjustExtractionData(extractionData);
        AnalysisResult analysisResult = (AnalysisResult)ActionUtil.underModalProgress((Project)project, (String)KotlinBundle.message((String)"progress.title.analyze.extraction.data", (Object[])new Object[0]), () -> IExtractionEngine.run$lambda$1(this, adjustExtractionData));
        if (ApplicationManager.getApplication().isUnitTestMode() && analysisResult.getStatus() != AnalysisResult.Status.SUCCESS) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = analysisResult.getMessages();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AnalysisResult.ErrorMessage errorMessage = (AnalysisResult.ErrorMessage)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.renderMessage());
            }
            Collection collection = (List)destination$iv$iv;
            throw new BaseRefactoringProcessor.ConflictsInTestsException(collection);
        }
        String message2 = CollectionsKt.joinToString$default((Iterable)analysisResult.getMessages(), (CharSequence)"\n", null, null, (int)0, null, IExtractionEngine::run$lambda$6, (int)30, null);
        switch (WhenMappings.$EnumSwitchMapping$0[analysisResult.getStatus().ordinal()]) {
            case 1: {
                IntroduceUtilsKt.showErrorHint(project, editor, message2, this.helper.getOperationName());
                break;
            }
            case 2: {
                Component component = editor.getContentComponent();
                VisualPosition visualPosition = editor.getSelectionModel().getSelectionStartPosition();
                Intrinsics.checkNotNull((Object)visualPosition);
                RelativePoint anchorPoint = new RelativePoint(component, editor.visualPositionToXY(visualPosition));
                String htmlContent = message2 + "<br/><br/><a href=\"EXTRACT\">" + KotlinBundle.message((String)"text.proceed.with.extraction", (Object[])new Object[0]) + "</a>";
                JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
                Intrinsics.checkNotNull((Object)jBPopupFactory);
                jBPopupFactory.createHtmlTextBalloonBuilder(htmlContent, MessageType.WARNING, arg_0 -> IExtractionEngine.run$lambda$7(project, this, analysisResult, editor, onFinish, extractionData, arg_0)).setHideOnClickOutside(true).setHideOnFrameResize(false).setHideOnLinkClick(true).createBalloon().show(anchorPoint, Balloon.Position.below);
                break;
            }
            case 3: {
                IExtractionEngine.run$validateAndRefactor(project, this, analysisResult, editor, onFinish, extractionData);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static /* synthetic */ void run$default(IExtractionEngine iExtractionEngine, Editor editor, IExtractionData iExtractionData, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: run");
        }
        if ((n & 4) != 0) {
            function1 = IExtractionEngine::run$lambda$0;
        }
        iExtractionEngine.run(editor, iExtractionData, function1);
    }

    private static final Unit run$lambda$0(IExtractionResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit run$validateAndRefactor$lambda$4$1$0(Function1 $onFinish, IExtractionData $extractionData, IExtractionResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            $onFinish.invoke((Object)it);
        }
        finally {
            ((Disposable)it).dispose();
            ((Disposable)$extractionData).dispose();
        }
        return Unit.INSTANCE;
    }

    private static final Unit run$validateAndRefactor$lambda$4$1(IExtractionEngine this$0, Project $project, Editor $editor, IExtractableCodeDescriptorWithConflicts $validationResult, Function1 $onFinish, IExtractionData $extractionData) {
        this$0.helper.configureAndRun($project, $editor, $validationResult, arg_0 -> IExtractionEngine.run$validateAndRefactor$lambda$4$1$0($onFinish, $extractionData, arg_0));
        return Unit.INSTANCE;
    }

    private static final Object run$validateAndRefactor$lambda$3(IExtractionEngine this$0, AnalysisResult $analysisResult) {
        Object object;
        try {
            IExtractionEngineHelper iExtractionEngineHelper = this$0.helper;
            IExtractableCodeDescriptor iExtractableCodeDescriptor = $analysisResult.getDescriptor();
            Intrinsics.checkNotNull(iExtractableCodeDescriptor, (String)"null cannot be cast to non-null type Descriptor of org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IExtractionEngine");
            object = iExtractionEngineHelper.validate(iExtractableCodeDescriptor);
        }
        catch (RuntimeException e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            object = new ExtractableCodeDescriptorWithException(e);
        }
        return object;
    }

    private static final Unit run$validateAndRefactor$lambda$4(Project $project, IExtractionEngine this$0, Editor $editor, Function1 $onFinish, IExtractionData $extractionData, Object result2) {
        ExtractableCodeDescriptorWithException extractableCodeDescriptorWithException;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        ExtractableCodeDescriptorWithException extractableCodeDescriptorWithException2 = extractableCodeDescriptorWithException = result2 instanceof ExtractableCodeDescriptorWithException ? (ExtractableCodeDescriptorWithException)result2 : null;
        if (extractableCodeDescriptorWithException != null) {
            ExtractableCodeDescriptorWithException it = extractableCodeDescriptorWithException;
            boolean bl = false;
            throw it.getException();
        }
        IExtractableCodeDescriptorWithConflicts validationResult = (IExtractableCodeDescriptorWithConflicts)result2;
        KotlinCommonRefactoringUtilKt.checkConflictsInteractively$default($project, validationResult.getConflicts(), null, () -> IExtractionEngine.run$validateAndRefactor$lambda$4$1(this$0, $project, $editor, validationResult, $onFinish, $extractionData), 2, null);
        return Unit.INSTANCE;
    }

    private static final Object run$validateAndRefactor$lambda$5(Function0 $tmp0) {
        return $tmp0.invoke();
    }

    private static final AnalysisResult run$lambda$1(IExtractionEngine this$0, IExtractionData $adjustExtractionData) {
        return this$0.performAnalysis($adjustExtractionData);
    }

    private static final <KotlinType, ExtractionData extends IExtractionData, Config extends IExtractionGeneratorConfiguration<KotlinType>, Result extends IExtractionResult<KotlinType>, Descriptor extends IExtractableCodeDescriptor<KotlinType>, DescriptorWithConflicts extends IExtractableCodeDescriptorWithConflicts<KotlinType>> void run$validateAndRefactor(Project project, IExtractionEngine<KotlinType, ExtractionData, Config, Result, Descriptor, DescriptorWithConflicts> this$0, AnalysisResult<KotlinType> analysisResult, Editor $editor, Function1<? super Result, Unit> $onFinish, ExtractionData $extractionData) {
        Function0 callable = () -> IExtractionEngine.run$validateAndRefactor$lambda$3(this$0, analysisResult);
        Function1 finishOnUIThread = arg_0 -> IExtractionEngine.run$validateAndRefactor$lambda$4(project, this$0, $editor, $onFinish, $extractionData, arg_0);
        Object result2 = ActionUtil.underModalProgress((Project)project, (String)KotlinBundle.message((String)"progress.title.check.for.conflicts", (Object[])new Object[0]), () -> IExtractionEngine.run$validateAndRefactor$lambda$5(callable));
        if (result2 != null) {
            finishOnUIThread.invoke(result2);
        }
    }

    private static final CharSequence run$lambda$6(AnalysisResult.ErrorMessage it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.renderMessage();
    }

    private static final void run$lambda$7(Project $project, IExtractionEngine this$0, AnalysisResult $analysisResult, Editor $editor, Function1 $onFinish, IExtractionData $extractionData, HyperlinkEvent event) {
        HyperlinkEvent hyperlinkEvent = event;
        if (Intrinsics.areEqual((Object)(hyperlinkEvent != null ? hyperlinkEvent.getEventType() : null), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            IExtractionEngine.run$validateAndRefactor($project, this$0, $analysisResult, $editor, $onFinish, $extractionData);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnalysisResult.Status.values().length];
            try {
                nArray[AnalysisResult.Status.CRITICAL_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalysisResult.Status.NON_CRITICAL_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnalysisResult.Status.SUCCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

