/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.pseudocode.TypePredicate;
import org.jetbrains.kotlin.cfg.pseudocode.TypePredicateKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableAnalysisUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IMutableParameter;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u001eJ\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000309H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010*\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0012\"\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0012R\u001c\u00100\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0012\"\u0004\b2\u0010-R\u001b\u00103\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b4\u00105R!\u00108\u001a\b\u0012\u0004\u0012\u00020\u0003098BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u00107\u001a\u0004\b:\u0010;R\u0014\u0010>\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u00105\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/MutableParameter;", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/Parameter;", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IMutableParameter;", "Lorg/jetbrains/kotlin/types/KotlinType;", "argumentText", "", "originalDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "receiverCandidate", "", "targetScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "originalType", "possibleTypes", "", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;ZLorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/types/KotlinType;Ljava/util/Set;)V", "getArgumentText", "()Ljava/lang/String;", "getOriginalDescriptor", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getReceiverCandidate", "()Z", "contextParameter", "getContextParameter", "writable", "defaultTypes", "Ljava/util/LinkedHashSet;", "typePredicates", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/cfg/pseudocode/TypePredicate;", "refCount", "", "getRefCount", "()I", "setRefCount", "(I)V", "addDefaultType", "", "kotlinType", "addTypePredicate", "predicate", "currentName", "getCurrentName", "setCurrentName", "(Ljava/lang/String;)V", "name", "getName", "mirrorVarName", "getMirrorVarName", "setMirrorVarName", "defaultType", "getDefaultType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "defaultType$delegate", "Lkotlin/Lazy;", "allParameterTypeCandidates", "", "getAllParameterTypeCandidates", "()Ljava/util/List;", "allParameterTypeCandidates$delegate", "getParameterTypeCandidates", "parameterType", "getParameterType", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nextractableAnalysisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extractableAnalysisUtil.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/MutableParameter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,746:1\n1#2:747\n777#3:748\n873#3,2:749\n777#3:751\n873#3,2:752\n*S KotlinDebug\n*F\n+ 1 extractableAnalysisUtil.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/MutableParameter\n*L\n317#1:748\n317#1:749,2\n304#1:751\n304#1:752,2\n*E\n"})
public final class MutableParameter
implements Parameter,
IMutableParameter<KotlinType> {
    @NotNull
    private final String argumentText;
    @NotNull
    private final DeclarationDescriptor originalDescriptor;
    private final boolean receiverCandidate;
    @Nullable
    private final LexicalScope targetScope;
    @NotNull
    private final KotlinType originalType;
    @NotNull
    private final Set<KotlinType> possibleTypes;
    private final boolean contextParameter;
    private boolean writable;
    @NotNull
    private final LinkedHashSet<KotlinType> defaultTypes;
    @NotNull
    private final HashSet<TypePredicate> typePredicates;
    private int refCount;
    @Nullable
    private String currentName;
    @Nullable
    private String mirrorVarName;
    @NotNull
    private final Lazy defaultType$delegate;
    @NotNull
    private final Lazy allParameterTypeCandidates$delegate;

    public MutableParameter(@NotNull String argumentText, @NotNull DeclarationDescriptor originalDescriptor, boolean receiverCandidate, @Nullable LexicalScope targetScope, @NotNull KotlinType originalType, @NotNull Set<? extends KotlinType> possibleTypes) {
        Intrinsics.checkNotNullParameter((Object)argumentText, (String)"argumentText");
        Intrinsics.checkNotNullParameter((Object)originalDescriptor, (String)"originalDescriptor");
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        Intrinsics.checkNotNullParameter(possibleTypes, (String)"possibleTypes");
        this.argumentText = argumentText;
        this.originalDescriptor = originalDescriptor;
        this.receiverCandidate = receiverCandidate;
        this.targetScope = targetScope;
        this.originalType = originalType;
        this.possibleTypes = possibleTypes;
        this.writable = true;
        this.defaultTypes = new LinkedHashSet();
        this.typePredicates = new HashSet();
        this.defaultType$delegate = LazyKt.lazy(() -> MutableParameter.defaultType_delegate$lambda$0(this));
        this.allParameterTypeCandidates$delegate = LazyKt.lazy(() -> MutableParameter.allParameterTypeCandidates_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public String getArgumentText() {
        return this.argumentText;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginalDescriptor() {
        return this.originalDescriptor;
    }

    @Override
    public boolean getReceiverCandidate() {
        return this.receiverCandidate;
    }

    @Override
    public boolean getContextParameter() {
        return this.contextParameter;
    }

    @Override
    public int getRefCount() {
        return this.refCount;
    }

    @Override
    public void setRefCount(int n) {
        this.refCount = n;
    }

    public final void addDefaultType(@NotNull KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        boolean bl = this.writable;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Can't add type to non-writable parameter " + this.currentName;
            throw new AssertionError((Object)string);
        }
        if (this.possibleTypes.contains(kotlinType)) {
            this.defaultTypes.add(kotlinType);
        }
    }

    public final void addTypePredicate(@NotNull TypePredicate predicate2) {
        Intrinsics.checkNotNullParameter((Object)predicate2, (String)"predicate");
        boolean bl = this.writable;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Can't add type predicate to non-writable parameter " + this.currentName;
            throw new AssertionError((Object)string);
        }
        this.typePredicates.add(predicate2);
    }

    @Nullable
    public final String getCurrentName() {
        return this.currentName;
    }

    public final void setCurrentName(@Nullable String string) {
        this.currentName = string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.currentName;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @Nullable
    public String getMirrorVarName() {
        return this.mirrorVarName;
    }

    public void setMirrorVarName(@Nullable String string) {
        this.mirrorVarName = string;
    }

    private final KotlinType getDefaultType() {
        Lazy lazy = this.defaultType$delegate;
        return (KotlinType)lazy.getValue();
    }

    private final List<KotlinType> getAllParameterTypeCandidates() {
        Lazy lazy = this.allParameterTypeCandidates$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KotlinType> getParameterTypeCandidates() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllParameterTypeCandidates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl = false;
            if (!ExtractableAnalysisUtilKt.access$isExtractable(it, this.targetScope)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public KotlinType getParameterType() {
        KotlinType kotlinType = (KotlinType)CollectionsKt.firstOrNull(this.getParameterTypeCandidates());
        if (kotlinType == null) {
            kotlinType = this.getDefaultType();
        }
        return kotlinType;
    }

    private static final KotlinType defaultType_delegate$lambda$0(MutableParameter this$0) {
        KotlinType kotlinType;
        this$0.writable = false;
        if (!((Collection)this$0.defaultTypes).isEmpty()) {
            KotlinType kotlinType2 = TypeIntersector.intersectTypes((Collection)this$0.defaultTypes);
            kotlinType = kotlinType2;
            Intrinsics.checkNotNull((Object)kotlinType2);
        } else {
            kotlinType = this$0.originalType;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private static final List allParameterTypeCandidates_delegate$lambda$0(MutableParameter this$0) {
        void $this$filterTo$iv$iv;
        LinkedHashSet<KotlinType> linkedHashSet;
        this$0.writable = false;
        TypePredicate typePredicate = TypePredicateKt.and((Collection)this$0.typePredicates);
        if (FlexibleTypesKt.isFlexible((KotlinType)this$0.getDefaultType())) {
            LinkedHashSet<KotlinType> linkedHashSet2;
            bounds = FlexibleTypesKt.asFlexibleType((KotlinType)this$0.getDefaultType());
            LinkedHashSet<KotlinType> $this$allParameterTypeCandidates_delegate_u24lambda_u240_u240 = linkedHashSet2 = new LinkedHashSet<KotlinType>();
            boolean bl = false;
            if (typePredicate.invoke((KotlinType)bounds.getUpperBound()).booleanValue()) {
                $this$allParameterTypeCandidates_delegate_u24lambda_u240_u240.add((KotlinType)bounds.getUpperBound());
            }
            if (typePredicate.invoke((KotlinType)bounds.getLowerBound()).booleanValue()) {
                $this$allParameterTypeCandidates_delegate_u24lambda_u240_u240.add((KotlinType)bounds.getLowerBound());
            }
            linkedHashSet = linkedHashSet2;
        } else {
            bounds = new FlexibleType[]{this$0.getDefaultType()};
            linkedHashSet = SetsKt.linkedSetOf((Object[])bounds);
        }
        LinkedHashSet<KotlinType> typeSet = linkedHashSet;
        boolean addNullableTypes = FlexibleTypesKt.isNullabilityFlexible((KotlinType)this$0.getDefaultType()) && typeSet.size() > 1;
        Set set = TypeUtils.getAllSupertypes((KotlinType)this$0.getDefaultType());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllSupertypes(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)((Function1)typePredicate).invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List superTypes2 = (List)destination$iv$iv;
        for (KotlinType superType : superTypes2) {
            if (addNullableTypes) {
                Intrinsics.checkNotNull((Object)superType);
                typeSet.add(TypeUtilsKt.makeNullable((KotlinType)superType));
            }
            typeSet.add(superType);
        }
        return CollectionsKt.toList((Iterable)typeSet);
    }
}

