/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.IParameter;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0004\u000b\f\r\u000eR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue;", "KotlinType", "", "originalExpressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getOriginalExpressions", "()Ljava/util/List;", "valueType", "getValueType", "()Ljava/lang/Object;", "ExpressionValue", "Jump", "ParameterUpdate", "Initializer", "kotlin.refactorings.common"})
public interface OutputValue<KotlinType> {
    @NotNull
    public List<KtExpression> getOriginalExpressions();

    public KotlinType getValueType();

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00028\u0001\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\t\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue$ExpressionValue;", "KotlinType", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue;", "callSiteReturn", "", "hasImplicitReturn", "originalExpressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "valueType", "<init>", "(ZZLjava/util/List;Ljava/lang/Object;)V", "getCallSiteReturn", "()Z", "getHasImplicitReturn", "getOriginalExpressions", "()Ljava/util/List;", "getValueType", "()Ljava/lang/Object;", "Ljava/lang/Object;", "kotlin.refactorings.common"})
    public static final class ExpressionValue<KotlinType>
    implements OutputValue<KotlinType> {
        private final boolean callSiteReturn;
        private final boolean hasImplicitReturn;
        @NotNull
        private final List<KtExpression> originalExpressions;
        private final KotlinType valueType;

        public ExpressionValue(boolean callSiteReturn, boolean hasImplicitReturn, @NotNull List<? extends KtExpression> originalExpressions, KotlinType valueType) {
            Intrinsics.checkNotNullParameter(originalExpressions, (String)"originalExpressions");
            this.callSiteReturn = callSiteReturn;
            this.hasImplicitReturn = hasImplicitReturn;
            this.originalExpressions = originalExpressions;
            this.valueType = valueType;
        }

        public final boolean getCallSiteReturn() {
            return this.callSiteReturn;
        }

        public final boolean getHasImplicitReturn() {
            return this.hasImplicitReturn;
        }

        @Override
        @NotNull
        public List<KtExpression> getOriginalExpressions() {
            return this.originalExpressions;
        }

        @Override
        public KotlinType getValueType() {
            return this.valueType;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0005\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue$Initializer;", "KotlinType", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue;", "initializedDeclaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "valueType", "<init>", "(Lorg/jetbrains/kotlin/psi/KtProperty;Ljava/lang/Object;)V", "getInitializedDeclaration", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getValueType", "()Ljava/lang/Object;", "Ljava/lang/Object;", "originalExpressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getOriginalExpressions", "()Ljava/util/List;", "kotlin.refactorings.common"})
    public static final class Initializer<KotlinType>
    implements OutputValue<KotlinType> {
        @NotNull
        private final KtProperty initializedDeclaration;
        private final KotlinType valueType;

        public Initializer(@NotNull KtProperty initializedDeclaration, KotlinType valueType) {
            Intrinsics.checkNotNullParameter((Object)initializedDeclaration, (String)"initializedDeclaration");
            this.initializedDeclaration = initializedDeclaration;
            this.valueType = valueType;
        }

        @NotNull
        public final KtProperty getInitializedDeclaration() {
            return this.initializedDeclaration;
        }

        @Override
        public KotlinType getValueType() {
            return this.valueType;
        }

        @Override
        @NotNull
        public List<KtExpression> getOriginalExpressions() {
            List<KtProperty> list2 = Collections.singletonList(this.initializedDeclaration);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"singletonList(...)");
            return list2;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B7\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00028\u0001\u0012\u0006\u0010\u000b\u001a\u00028\u0001\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\n\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u000b\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0016\u0010\u0017\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue$Jump;", "KotlinType", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue;", "elementsToReplace", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "elementToInsertAfterCall", "Lorg/jetbrains/kotlin/psi/KtElement;", "conditional", "", "booleanType", "unitType", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtElement;ZLjava/lang/Object;Ljava/lang/Object;)V", "getElementsToReplace", "()Ljava/util/List;", "getElementToInsertAfterCall", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getConditional", "()Z", "Ljava/lang/Object;", "originalExpressions", "getOriginalExpressions", "valueType", "getValueType", "()Ljava/lang/Object;", "kotlin.refactorings.common"})
    public static final class Jump<KotlinType>
    implements OutputValue<KotlinType> {
        @NotNull
        private final List<KtExpression> elementsToReplace;
        @Nullable
        private final KtElement elementToInsertAfterCall;
        private final boolean conditional;
        private final KotlinType booleanType;
        private final KotlinType unitType;
        private final KotlinType valueType;

        public Jump(@NotNull List<? extends KtExpression> elementsToReplace, @Nullable KtElement elementToInsertAfterCall, boolean conditional, KotlinType booleanType, KotlinType unitType) {
            Intrinsics.checkNotNullParameter(elementsToReplace, (String)"elementsToReplace");
            this.elementsToReplace = elementsToReplace;
            this.elementToInsertAfterCall = elementToInsertAfterCall;
            this.conditional = conditional;
            this.booleanType = booleanType;
            this.unitType = unitType;
            this.valueType = this.conditional ? this.booleanType : this.unitType;
        }

        @NotNull
        public final List<KtExpression> getElementsToReplace() {
            return this.elementsToReplace;
        }

        @Nullable
        public final KtElement getElementToInsertAfterCall() {
            return this.elementToInsertAfterCall;
        }

        public final boolean getConditional() {
            return this.conditional;
        }

        @Override
        @NotNull
        public List<KtExpression> getOriginalExpressions() {
            return this.elementsToReplace;
        }

        @Override
        public KotlinType getValueType() {
            return this.valueType;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00028\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue$ParameterUpdate;", "KotlinType", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/OutputValue;", "parameter", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IParameter;", "originalExpressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "<init>", "(Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IParameter;Ljava/util/List;)V", "getParameter", "()Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractionEngine/IParameter;", "getOriginalExpressions", "()Ljava/util/List;", "valueType", "getValueType", "()Ljava/lang/Object;", "kotlin.refactorings.common"})
    public static final class ParameterUpdate<KotlinType>
    implements OutputValue<KotlinType> {
        @NotNull
        private final IParameter<KotlinType> parameter;
        @NotNull
        private final List<KtExpression> originalExpressions;

        public ParameterUpdate(@NotNull IParameter<KotlinType> parameter, @NotNull List<? extends KtExpression> originalExpressions) {
            Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
            Intrinsics.checkNotNullParameter(originalExpressions, (String)"originalExpressions");
            this.parameter = parameter;
            this.originalExpressions = originalExpressions;
        }

        @NotNull
        public final IParameter<KotlinType> getParameter() {
            return this.parameter;
        }

        @Override
        @NotNull
        public List<KtExpression> getOriginalExpressions() {
            return this.originalExpressions;
        }

        @Override
        public KotlinType getValueType() {
            return this.parameter.getParameterType();
        }
    }
}

