/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveDeclarationDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSourceKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMover;
import org.jetbrains.kotlin.idea.refactoring.move.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.ModelResultWithFUSData;
import org.jetbrains.kotlin.idea.statistics.KotlinMoveRefactoringFUSCollector;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesModel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/Model;", "project", "Lcom/intellij/openapi/project/Project;", "openInEditorCheckBox", "", "selectedElementsToMove", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "originalClass", "targetClass", "Lcom/intellij/psi/PsiElement;", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "<init>", "(Lcom/intellij/openapi/project/Project;ZLjava/util/List;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/psi/PsiElement;Lcom/intellij/refactoring/move/MoveCallback;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getOpenInEditorCheckBox", "()Z", "getSelectedElementsToMove", "()Ljava/util/List;", "getOriginalClass", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getTargetClass", "()Lcom/intellij/psi/PsiElement;", "getMoveCallback", "()Lcom/intellij/refactoring/move/MoveCallback;", "getCheckedTargetClass", "Lorg/jetbrains/kotlin/psi/KtElement;", "computeModelResult", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/ModelResultWithFUSData;", "throwOnConflicts", "kotlin.idea"})
public final class MoveKotlinNestedClassesModel
implements Model {
    @NotNull
    private final Project project;
    private final boolean openInEditorCheckBox;
    @NotNull
    private final List<KtClassOrObject> selectedElementsToMove;
    @NotNull
    private final KtClassOrObject originalClass;
    @Nullable
    private final PsiElement targetClass;
    @Nullable
    private final MoveCallback moveCallback;

    public MoveKotlinNestedClassesModel(@NotNull Project project, boolean openInEditorCheckBox, @NotNull List<? extends KtClassOrObject> selectedElementsToMove, @NotNull KtClassOrObject originalClass, @Nullable PsiElement targetClass, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selectedElementsToMove, (String)"selectedElementsToMove");
        Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
        this.project = project;
        this.openInEditorCheckBox = openInEditorCheckBox;
        this.selectedElementsToMove = selectedElementsToMove;
        this.originalClass = originalClass;
        this.targetClass = targetClass;
        this.moveCallback = moveCallback;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getOpenInEditorCheckBox() {
        return this.openInEditorCheckBox;
    }

    @NotNull
    public final List<KtClassOrObject> getSelectedElementsToMove() {
        return this.selectedElementsToMove;
    }

    @NotNull
    public final KtClassOrObject getOriginalClass() {
        return this.originalClass;
    }

    @Nullable
    public final PsiElement getTargetClass() {
        return this.targetClass;
    }

    @Nullable
    public final MoveCallback getMoveCallback() {
        return this.moveCallback;
    }

    private final KtElement getCheckedTargetClass() {
        PsiElement psiElement = this.targetClass;
        if (psiElement == null) {
            throw new ConfigurationException(RefactoringBundle.message((String)"no.destination.class.specified"));
        }
        PsiElement targetClass = psiElement;
        if (!(targetClass instanceof KtClassOrObject)) {
            throw new ConfigurationException(KotlinBundle.message((String)"text.destination.class.should.be.kotlin.class", (Object[])new Object[0]));
        }
        if (this.originalClass == targetClass) {
            throw new ConfigurationException(RefactoringBundle.message((String)"source.and.destination.classes.should.be.different"));
        }
        for (KtClassOrObject classOrObject : this.selectedElementsToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)classOrObject), (PsiElement)targetClass, (boolean)false)) continue;
            Object[] objectArray = new Object[]{String.valueOf(classOrObject.getName())};
            throw new ConfigurationException(KotlinBundle.message((String)"text.cannot.move.inner.class.0.into.itself", (Object[])objectArray));
        }
        return (KtElement)targetClass;
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult() throws ConfigurationException {
        return this.computeModelResult(false);
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult(boolean throwOnConflicts) throws ConfigurationException {
        List<KtClassOrObject> elementsToMove = this.selectedElementsToMove;
        KotlinMoveTarget.ExistingElement target = new KotlinMoveTarget.ExistingElement(this.getCheckedTargetClass());
        KotlinMoveDeclarationDelegate.NestedClass delegate = new KotlinMoveDeclarationDelegate.NestedClass(null, null, 3, null);
        MoveDeclarationsDescriptor descriptor2 = new MoveDeclarationsDescriptor(this.project, KotlinMoveSourceKt.KotlinMoveSource((Collection<? extends KtNamedDeclaration>)elementsToMove), target, delegate, false, false, false, this.moveCallback, this.openInEditorCheckBox, null, false, false, 3584, null);
        MoveKotlinDeclarationsProcessor processor2 = new MoveKotlinDeclarationsProcessor(descriptor2, KotlinMover.Default.INSTANCE, throwOnConflicts);
        return new ModelResultWithFUSData(processor2, elementsToMove.size(), KotlinMoveRefactoringFUSCollector.MovedEntity.CLASSES, KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination.DECLARATION);
    }
}

