/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinAwareMoveFilesOrDirectoriesProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveDeclarationDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSourceKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMover;
import org.jetbrains.kotlin.idea.refactoring.move.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.MoveToKotlinFileProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.ModelResultWithFUSData;
import org.jetbrains.kotlin.idea.statistics.KotlinMoveRefactoringFUSCollector;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001By\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\u0006\u0010\u0012\u001a\u00020\u000e\u0012\u0006\u0010\u0013\u001a\u00020\u000e\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J<\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010(\"\u0004\b\u0001\u0010'*\b\u0012\u0004\u0012\u0002H(0)2\u0014\u0010*\u001a\u0010\u0012\u0004\u0012\u0002H(\u0012\u0006\u0012\u0004\u0018\u0001H'0+H\u0082\b\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\nH\u0002J\b\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\bH\u0002J \u0010=\u001a\b\u0012\u0004\u0012\u00020>0)2\b\u0010?\u001a\u0004\u0018\u00010\b2\u0006\u0010@\u001a\u00020\nH\u0002J\u001c\u0010A\u001a\u0004\u0018\u00010B2\b\u0010?\u001a\u0004\u0018\u00010\b2\u0006\u0010@\u001a\u00020\nH\u0002J\b\u0010C\u001a\u00020BH\u0002J\b\u0010D\u001a\u00020BH\u0002J\b\u0010E\u001a\u00020;H\u0002J\u0014\u0010F\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020I0GH\u0002J\b\u0010J\u001a\u00020KH\u0016J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u000eH\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010L\u001a\u00020\u000eH\u0002J\u0010\u0010O\u001a\u00020N2\u0006\u0010L\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\"R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\"R\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\"R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\"R\u0011\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\"R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R!\u0010.\u001a\b\u0012\u0004\u0012\u00020/0)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b0\u00101R\u001b\u00104\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u00103\u001a\u0004\b5\u0010\"R\u000e\u00107\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsModel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/Model;", "project", "Lcom/intellij/openapi/project/Project;", "elementsToMove", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "targetPackage", "", "selectedPsiDirectory", "Lcom/intellij/psi/PsiDirectory;", "fileNameInPackage", "targetFilePath", "isMoveToPackage", "", "isSearchReferences", "isSearchInComments", "isSearchInNonJavaFiles", "isDeleteEmptyFiles", "applyMPPDeclarations", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;Ljava/lang/String;Ljava/lang/String;ZZZZZZLcom/intellij/refactoring/move/MoveCallback;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getElementsToMove", "()Ljava/util/List;", "getTargetPackage", "()Ljava/lang/String;", "getSelectedPsiDirectory", "()Lcom/intellij/psi/PsiDirectory;", "getFileNameInPackage", "getTargetFilePath", "()Z", "getApplyMPPDeclarations", "getMoveCallback", "()Lcom/intellij/refactoring/move/MoveCallback;", "mapToSingleOrNull", "K", "T", "", "transform", "Lkotlin/Function1;", "(Ljava/util/Set;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "checkedGetSourceDirectory", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "getSourceFiles", "()Ljava/util/Set;", "sourceFiles$delegate", "Lkotlin/Lazy;", "elementsToMoveHasMPP", "getElementsToMoveHasMPP", "elementsToMoveHasMPP$delegate", "singleSourceFileMode", "selectPackageBasedDestination", "Lcom/intellij/refactoring/MoveDestination;", "checkTargetFileName", "", "fileName", "getFilesExistingInTargetDirectory", "Lcom/intellij/psi/PsiFile;", "targetFileName", "targetDirectory", "tryMoveToPackageForExistingDirectory", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "selectMoveTargetToPackage", "selectMoveTargetToFile", "verifyBeforeRun", "getFUSParameters", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/statistics/KotlinMoveRefactoringFUSCollector$MovedEntity;", "Lorg/jetbrains/kotlin/idea/statistics/KotlinMoveRefactoringFUSCollector$MoveRefactoringDestination;", "computeModelResult", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/ModelResultWithFUSData;", "throwOnConflicts", "tryMoveEntireFile", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "moveDeclaration", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMoveKotlinTopLevelDeclarationsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveKotlinTopLevelDeclarationsModel.kt\norg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,328:1\n57#1:332\n1661#2,3:329\n1661#2,3:333\n1651#2:337\n1915#2:338\n1916#2:340\n1652#2:341\n1807#2,3:343\n1807#2,3:346\n1512#2:349\n1538#2,3:350\n1541#2,3:360\n1915#2,2:366\n812#2,12:368\n1661#2,3:380\n1807#2,3:383\n1#3:336\n1#3:339\n137#4:342\n383#5,7:353\n173#6,3:363\n*S KotlinDebug\n*F\n+ 1 MoveKotlinTopLevelDeclarationsModel.kt\norg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinTopLevelDeclarationsModel\n*L\n59#1:332\n57#1:329,3\n59#1:333,3\n95#1:337\n95#1:338\n95#1:340\n95#1:341\n216#1:343,3\n217#1:346,3\n247#1:349\n247#1:350,3\n247#1:360,3\n267#1:366,2\n302#1:368,12\n63#1:380,3\n67#1:383,3\n95#1:339\n155#1:342\n247#1:353,7\n248#1:363,3\n*E\n"})
public final class MoveKotlinTopLevelDeclarationsModel
implements Model {
    @NotNull
    private final Project project;
    @NotNull
    private final List<KtNamedDeclaration> elementsToMove;
    @NotNull
    private final String targetPackage;
    @Nullable
    private final PsiDirectory selectedPsiDirectory;
    @NotNull
    private final String fileNameInPackage;
    @NotNull
    private final String targetFilePath;
    private final boolean isMoveToPackage;
    private final boolean isSearchReferences;
    private final boolean isSearchInComments;
    private final boolean isSearchInNonJavaFiles;
    private final boolean isDeleteEmptyFiles;
    private final boolean applyMPPDeclarations;
    @Nullable
    private final MoveCallback moveCallback;
    @NotNull
    private final Lazy sourceFiles$delegate;
    @NotNull
    private final Lazy elementsToMoveHasMPP$delegate;
    private final boolean singleSourceFileMode;

    public MoveKotlinTopLevelDeclarationsModel(@NotNull Project project, @NotNull List<? extends KtNamedDeclaration> elementsToMove, @NotNull String targetPackage, @Nullable PsiDirectory selectedPsiDirectory, @NotNull String fileNameInPackage, @NotNull String targetFilePath, boolean isMoveToPackage, boolean isSearchReferences, boolean isSearchInComments, boolean isSearchInNonJavaFiles, boolean isDeleteEmptyFiles, boolean applyMPPDeclarations, @Nullable MoveCallback moveCallback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(elementsToMove, (String)"elementsToMove");
        Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
        Intrinsics.checkNotNullParameter((Object)fileNameInPackage, (String)"fileNameInPackage");
        Intrinsics.checkNotNullParameter((Object)targetFilePath, (String)"targetFilePath");
        this.project = project;
        this.elementsToMove = elementsToMove;
        this.targetPackage = targetPackage;
        this.selectedPsiDirectory = selectedPsiDirectory;
        this.fileNameInPackage = fileNameInPackage;
        this.targetFilePath = targetFilePath;
        this.isMoveToPackage = isMoveToPackage;
        this.isSearchReferences = isSearchReferences;
        this.isSearchInComments = isSearchInComments;
        this.isSearchInNonJavaFiles = isSearchInNonJavaFiles;
        this.isDeleteEmptyFiles = isDeleteEmptyFiles;
        this.applyMPPDeclarations = applyMPPDeclarations;
        this.moveCallback = moveCallback;
        this.sourceFiles$delegate = LazyKt.lazy(() -> MoveKotlinTopLevelDeclarationsModel.sourceFiles_delegate$lambda$0(this));
        this.elementsToMoveHasMPP$delegate = LazyKt.lazy(() -> MoveKotlinTopLevelDeclarationsModel.elementsToMoveHasMPP_delegate$lambda$0(this));
        this.singleSourceFileMode = this.getSourceFiles().size() == 1;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<KtNamedDeclaration> getElementsToMove() {
        return this.elementsToMove;
    }

    @NotNull
    public final String getTargetPackage() {
        return this.targetPackage;
    }

    @Nullable
    public final PsiDirectory getSelectedPsiDirectory() {
        return this.selectedPsiDirectory;
    }

    @NotNull
    public final String getFileNameInPackage() {
        return this.fileNameInPackage;
    }

    @NotNull
    public final String getTargetFilePath() {
        return this.targetFilePath;
    }

    public final boolean isMoveToPackage() {
        return this.isMoveToPackage;
    }

    public final boolean isSearchReferences() {
        return this.isSearchReferences;
    }

    public final boolean isSearchInComments() {
        return this.isSearchInComments;
    }

    public final boolean isSearchInNonJavaFiles() {
        return this.isSearchInNonJavaFiles;
    }

    public final boolean isDeleteEmptyFiles() {
        return this.isDeleteEmptyFiles;
    }

    public final boolean getApplyMPPDeclarations() {
        return this.applyMPPDeclarations;
    }

    @Nullable
    public final MoveCallback getMoveCallback() {
        return this.moveCallback;
    }

    /*
     * WARNING - void declaration
     */
    private final <T, K> K mapToSingleOrNull(Set<? extends T> $this$mapToSingleOrNull, Function1<? super T, ? extends K> transform2) {
        void destination$iv;
        void $this$mapTo$iv;
        boolean $i$f$mapToSingleOrNull = false;
        Iterable iterable = $this$mapToSingleOrNull;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            destination$iv.add(transform2.invoke(item$iv));
        }
        return (K)CollectionsKt.singleOrNull((Iterable)((Iterable)destination$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final PsiDirectory checkedGetSourceDirectory() {
        void destination$iv$iv;
        void $this$mapTo$iv$iv;
        MoveKotlinTopLevelDeclarationsModel moveKotlinTopLevelDeclarationsModel = this;
        Set<KtFile> $this$mapToSingleOrNull$iv = this.getSourceFiles();
        boolean $i$f$mapToSingleOrNull = false;
        Iterable iterable = $this$mapToSingleOrNull$iv;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtFile ktFile2 = (KtFile)item$iv$iv;
            void var11_11 = destination$iv$iv;
            boolean bl = false;
            var11_11.add(it.getParent());
        }
        PsiDirectory psiDirectory = (PsiDirectory)CollectionsKt.singleOrNull((Iterable)((Iterable)destination$iv$iv));
        if (psiDirectory == null) {
            throw new ConfigurationException(KotlinBundle.message((String)"text.cannot.determine.source.directory", (Object[])new Object[0]));
        }
        return psiDirectory;
    }

    private final Set<KtFile> getSourceFiles() {
        Lazy lazy = this.sourceFiles$delegate;
        return (Set)lazy.getValue();
    }

    private final boolean getElementsToMoveHasMPP() {
        Lazy lazy = this.elementsToMoveHasMPP$delegate;
        return (Boolean)lazy.getValue();
    }

    private final MoveDestination selectPackageBasedDestination() {
        PackageWrapper targetPackageWrapper = new PackageWrapper(PsiManager.getInstance((Project)this.project), this.targetPackage);
        return this.selectedPsiDirectory == null ? (MoveDestination)new MultipleRootsMoveDestination(targetPackageWrapper) : (MoveDestination)new AutocreatingSingleSourceRootMoveDestination(targetPackageWrapper, this.selectedPsiDirectory.getVirtualFile());
    }

    private final void checkTargetFileName(String fileName) {
        if (!Intrinsics.areEqual((Object)FileTypeManager.getInstance().getFileTypeByFileName(fileName), (Object)KotlinFileType.INSTANCE)) {
            throw new ConfigurationException(KotlinBundle.message((String)"refactoring.move.non.kotlin.file", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PsiFile> getFilesExistingInTargetDirectory(String targetFileName, PsiDirectory targetDirectory) {
        Set set;
        if (targetFileName != null) {
            Set set2;
            PsiFile psiFile = targetDirectory.findFile(targetFileName);
            if (psiFile != null) {
                PsiFile it = psiFile;
                boolean bl = false;
                set2 = SetsKt.setOf((Object)it);
            } else {
                set2 = set = null;
            }
            if (set2 == null) {
                set = SetsKt.emptySet();
            }
        } else {
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Iterable iterable = this.getSourceFiles();
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PsiFile it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                KtFile it = (KtFile)element$iv;
                boolean bl2 = false;
                if (targetDirectory.findFile(it.getName()) == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            set = (Set)destination$iv;
        }
        return set;
    }

    private final KotlinMoveTarget tryMoveToPackageForExistingDirectory(String targetFileName, PsiDirectory targetDirectory) {
        Set<PsiFile> filesExistingInTargetDir = this.getFilesExistingInTargetDirectory(targetFileName, targetDirectory);
        if (filesExistingInTargetDir.isEmpty()) {
            return null;
        }
        if (this.singleSourceFileMode) {
            KtFile singeTargetFile;
            Object object = CollectionsKt.single((Iterable)filesExistingInTargetDir);
            KtFile ktFile2 = singeTargetFile = object instanceof KtFile ? (KtFile)object : null;
            if (singeTargetFile != null) {
                return new KotlinMoveTarget.ExistingElement((KtElement)singeTargetFile);
            }
        } else {
            String filePathsToReport = CollectionsKt.joinToString$default((Iterable)filesExistingInTargetDir, (CharSequence)"\n", (CharSequence)KotlinBundle.message((String)"move.refactoring.error.text.cannot.perform.refactoring.since.the.following.files.already.exist", (Object[])new Object[0]), null, (int)0, null, MoveKotlinTopLevelDeclarationsModel::tryMoveToPackageForExistingDirectory$lambda$0, (int)28, null);
            throw new ConfigurationException(filePathsToReport);
        }
        return null;
    }

    private final KotlinMoveTarget selectMoveTargetToPackage() {
        MoveDestination moveDestination = this.selectPackageBasedDestination();
        PsiDirectory targetDirectory = null;
        if (!this.getElementsToMoveHasMPP()) {
            Object targetFileName;
            Object object;
            targetDirectory = moveDestination.getTargetIfExists(this.checkedGetSourceDirectory());
            if (this.singleSourceFileMode) {
                object = this.fileNameInPackage;
                String p0 = object;
                boolean bl = false;
                this.checkTargetFileName(p0);
                v0 = object;
            } else {
                v0 = targetFileName = null;
            }
            if (targetDirectory != null && (object = this.tryMoveToPackageForExistingDirectory((String)targetFileName, targetDirectory)) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
        } else {
            targetDirectory = null;
        }
        PsiDirectory psiDirectory = targetDirectory;
        return new KotlinMoveTarget.DeferredFile(new FqName(this.targetPackage), (VirtualFile)(psiDirectory != null ? psiDirectory.getVirtualFile() : null), (Function1<? super KtFile, ? extends KtFile>)((Function1)arg_0 -> MoveKotlinTopLevelDeclarationsModel.selectMoveTargetToPackage$lambda$1(this, moveDestination, arg_0)));
    }

    private final KotlinMoveTarget selectMoveTargetToFile() {
        File file;
        try {
            file = Paths.get(this.targetFilePath, new String[0]).toFile();
        }
        catch (InvalidPathException e) {
            Object[] objectArray = new Object[]{this.targetFilePath};
            throw new ConfigurationException(KotlinBundle.message((String)"text.invalid.target.path.0", (Object[])objectArray));
        }
        File targetFile = file;
        String string = targetFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.checkTargetFileName(string);
        Intrinsics.checkNotNull((Object)targetFile);
        PsiFile $this$safeAs$iv = PhysicalFileSystemUtilsKt.toPsiFile(targetFile, this.project);
        boolean $i$f$safeAs = false;
        PsiFile psiFile = $this$safeAs$iv;
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        if ((file = (KtFile)psiFile) != null) {
            File it = file;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((Iterable)this.getSourceFiles()), (Object)it)) {
                throw new ConfigurationException(KotlinBundle.message((String)"text.cannot.move.to.original.file", (Object[])new Object[0]));
            }
            return new KotlinMoveTarget.ExistingElement((KtElement)it);
        }
        Path path2 = targetFile.toPath().getParent();
        if (path2 == null) {
            throw new ConfigurationException(KotlinBundle.message((String)"dialog.message.incorrect.target.path.directory.not.specified", (Object[])new Object[0]));
        }
        Path targetDirectoryPath = path2;
        String string2 = this.project.getBasePath();
        if (string2 == null) {
            throw new ConfigurationException(KotlinBundle.message((String)"text.cannot.move.for.current.project", (Object[])new Object[0]));
        }
        String projectBasePath = string2;
        if (!targetDirectoryPath.startsWith(projectBasePath)) {
            Object[] it = new Object[]{targetDirectoryPath};
            throw new ConfigurationException(KotlinBundle.message((String)"text.incorrect.target.path.directory.0.does.not.belong.to.current.project", (Object[])it));
        }
        File file2 = targetDirectoryPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        PsiDirectory psiDirectory = PhysicalFileSystemUtilsKt.toPsiDirectory(file2, this.project);
        if (psiDirectory == null) {
            throw new IllegalStateException((targetDirectoryPath + " couldn't be converted to PsiDirectory").toString());
        }
        PsiDirectory psiDirectory2 = psiDirectory;
        KtFile ktFile2 = (KtFile)CollectionsKt.singleOrNull((Iterable)this.getSourceFiles());
        if (ktFile2 == null || (ktFile2 = ktFile2.getPackageFqName()) == null) {
            PsiPackage psiPackage = PackageUtilsKt.getPackage(psiDirectory2);
            if (psiPackage != null) {
                PsiPackage it = psiPackage;
                boolean bl = false;
                String string3 = it.getQualifiedName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getQualifiedName(...)");
                ktFile2 = new FqName(string3);
            } else {
                Object[] objectArray = new Object[]{targetDirectoryPath};
                throw new ConfigurationException(KotlinBundle.message((String)"text.cannot.find.package.corresponding.to.0", (Object[])objectArray));
            }
        }
        KtFile targetPackageFqName = ktFile2;
        return new KotlinMoveTarget.DeferredFile((FqName)targetPackageFqName, psiDirectory2.getVirtualFile(), (Function1<? super KtFile, ? extends KtFile>)((Function1)arg_0 -> MoveKotlinTopLevelDeclarationsModel.selectMoveTargetToFile$lambda$2(targetFile, psiDirectory2, (FqName)targetPackageFqName, arg_0)));
    }

    private final void verifyBeforeRun() {
        if (!this.isMoveToPackage && this.getElementsToMoveHasMPP()) {
            throw new ConfigurationException(KotlinBundle.message((String)"text.cannot.move.expect.actual.declaration.to.file", (Object[])new Object[0]));
        }
        if (this.elementsToMove.isEmpty()) {
            throw new ConfigurationException(KotlinBundle.message((String)"text.at.least.one.file.must.be.selected", (Object[])new Object[0]));
        }
        if (this.getSourceFiles().isEmpty()) {
            throw new ConfigurationException(KotlinBundle.message((String)"dialog.message.none.elements.were.selected", (Object[])new Object[0]));
        }
        if (this.singleSourceFileMode && StringsKt.isBlank((CharSequence)this.fileNameInPackage)) {
            throw new ConfigurationException(KotlinBundle.message((String)"text.file.name.cannot.be.empty", (Object[])new Object[0]));
        }
        if (this.isMoveToPackage) {
            if (((CharSequence)this.targetPackage).length() > 0 && !PsiNameHelper.getInstance((Project)this.project).isQualifiedName(this.targetPackage)) {
                Object[] objectArray = new Object[]{this.targetPackage};
                throw new ConfigurationException(KotlinBundle.message((String)"text.0.is.invalid.destination.package", (Object[])objectArray));
            }
        } else {
            PsiFile targetFile = PhysicalFileSystemUtilsKt.toPsiFile(new File(this.targetFilePath), this.project);
            if (targetFile != null && !(targetFile instanceof KtFile)) {
                throw new ConfigurationException(KotlinBundle.message((String)"refactoring.move.non.kotlin.file", (Object[])new Object[0]));
            }
        }
    }

    private final Pair<KotlinMoveRefactoringFUSCollector.MovedEntity, KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination> getFUSParameters() {
        boolean functionsAreGoingToMove;
        boolean classesAreGoingToMove;
        KotlinMoveRefactoringFUSCollector.MovedEntity mixedType;
        KotlinMoveRefactoringFUSCollector.MovedEntity functionType;
        KotlinMoveRefactoringFUSCollector.MovedEntity classType;
        block7: {
            boolean bl;
            block6: {
                Triple triple = this.getElementsToMoveHasMPP() ? new Triple((Object)KotlinMoveRefactoringFUSCollector.MovedEntity.MPPCLASSES, (Object)KotlinMoveRefactoringFUSCollector.MovedEntity.MPPFUNCTIONS, (Object)KotlinMoveRefactoringFUSCollector.MovedEntity.MPPMIXED) : new Triple((Object)KotlinMoveRefactoringFUSCollector.MovedEntity.CLASSES, (Object)KotlinMoveRefactoringFUSCollector.MovedEntity.FUNCTIONS, (Object)KotlinMoveRefactoringFUSCollector.MovedEntity.MIXED);
                classType = (KotlinMoveRefactoringFUSCollector.MovedEntity)((Object)triple.component1());
                functionType = (KotlinMoveRefactoringFUSCollector.MovedEntity)((Object)triple.component2());
                mixedType = (KotlinMoveRefactoringFUSCollector.MovedEntity)((Object)triple.component3());
                Iterable $this$any$iv = this.elementsToMove;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof KtClassOrObject)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            classesAreGoingToMove = bl;
            Iterable $this$any$iv = this.elementsToMove;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof KtFunction)) continue;
                    v1 = true;
                    break block7;
                }
                v1 = functionsAreGoingToMove = false;
            }
        }
        KotlinMoveRefactoringFUSCollector.MovedEntity entity = classesAreGoingToMove && functionsAreGoingToMove ? mixedType : (classesAreGoingToMove ? classType : functionType);
        KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination destination = this.isMoveToPackage ? KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination.PACKAGE : KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination.FILE;
        return TuplesKt.to((Object)((Object)entity), (Object)((Object)destination));
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult() throws ConfigurationException {
        return this.computeModelResult(false);
    }

    @Override
    @NotNull
    public ModelResultWithFUSData computeModelResult(boolean throwOnConflicts) throws ConfigurationException {
        this.verifyBeforeRun();
        Pair<KotlinMoveRefactoringFUSCollector.MovedEntity, KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination> pair = this.getFUSParameters();
        KotlinMoveRefactoringFUSCollector.MovedEntity entity = (KotlinMoveRefactoringFUSCollector.MovedEntity)((Object)pair.component1());
        KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination destination = (KotlinMoveRefactoringFUSCollector.MoveRefactoringDestination)((Object)pair.component2());
        BaseRefactoringProcessor baseRefactoringProcessor = this.tryMoveEntireFile(throwOnConflicts);
        if (baseRefactoringProcessor == null) {
            baseRefactoringProcessor = this.moveDeclaration(throwOnConflicts);
        }
        BaseRefactoringProcessor processor2 = baseRefactoringProcessor;
        return new ModelResultWithFUSData(processor2, this.elementsToMove.size(), entity, destination);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final BaseRefactoringProcessor tryMoveEntireFile(boolean throwOnConflicts) {
        block17: {
            if (!this.isDeleteEmptyFiles || this.getElementsToMoveHasMPP() || !this.isMoveToPackage) {
                return null;
            }
            $this$groupBy$iv = this.elementsToMove;
            $i$f$groupBy = false;
            var5_5 = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$groupByTo = false;
            for (T element$iv$iv : $this$groupByTo$iv$iv) {
                obj = (KtPureElement)element$iv$iv;
                $i$a$-groupBy-MoveKotlinTopLevelDeclarationsModel$tryMoveEntireFile$allDeclarationsMovingOut$1 = false;
                key$iv$iv = obj.getContainingKtFile();
                var13_27 = destination$iv$iv;
                key$iv$iv$iv = key$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                    answer$iv$iv$iv = new ArrayList<E>();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    v0 /* !! */  = answer$iv$iv$iv;
                } else {
                    v0 /* !! */  = value$iv$iv$iv;
                }
                list$iv$iv = (List)v0 /* !! */ ;
                list$iv$iv.add(element$iv$iv);
            }
            $this$all$iv = destination$iv$iv;
            $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                v1 = true;
            } else {
                $this$groupByTo$iv$iv = $this$all$iv.entrySet().iterator();
                while ($this$groupByTo$iv$iv.hasNext()) {
                    it = element$iv = $this$groupByTo$iv$iv.next();
                    $i$a$-all-MoveKotlinTopLevelDeclarationsModel$tryMoveEntireFile$allDeclarationsMovingOut$2 = false;
                    v2 = it.getKey();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-key>(...)");
                    if (KtPsiUtilKt.getFileOrScriptDeclarations((KtFile)((KtFile)v2)).size() == ((List)it.getValue()).size()) continue;
                    v1 = false;
                    break block17;
                }
                v1 = allDeclarationsMovingOut = true;
            }
        }
        if (!allDeclarationsMovingOut) {
            return null;
        }
        v3 = this.selectPackageBasedDestination().getTargetIfExists(this.checkedGetSourceDirectory());
        if (v3 == null) {
            return null;
        }
        targetDirectory = v3;
        $this$groupByTo$iv$iv = (KtFile)CollectionsKt.singleOrNull((Iterable)this.getSourceFiles());
        if ($this$groupByTo$iv$iv == null) ** GOTO lbl-1000
        it = $this$groupByTo$iv$iv;
        $i$a$-let-MoveKotlinTopLevelDeclarationsModel$tryMoveEntireFile$targetFileNameAndFile$1 = false;
        element$iv = TuplesKt.to((Object)this.fileNameInPackage, (Object)it);
        if (element$iv != null) {
            it = element$iv;
            it = it;
            $i$a$-also-MoveKotlinTopLevelDeclarationsModel$tryMoveEntireFile$targetFileNameAndFile$2 = false;
            this.checkTargetFileName((String)it.getFirst());
            v4 = it;
        } else lbl-1000:
        // 2 sources

        {
            v4 = null;
        }
        v5 = targetFileNameAndFile = v4;
        filesExistingInTargetDir = this.getFilesExistingInTargetDirectory(v5 != null ? (String)v5.getFirst() : null, targetDirectory);
        if (filesExistingInTargetDir.isEmpty()) ** GOTO lbl-1000
        v6 = (PsiFile)CollectionsKt.singleOrNull((Iterable)filesExistingInTargetDir);
        if (v6 != null) {
            it = v6;
            $i$a$-let-MoveKotlinTopLevelDeclarationsModel$tryMoveEntireFile$moveAsFile$1 = false;
            v7 = CollectionsKt.contains((Iterable)this.getSourceFiles(), (Object)it);
        } else {
            v7 = false;
        }
        if (v7) lbl-1000:
        // 2 sources

        {
            v8 = true;
        } else {
            v8 = moveAsFile = false;
        }
        if (!moveAsFile) {
            return null;
        }
        $this$forEach$iv = this.getSourceFiles();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (KtFile)element$iv;
            $i$a$-forEach-MoveKotlinTopLevelDeclarationsModel$tryMoveEntireFile$1 = false;
            MoveUtilKt.setUpdatePackageDirective(it, true);
        }
        return targetFileNameAndFile != null ? (BaseRefactoringProcessor)new MoveToKotlinFileProcessor(this.project, (KtFile)targetFileNameAndFile.getSecond(), targetDirectory, (String)targetFileNameAndFile.getFirst(), this.isSearchInComments, this.isSearchInNonJavaFiles, this.moveCallback, null, throwOnConflicts, 128, null) : (BaseRefactoringProcessor)new KotlinAwareMoveFilesOrDirectoriesProcessor(this.project, CollectionsKt.toList((Iterable)this.getSourceFiles()), targetDirectory, this.isSearchReferences, this.isSearchInComments, this.isSearchInNonJavaFiles, this.moveCallback, null, throwOnConflicts, 128, null);
    }

    /*
     * WARNING - void declaration
     */
    private final BaseRefactoringProcessor moveDeclaration(boolean throwOnConflicts) {
        List list2;
        KotlinMoveTarget target;
        if (this.getElementsToMoveHasMPP() && !(this.isMoveToPackage && this.selectedPsiDirectory == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KotlinMoveTarget kotlinMoveTarget = target = this.isMoveToPackage ? this.selectMoveTargetToPackage() : this.selectMoveTargetToFile();
        if (this.getElementsToMoveHasMPP()) {
            void $this$filterIsInstanceTo$iv$iv;
            String string = MoveHandler.getRefactoringName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRefactoringName(...)");
            Iterable $this$filterIsInstance$iv = CollectionsKt.flatten((Iterable)MoveUtilKt.mapWithReadActionInProcess(this.elementsToMove, this.project, string, MoveKotlinTopLevelDeclarationsModel::moveDeclaration$lambda$0));
            boolean $i$f$filterIsInstance = false;
            Object object = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = this.elementsToMove;
        }
        List elementsWithMPPIfNeeded = list2;
        for (KtNamedDeclaration element : elementsWithMPPIfNeeded) {
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            String verify = target.verify(psiFile);
            if (verify == null) continue;
            throw new ConfigurationException(verify);
        }
        MoveDeclarationsDescriptor options2 = new MoveDeclarationsDescriptor(this.project, KotlinMoveSourceKt.KotlinMoveSource(elementsWithMPPIfNeeded), target, KotlinMoveDeclarationDelegate.TopLevel.INSTANCE, this.isSearchInComments, this.isSearchInNonJavaFiles, this.isDeleteEmptyFiles, this.moveCallback, false, null, true, this.isSearchReferences);
        return new MoveKotlinDeclarationsProcessor(options2, KotlinMover.Default.INSTANCE, throwOnConflicts);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set sourceFiles_delegate$lambda$0(MoveKotlinTopLevelDeclarationsModel this$0) {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this$0.elementsToMove;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getContainingKtFile());
        }
        return (Set)var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean elementsToMoveHasMPP_delegate$lambda$0(MoveKotlinTopLevelDeclarationsModel this$0) {
        boolean bl;
        if (!this$0.applyMPPDeclarations) return false;
        Iterable $this$any$iv = this$0.elementsToMove;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
            boolean bl2 = false;
            if (ExpectActualUtilKt.isEffectivelyActual$default((KtDeclaration)it, false, 1, null)) return true;
            if (ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)it)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final CharSequence tryMoveToPackageForExistingDirectory$lambda$0(PsiFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final KtFile selectMoveTargetToPackage$lambda$1(MoveKotlinTopLevelDeclarationsModel this$0, MoveDestination $moveDestination, KtFile it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.singleSourceFileMode) {
            string = this$0.fileNameInPackage;
        } else {
            String string2 = it.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        String deferredFileName = string;
        PsiDirectory deferredFileDirectory = $moveDestination.getTargetDirectory((PsiFile)it);
        Intrinsics.checkNotNull((Object)deferredFileDirectory);
        return KotlinRefactoringUtilKt.getOrCreateKotlinFile$default(deferredFileName, deferredFileDirectory, null, 4, null);
    }

    private static final KtFile selectMoveTargetToFile$lambda$2(File $targetFile, PsiDirectory $psiDirectory, FqName $targetPackageFqName, KtFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $targetFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return KotlinRefactoringUtilKt.getOrCreateKotlinFile(string, $psiDirectory, $targetPackageFqName.asString());
    }

    private static final Set moveDeclaration$lambda$0(KtNamedDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ExpectActualUtilKt.collectAllExpectAndActualDeclaration$default((KtDeclaration)it, false, 1, null);
    }
}

