/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveMethod;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PsiIconUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggestionProvider;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject;
import org.jetbrains.kotlin.idea.core.completion.PackageLookupObject;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveMethod.MoveKotlinMethodProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveMethod.MoveKotlinMethodProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinTypeReferenceEditorComboWithBrowseButton;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

public class MoveKotlinMethodDialog
extends RefactoringDialog {
    private static final String RECENTS_KEY = MoveKotlinMethodDialog.class.getName() + ".RECENTS_KEY";
    private final KtNamedFunction method;
    private final Map<KtNamedDeclaration, KtClass> variableToClassMap;
    private final KtNamedDeclaration[] variables;
    private final Map<KtClass, Set<KtNamedDeclaration>> thisClassesToMembers;
    private final KtClassOrObject targetContainer;
    private final Map<KtClass, EditorTextField> oldClassParameterNameFields;
    private KtNamedDeclaration selectedTarget;
    private JPanel mainPanel;
    private JRadioButton toClassRadioButton;
    private JRadioButton toObjectRadioButton;
    private JPanel targetObjectChooserPanel;
    private KotlinTypeReferenceEditorComboWithBrowseButton targetObjectChooser;
    private JList<KtNamedDeclaration> targetVariableList;
    private JPanel targetVariableListPanel;
    private JPanel parametersPanel;
    private JCheckBox openInEditorCheckBox;

    public MoveKotlinMethodDialog(@NotNull KtNamedFunction method, @NotNull Map<KtNamedDeclaration, KtClass> variableToClassMap, @Nullable KtClassOrObject targetContainer) {
        if (method == null) {
            MoveKotlinMethodDialog.$$$reportNull$$$0(0);
        }
        if (variableToClassMap == null) {
            MoveKotlinMethodDialog.$$$reportNull$$$0(1);
        }
        super(method.getProject(), true);
        this.method = method;
        this.variableToClassMap = variableToClassMap;
        this.targetContainer = targetContainer;
        this.$$$setupUI$$$();
        this.thisClassesToMembers = MoveKotlinMethodProcessorKt.getThisClassesToMembers(method);
        this.variables = variableToClassMap.keySet().toArray(new KtNamedDeclaration[0]);
        this.oldClassParameterNameFields = new HashMap<KtClass, EditorTextField>();
        this.init();
        this.setTitle(KotlinBundle.message((String)"title.move.method", (Object[])new Object[0]));
        this.initTargetObjectChooser();
        this.initTargetVariableList();
        this.initParametersPanel();
        this.initButtons();
    }

    protected void doAction() {
        if (this.toClassRadioButton.isSelected()) {
            this.selectedTarget = this.targetVariableList.getSelectedValue();
        }
        if (this.toObjectRadioButton.isSelected() && this.selectedTarget == null) {
            this.setErrorText(KotlinBundle.message((String)"text.no.destination.object.specified", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap<KtClass, String> oldClassParameterNames = new LinkedHashMap<KtClass, String>();
        for (Map.Entry<KtClass, EditorTextField> entry : this.oldClassParameterNameFields.entrySet()) {
            EditorTextField field2 = entry.getValue();
            if (!Name.isValidIdentifier((String)field2.getText())) {
                this.setErrorText(KotlinBundle.message((String)"parameter.name.is.invalid", (Object[])new Object[]{field2.getText()}));
                return;
            }
            if (!field2.isEnabled()) continue;
            oldClassParameterNames.put(entry.getKey(), field2.getText());
        }
        MoveKotlinMethodProcessor processor2 = new MoveKotlinMethodProcessor(this.method, this.selectedTarget, oldClassParameterNames, this.openInEditorCheckBox.isSelected());
        this.invokeRefactoring(processor2);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    private void initButtons() {
        this.toClassRadioButton.addActionListener(e -> this.enableTargetChooser());
        this.toObjectRadioButton.addActionListener(e -> this.enableTargetChooser());
        if (this.variables.length != 0 && !(this.targetContainer instanceof KtObjectDeclaration)) {
            this.toClassRadioButton.setSelected(true);
        } else {
            this.toObjectRadioButton.setSelected(true);
            if (this.variables.length == 0) {
                this.toClassRadioButton.setEnabled(false);
            }
        }
        this.enableTextFields();
        this.enableTargetChooser();
    }

    private void initTargetVariableList() {
        AbstractListModel<KtNamedDeclaration> listModel = new AbstractListModel<KtNamedDeclaration>(){

            @Override
            public int getSize() {
                return MoveKotlinMethodDialog.this.variables.length;
            }

            @Override
            public KtNamedDeclaration getElementAt(int index2) {
                return MoveKotlinMethodDialog.this.variables[index2];
            }
        };
        this.targetVariableList = new JBList((ListModel)listModel);
        DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer(){
            private final DescriptorRenderer renderer = IdeDescriptorRenderers.SOURCE_CODE_TYPES_WITH_SHORT_NAMES;

            @Override
            public Component getListCellRendererComponent(JList<?> list2, Object value, int index2, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list2, value, index2, isSelected, cellHasFocus);
                if (value instanceof KtNamedDeclaration) {
                    KtNamedDeclaration variable = (KtNamedDeclaration)value;
                    this.setIcon(PsiIconUtil.getIconFromProviders((PsiElement)variable, (int)0));
                    this.setText(variable.getName());
                    KotlinType type2 = MoveKotlinMethodProcessorKt.type(variable);
                    if (type2 != null) {
                        @NlsSafe String renderType = this.renderer.renderType(type2);
                        this.setText(this.getText() + ": " + renderType);
                    }
                }
                return this;
            }
        };
        this.targetVariableList.setCellRenderer(listCellRenderer);
        this.targetVariableList.setSelectionMode(0);
        int defaultVariableIndex = -1;
        for (int i2 = 0; i2 < this.variables.length; ++i2) {
            if (this.variableToClassMap.get(this.variables[i2]) != this.targetContainer) continue;
            defaultVariableIndex = i2;
        }
        this.targetVariableList.setSelectedIndex(defaultVariableIndex != -1 ? defaultVariableIndex : 0);
        this.targetVariableList.getSelectionModel().addListSelectionListener(e -> this.enableTextFields());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.targetVariableList);
        this.targetVariableListPanel.add(scrollPane);
    }

    private void initTargetObjectChooser() {
        this.targetObjectChooser = new KotlinTypeReferenceEditorComboWithBrowseButton(e -> {
            TreeJavaClassChooserDialog chooser2 = this.createTreeClassChooser();
            chooser2.selectDirectory(this.method.getContainingFile().getContainingDirectory());
            chooser2.showDialog();
            PsiClass psiClass = chooser2.getSelected();
            if (psiClass instanceof KtLightClassForSourceDeclaration) {
                this.selectedTarget = ((KtLightClassForSourceDeclaration)psiClass).getKotlinOrigin();
                this.targetObjectChooser.setText(Objects.requireNonNull(psiClass.getQualifiedName()));
            }
        }, this.targetContainer == null || this.targetContainer.getFqName() == null ? null : this.targetContainer.getFqName().asString(), (PsiElement)(this.targetContainer == null ? (PsiElement)Objects.requireNonNull(KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)this.method)) : this.targetContainer), RECENTS_KEY);
        KtTypeCodeFragment codeFragment = this.targetObjectChooser.getCodeFragment();
        if (codeFragment != null) {
            CompletionUtilsKt.setExtraCompletionFilter((KtCodeFragment)codeFragment, (Function1<? super LookupElement, Boolean>)((Function1)lookupElement2 -> {
                Object lookupObject = lookupElement2.getObject();
                if (!(lookupObject instanceof DescriptorBasedDeclarationLookupObject)) {
                    return false;
                }
                PsiElement psiElement = ((DescriptorBasedDeclarationLookupObject)lookupObject).getPsiElement();
                if (lookupObject instanceof PackageLookupObject) {
                    return true;
                }
                return psiElement instanceof KtObjectDeclaration && KotlinCommonRefactoringUtilKt.canRefactorElement(psiElement);
            }));
        }
        this.targetObjectChooserPanel.add((Component)((Object)this.targetObjectChooser));
    }

    private void enableTextFields() {
        for (EditorTextField textField2 : this.oldClassParameterNameFields.values()) {
            textField2.setEnabled(true);
        }
        if (this.toClassRadioButton.isSelected()) {
            EditorTextField field2;
            Set<KtNamedDeclaration> members;
            KtNamedDeclaration variable = this.variables[this.targetVariableList.getSelectedIndex()];
            KtClassOrObject containingClass = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)variable);
            if (!(containingClass instanceof KtClass)) {
                return;
            }
            if ((!(variable instanceof KtParameter) || ((KtParameter)variable).hasValOrVar()) && (members = this.thisClassesToMembers.get(containingClass)) != null && members.size() == 1 && members.contains(variable) && (field2 = this.oldClassParameterNameFields.get(containingClass)) != null) {
                field2.setEnabled(false);
            }
        }
    }

    private void enableTargetChooser() {
        if (this.toClassRadioButton.isSelected()) {
            this.targetVariableList.setEnabled(true);
            this.targetObjectChooser.setEnabled(false);
        } else {
            this.targetVariableList.setEnabled(false);
            this.targetObjectChooser.setEnabled(true);
        }
        this.enableTextFields();
    }

    private void initParametersPanel() {
        if (this.thisClassesToMembers.isEmpty()) {
            return;
        }
        this.parametersPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        Fe10KotlinNewDeclarationNameValidator validator2 = new Fe10KotlinNewDeclarationNameValidator((PsiElement)this.method, null, KotlinNameSuggestionProvider.ValidatorTarget.PARAMETER, new ArrayList());
        for (KtClass ktClass : this.thisClassesToMembers.keySet()) {
            SimpleType type2 = MoveKotlinMethodProcessorKt.defaultType(ktClass);
            if (type2 == null) continue;
            String text = KotlinBundle.message((String)"title.select.a.name.for.this.parameter", (Object[])new Object[]{ktClass.getName()});
            this.parametersPanel.add((Component)new TitledSeparator(text, null));
            List<String> suggestedNames = Fe10KotlinNameSuggester.INSTANCE.suggestNamesByType((KotlinType)type2, validator2, null);
            String suggestedName = suggestedNames.isEmpty() ? "parameter" : suggestedNames.get(0);
            EditorTextField field2 = new EditorTextField(suggestedName, this.myProject, (FileType)KotlinFileType.INSTANCE);
            this.oldClassParameterNameFields.put(ktClass, field2);
            this.parametersPanel.add((Component)field2);
        }
    }

    private TreeJavaClassChooserDialog createTreeClassChooser() {
        return new TreeJavaClassChooserDialog(KotlinBundle.message((String)"title.choose.destination.object", (Object[])new Object[0]), this.myProject, GlobalSearchScope.projectScope((Project)this.myProject), aClass -> {
            if (!(aClass instanceof KtLightClassForSourceDeclaration)) {
                return false;
            }
            KtClassOrObject ktClassOrObject = ((KtLightClassForSourceDeclaration)aClass).getKotlinOrigin();
            return ktClassOrObject instanceof KtObjectDeclaration && !((KtObjectDeclaration)ktClassOrObject).isObjectLiteral();
        }, null, null, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "method";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "variableToClassMap";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveMethod/MoveKotlinMethodDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JPanel jPanel2;
        JPanel jPanel3;
        JRadioButton jRadioButton2;
        JPanel jPanel4;
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.toObjectRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinMethodDialog.class).getString("label.text.to.object"));
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.targetObjectChooserPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.parametersPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.toClassRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinMethodDialog.class).getString("label.text.to.class"));
        jPanel6.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.targetVariableListPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        this.openInEditorCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinMethodDialog.class).getString("open.moved.method.in.editor"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

