/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pullUp;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.pullUp.KotlinPullUpConflictSearcher;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aL\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0007\u001a&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007\u001a\u001c\u0010\u0015\u001a\u00020\u000f*\u0004\u0018\u00010\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0007\u001a'\u0010\u0018\u001a\u00020\u000f2\u000b\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"checkPullUpConflicts", "", "project", "Lcom/intellij/openapi/project/Project;", "sourceClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "targetClass", "Lcom/intellij/psi/PsiNamedElement;", "memberInfos", "", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "onShowConflicts", "Lkotlin/Function0;", "onAccept", "willBeUsedInSourceClass", "", "member", "Lcom/intellij/psi/PsiElement;", "membersToMove", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "willBeMoved", "declarationsToMove", "", "runProcessWithProgressSynchronously", "progressTitle", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "process", "Ljava/lang/Runnable;", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\ncommonPullUpConflictsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 commonPullUpConflictsUtils.kt\norg/jetbrains/kotlin/idea/refactoring/pullUp/CommonPullUpConflictsUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1786#2,3:67\n1807#2,3:70\n*S KotlinDebug\n*F\n+ 1 commonPullUpConflictsUtils.kt\norg/jetbrains/kotlin/idea/refactoring/pullUp/CommonPullUpConflictsUtilsKt\n*L\n54#1:67,3\n59#1:70,3\n*E\n"})
public final class CommonPullUpConflictsUtilsKt {
    @ApiStatus.Internal
    public static final void checkPullUpConflicts(@NotNull Project project, @NotNull KtClassOrObject sourceClass, @NotNull PsiNamedElement targetClass, @NotNull List<KotlinMemberInfo> memberInfos, @NotNull Function0<Unit> onShowConflicts, @NotNull Function0<Unit> onAccept) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceClass, (String)"sourceClass");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
        Intrinsics.checkNotNullParameter(onShowConflicts, (String)"onShowConflicts");
        Intrinsics.checkNotNullParameter(onAccept, (String)"onAccept");
        MultiMap conflicts = new MultiMap();
        String string = RefactoringBundle.message((String)"detecting.possible.conflicts");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        boolean conflictsCollected = CommonPullUpConflictsUtilsKt.runProcessWithProgressSynchronously(string, project, () -> CommonPullUpConflictsUtilsKt.checkPullUpConflicts$lambda$1(conflicts, sourceClass, targetClass, memberInfos));
        if (conflictsCollected) {
            KotlinCommonRefactoringUtilKt.checkConflictsInteractively(project, (MultiMap<PsiElement, String>)conflicts, onShowConflicts, onAccept);
        } else {
            onShowConflicts.invoke();
        }
    }

    public static /* synthetic */ void checkPullUpConflicts$default(Project project, KtClassOrObject ktClassOrObject, PsiNamedElement psiNamedElement, List list2, Function0 function0, Function0 function02, int n, Object object) {
        if ((n & 0x10) != 0) {
            function0 = CommonPullUpConflictsUtilsKt::checkPullUpConflicts$lambda$0;
        }
        CommonPullUpConflictsUtilsKt.checkPullUpConflicts(project, ktClassOrObject, psiNamedElement, list2, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    @ApiStatus.Internal
    public static final boolean willBeUsedInSourceClass(@NotNull PsiElement member, @NotNull KtClassOrObject sourceClass, @NotNull Collection<? extends KtNamedDeclaration> membersToMove) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            Intrinsics.checkNotNullParameter((Object)sourceClass, (String)"sourceClass");
            Intrinsics.checkNotNullParameter(membersToMove, (String)"membersToMove");
            Iterable $this$all$iv = ReferencesSearch.search((PsiElement)member, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)sourceClass)), (boolean)false).asIterable();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiReference it = (PsiReference)element$iv;
                    boolean bl2 = false;
                    if (CommonPullUpConflictsUtilsKt.willBeMoved(it.getElement(), (Iterable<? extends KtNamedDeclaration>)membersToMove)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return !bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public static final boolean willBeMoved(@Nullable PsiElement $this$willBeMoved, @NotNull Iterable<? extends KtNamedDeclaration> declarationsToMove) {
        KtNamedDeclaration it;
        Intrinsics.checkNotNullParameter(declarationsToMove, (String)"declarationsToMove");
        if ($this$willBeMoved == null) return false;
        Iterable<? extends KtNamedDeclaration> $this$any$iv = declarationsToMove;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator<? extends KtNamedDeclaration> iterator2 = $this$any$iv.iterator();
        do {
            KtNamedDeclaration element$iv;
            if (!iterator2.hasNext()) return false;
            it = element$iv = iterator2.next();
            boolean bl = false;
        } while (!PsiUtilsKt.isAncestor((PsiElement)((PsiElement)it), (PsiElement)$this$willBeMoved, (boolean)false));
        return true;
    }

    private static final boolean runProcessWithProgressSynchronously(String progressTitle, Project project, Runnable process2) {
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, progressTitle, true, project);
    }

    private static final Unit checkPullUpConflicts$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit checkPullUpConflicts$lambda$1$0(MultiMap $conflicts, KtClassOrObject $sourceClass, PsiNamedElement $targetClass, List $memberInfos) {
        $conflicts.putAllValues(KotlinPullUpConflictSearcher.Companion.getInstance().collectConflicts($sourceClass, $targetClass, $memberInfos));
        return Unit.INSTANCE;
    }

    private static final void checkPullUpConflicts$lambda$1(MultiMap $conflicts, KtClassOrObject $sourceClass, PsiNamedElement $targetClass, List $memberInfos) {
        ApplicationUtilsKt.runReadAction(() -> CommonPullUpConflictsUtilsKt.checkPullUpConflicts$lambda$1$0($conflicts, $sourceClass, $targetClass, $memberInfos));
    }
}

