/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.idea.refactoring.pullUp.CommonPullUpUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.MarkingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.K1PushDownContext;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownProcessor;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownImplKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J)\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0014\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u001d\u0010\u001d\u001a\u00020\u00192\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0014\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/K1PushDownProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "sourceClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "membersToMove", "", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtClass;Ljava/util/List;)V", "context", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/K1PushDownContext;", "getContext", "()Lorg/jetbrains/kotlin/idea/refactoring/pushDown/K1PushDownContext;", "renderSourceClassForConflicts", "", "analyzePushDownConflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/util/containers/MultiMap;", "pushDownToClass", "", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "removeOriginalMembers", "performRefactoring", "([Lcom/intellij/usageView/UsageInfo;)V", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nK1PushDownProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K1PushDownProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/K1PushDownProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1915#2,2:129\n14060#3:131\n14061#3:133\n1#4:132\n*S KotlinDebug\n*F\n+ 1 K1PushDownProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/K1PushDownProcessor\n*L\n119#1:129,2\n122#1:131\n122#1:133\n*E\n"})
public final class K1PushDownProcessor
extends KotlinPushDownProcessor {
    @NotNull
    private final K1PushDownContext context;

    public K1PushDownProcessor(@NotNull Project project, @NotNull KtClass sourceClass, @NotNull List<KotlinMemberInfo> membersToMove) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceClass, (String)"sourceClass");
        Intrinsics.checkNotNullParameter(membersToMove, (String)"membersToMove");
        super(project);
        this.context = new K1PushDownContext(sourceClass, membersToMove);
    }

    @Override
    @NotNull
    protected K1PushDownContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    protected String renderSourceClassForConflicts() {
        return PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)this.getContext().getSourceClassDescriptor());
    }

    @Override
    @NotNull
    protected MultiMap<PsiElement, String> analyzePushDownConflicts(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        return PushDownConflictsUtilsKt.analyzePushDownConflicts(this.getContext(), usages2);
    }

    private final void pushDownToClass(KtClassOrObject targetClass) {
        SimpleType simpleType = this.getContext().getSourceClassDescriptor().getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        SimpleType sourceClassType = simpleType;
        DeclarationDescriptor declarationDescriptor = ResolutionFacade.resolveToDescriptor$default(this.getContext().getResolutionFacade(), (KtDeclaration)targetClass, null, 2, null);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor targetClassDescriptor = (ClassDescriptor)declarationDescriptor;
        KotlinType kotlinType = (KotlinType)sourceClassType;
        SimpleType simpleType2 = targetClassDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getDefaultType(...)");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = TypeUtils.getTypeSubstitution(kotlinType, (KotlinType)simpleType2);
        TypeSubstitutor substitutor2 = TypeUtils.orEmpty((TypeSubstitutor)(linkedHashMap != null ? TypeUtils.toSubstitutor((Map<TypeConstructor, ? extends TypeProjection>)linkedHashMap) : null));
        for (KotlinMemberInfo memberInfo : this.getContext().getMembersToMove()) {
            KtNamedDeclaration ktNamedDeclaration;
            KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
            if (this.getContext().getMemberDescriptors().get(member) == null) continue;
            KtNamedDeclaration ktNamedDeclaration2 = member;
            if (ktNamedDeclaration2 instanceof KtProperty || ktNamedDeclaration2 instanceof KtNamedFunction) {
                CallableMemberDescriptor cfr_ignored_0 = (CallableMemberDescriptor)memberDescriptor;
                Intrinsics.checkNotNull((Object)member, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                ktNamedDeclaration = (KtNamedDeclaration)PushDownImplKt.moveCallableMemberToClass((KtCallableDeclaration)member, (CallableMemberDescriptor)memberDescriptor, targetClass, targetClassDescriptor, substitutor2, memberInfo.isToAbstract());
            } else {
                if (!(ktNamedDeclaration2 instanceof KtClassOrObject) && !(ktNamedDeclaration2 instanceof KtPsiClassWrapper)) continue;
                if (memberInfo.getOverrides() != null) {
                    KtSuperTypeListEntry ktSuperTypeListEntry = PullUpUtilsKt.getSuperTypeEntryByDescriptor((KtClassOrObject)this.getContext().getSourceClass(), (ClassDescriptor)memberDescriptor, this.getContext().getSourceClassContext());
                    if (ktSuperTypeListEntry == null) continue;
                    KtSuperTypeListEntry it = ktSuperTypeListEntry;
                    boolean bl = false;
                    PullUpUtilsKt.addSuperTypeEntry(it, targetClass, targetClassDescriptor, this.getContext().getSourceClassContext(), substitutor2);
                    continue;
                }
                ktNamedDeclaration = CommonPullUpUtilsKt.addMemberToTarget(member, targetClass);
            }
            KtNamedDeclaration movedMember = ktNamedDeclaration;
            MarkingUtilsKt.applyMarking(movedMember, substitutor2, targetClassDescriptor);
        }
    }

    private final void removeOriginalMembers() {
        for (KotlinMemberInfo memberInfo : this.getContext().getMembersToMove()) {
            DeclarationDescriptor memberDescriptor;
            KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
            if (this.getContext().getMemberDescriptors().get(member) == null) continue;
            KtNamedDeclaration ktNamedDeclaration = member;
            if (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtNamedFunction) {
                Intrinsics.checkNotNull((Object)member, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                KtCallableDeclaration cfr_ignored_0 = (KtCallableDeclaration)member;
                CallableMemberDescriptor cfr_ignored_1 = (CallableMemberDescriptor)memberDescriptor;
                if (((CallableMemberDescriptor)memberDescriptor).getModality() != Modality.ABSTRACT && memberInfo.isToAbstract()) {
                    if (((KtTypeParameterListOwnerStub)member).hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                        ((KtTypeParameterListOwnerStub)member).addModifier(KtTokens.PROTECTED_KEYWORD);
                    }
                    KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)member;
                    CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)memberDescriptor;
                    TypeSubstitutor typeSubstitutor = TypeSubstitutor.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor, (String)"EMPTY");
                    PullUpUtilsKt.makeAbstract(ktCallableDeclaration, callableMemberDescriptor, typeSubstitutor, this.getContext().getSourceClass());
                    KtTypeReference ktTypeReference = ((KtCallableDeclaration)member).getTypeReference();
                    if (ktTypeReference != null) {
                        DelayedRequestsWaitingSetKt.addToShorteningWaitSet$default((KtElement)ktTypeReference, null, 1, null);
                    }
                    continue;
                }
                ((KtTypeParameterListOwnerStub)member).delete();
                continue;
            }
            if (!(ktNamedDeclaration instanceof KtClassOrObject) && !(ktNamedDeclaration instanceof KtPsiClassWrapper)) continue;
            if (memberInfo.getOverrides() != null) {
                KtSuperTypeListEntry ktSuperTypeListEntry = PullUpUtilsKt.getSuperTypeEntryByDescriptor((KtClassOrObject)this.getContext().getSourceClass(), (ClassDescriptor)memberDescriptor, this.getContext().getSourceClassContext());
                if (ktSuperTypeListEntry == null) continue;
                KtSuperTypeListEntry it = ktSuperTypeListEntry;
                boolean bl = false;
                this.getContext().getSourceClass().removeSuperTypeListEntry(it);
                continue;
            }
            member.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        ArrayList markedElements = new ArrayList();
        try {
            UsageInfo[] $this$forEach$iv = (UsageInfo[])this.getContext().getMembersToMove();
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                KotlinMemberInfo it = (KotlinMemberInfo)((Object)t);
                boolean bl = false;
                Collection collection = markedElements;
                PsiElement psiElement = it.getMember();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getMember(...)");
                CollectionsKt.addAll((Collection)collection, (Iterable)MarkingUtilsKt.markElements((KtNamedDeclaration)psiElement, this.getContext().getSourceClassContext(), this.getContext().getSourceClassDescriptor(), null));
            }
            $this$forEach$iv = usages2;
            $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                KtClassOrObject it;
                UsageInfo element$iv;
                UsageInfo it2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                PsiElement psiElement = it2.getElement();
                if ((psiElement instanceof KtClassOrObject ? (KtClassOrObject)psiElement : null) == null) continue;
                it = it;
                boolean bl2 = false;
                this.pushDownToClass(it);
            }
            this.removeOriginalMembers();
        }
        finally {
            MarkingUtilsKt.clearMarking(markedElements);
        }
    }
}

