/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.ANDCombinedMemberInfoModel;
import com.intellij.refactoring.classMembers.DelegatingMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfoKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionPanel;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinUsesDependencyMemberInfoModel;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownProcessor;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownProcessorProvider;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0006\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "project", "Lcom/intellij/openapi/project/Project;", "memberInfos", "", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "sourceClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtClass;)V", "memberInfoModel", "Lcom/intellij/refactoring/classMembers/MemberInfoModel;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "selectedMemberInfos", "getSelectedMemberInfos", "()Ljava/util/List;", "getDimensionServiceKey", "", "createNorthPanel", "Ljavax/swing/JComponent;", "createCenterPanel", "doAction", "", "hasHelpAction", "", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKotlinPushDownDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPushDownDialog.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n777#2:118\n873#2,2:119\n*S KotlinDebug\n*F\n+ 1 KotlinPushDownDialog.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownDialog\n*L\n41#1:118\n41#1:119,2\n*E\n"})
public final class KotlinPushDownDialog
extends RefactoringDialog {
    @NotNull
    private final List<KotlinMemberInfo> memberInfos;
    @NotNull
    private final KtClass sourceClass;
    @Nullable
    private MemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> memberInfoModel;

    public KotlinPushDownDialog(@NotNull Project project, @NotNull List<KotlinMemberInfo> memberInfos, @NotNull KtClass sourceClass) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
        Intrinsics.checkNotNullParameter((Object)sourceClass, (String)"sourceClass");
        super(project, true);
        this.memberInfos = memberInfos;
        this.sourceClass = sourceClass;
        this.setTitle(KotlinPushDownHandlerKt.getPUSH_MEMBERS_DOWN());
        this.init();
    }

    /*
     * Unable to fully structure code
     */
    private final List<KotlinMemberInfo> getSelectedMemberInfos() {
        $this$filter$iv = this.memberInfos;
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (KotlinMemberInfo)element$iv$iv;
            $i$a$-filter-KotlinPushDownDialog$selectedMemberInfos$1 = false;
            if (!it.isChecked()) ** GOTO lbl-1000
            v0 = this.memberInfoModel;
            if (v0 != null ? v0.isMemberEnabled((MemberInfoBase)it) : false) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    @NotNull
    protected JComponent createNorthPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbConstraints.insets = (Insets)JBUI.insets((int)4, (int)0, (int)10, (int)8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        Object[] objectArray = new Object[]{KotlinMemberInfoKt.qualifiedClassNameForRendering((PsiNamedElement)this.sourceClass)};
        panel.add((Component)new JLabel(RefactoringBundle.message((String)"push.members.from.0.down.label", (Object[])objectArray)), gbConstraints);
        return panel;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        KotlinMemberSelectionPanel memberSelectionPanel = new KotlinMemberSelectionPanel(RefactoringBundle.message((String)"members.to.be.pushed.down.panel.title"), this.memberInfos, RefactoringBundle.message((String)"keep.abstract.column.header"), null, 8, null);
        panel.add((Component)((Object)memberSelectionPanel), "Center");
        ANDCombinedMemberInfoModel aNDCombinedMemberInfoModel = new ANDCombinedMemberInfoModel((MemberInfoModel)new KotlinUsesDependencyMemberInfoModel((KtClassOrObject)this.sourceClass, null, false), (MemberInfoModel)new UsedByDependencyMemberInfoModel((PsiElement)this.sourceClass));
        this.memberInfoModel = (MemberInfoModel)new DelegatingMemberInfoModel<KtNamedDeclaration, KotlinMemberInfo>((ANDCombinedMemberInfoModel<KtNamedDeclaration, KotlinMemberInfo>)aNDCombinedMemberInfoModel){

            public Void isFixedAbstract(KotlinMemberInfo member) {
                return null;
            }

            public boolean isAbstractEnabled(KotlinMemberInfo memberInfo) {
                Intrinsics.checkNotNullParameter((Object)((Object)memberInfo), (String)"memberInfo");
                KtNamedDeclaration member = (KtNamedDeclaration)memberInfo.getMember();
                if (member.hasModifier(KtTokens.INLINE_KEYWORD) || member.hasModifier(KtTokens.EXTERNAL_KEYWORD) || member.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
                    return false;
                }
                return member instanceof KtNamedFunction || member instanceof KtProperty;
            }
        };
        MemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> memberInfoModel = this.memberInfoModel;
        Intrinsics.checkNotNull(memberInfoModel);
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)this.memberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel(this.memberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.memberInfoModel);
        return panel;
    }

    protected void doAction() {
        if (!this.isOKActionEnabled()) {
            return;
        }
        KotlinCommonRefactoringSettings.Companion.getInstance().setPUSH_DOWN_PREVIEW_USAGES(this.isPreviewUsages());
        KotlinPushDownProcessorProvider kotlinPushDownProcessorProvider = KotlinPushDownProcessorProvider.Companion.getInstance();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinPushDownProcessor processor2 = kotlinPushDownProcessorProvider.createPushDownProcessor(project, this.sourceClass, this.getSelectedMemberInfos());
        this.invokeRefactoring(processor2);
    }

    protected boolean hasHelpAction() {
        return false;
    }
}

