/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bH\u0016J\r\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\rH\u0016J\r\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticFileRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "newFileName", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;)V", "allowChangeSuggestedName", "", "getDialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "getDialogDescription", "Lcom/intellij/openapi/util/NlsContexts$Button;", "entityName", "Lcom/intellij/openapi/util/NlsContexts$ColumnName;", "isSelectedByDefault", "kotlin.refactorings.common"})
public final class AutomaticFileRenamer
extends AutomaticRenamer {
    public AutomaticFileRenamer(@NotNull KtFile file, @NotNull String newFileName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newFileName, (String)"newFileName");
        this.myElements.add(file);
        String string = file.getName();
        String string2 = file.getVirtualFile().getExtension();
        if (string2 == null) {
            string2 = "kt";
        }
        this.suggestAllNames(string, newFileName + "." + string2);
    }

    public boolean allowChangeSuggestedName() {
        return false;
    }

    @NotNull
    public String getDialogTitle() {
        return KotlinBundle.message((String)"title.rename.file", (Object[])new Object[0]);
    }

    @NotNull
    public String getDialogDescription() {
        return KotlinBundle.message((String)"title.rename.file.to", (Object[])new Object[0]);
    }

    @NotNull
    public String entityName() {
        return KotlinBundle.message((String)"file.entity", (Object[])new Object[0]);
    }

    public boolean isSelectedByDefault() {
        return true;
    }
}

