/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.findUsages.KotlinFindUsagesSupport;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0012\u0010\u000b\u001a\f0\u0005\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "newName", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtParameter;Ljava/lang/String;)V", "processHierarchy", "", "getDialogTitle", "getDialogDescription", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "entityName", "isSelectedByDefault", "", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nAutomaticParameterRenamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomaticParameterRenamer.kt\norg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,66:1\n296#2,2:67\n1401#3,2:69\n*S KotlinDebug\n*F\n+ 1 AutomaticParameterRenamer.kt\norg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer\n*L\n33#1:67,2\n34#1:69,2\n*E\n"})
public final class AutomaticParameterRenamer
extends AutomaticRenamer {
    public AutomaticParameterRenamer(@NotNull KtParameter element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        this.processHierarchy(element, newName);
    }

    private final void processHierarchy(KtParameter element, String newName) {
        KtDeclarationWithBody ktDeclarationWithBody = element.getOwnerFunction();
        if (ktDeclarationWithBody == null) {
            return;
        }
        KtDeclarationWithBody function = ktDeclarationWithBody;
        PsiElement psiElement = (PsiElement)function;
        SearchScope searchScope = function.getUseScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        for (PsiElement overrider : KotlinFindUsagesSupport.Companion.searchOverriders(psiElement, searchScope)) {
            PsiNamedElement parameter;
            PsiNamedElement psiNamedElement;
            PsiNamedElement callable;
            if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)overrider) == null || !KotlinCommonRefactoringUtilKt.canRefactorElement((PsiElement)callable)) continue;
            Object object = callable;
            if (object instanceof KtCallableDeclaration) {
                Object v4;
                block8: {
                    List list2 = ((KtCallableDeclaration)callable).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
                    $this$firstOrNull$iv = (Object[])list2;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtParameter it = (KtParameter)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)element.getName())) continue;
                        v4 = element$iv;
                        break block8;
                    }
                    v4 = null;
                }
                psiNamedElement = v4;
            } else if (object instanceof PsiMethod) {
                Object object2;
                block9: {
                    PsiParameter[] psiParameterArray = ((PsiMethod)callable).getParameterList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                    $this$firstOrNull$iv = psiParameterArray;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiParameter it = (PsiParameter)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)element.getName())) continue;
                        object2 = element$iv;
                        break block9;
                    }
                    object2 = null;
                }
                psiNamedElement = (PsiNamedElement)object2;
            } else {
                psiNamedElement = null;
            }
            if ((parameter = psiNamedElement) == null) continue;
            List list3 = this.myElements;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"myElements");
            object = list3;
            object.add(parameter);
        }
        this.suggestAllNames(element.getName(), KtPsiUtilKt.quoteIfNeeded((String)newName));
    }

    @NotNull
    public String getDialogTitle() {
        return KotlinBundle.message((String)"text.rename.parameters.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getDialogDescription() {
        String string = RefactoringBundle.message((String)"title.rename.parameters.hierarchy");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String entityName() {
        return KotlinBundle.message((String)"text.parameter", (Object[])new Object[0]);
    }

    public boolean isSelectedByDefault() {
        return true;
    }
}

