/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewTypeLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameRefactoringSupport;
import org.jetbrains.kotlin.idea.refactoring.rename.LostDefaultValuesInOverridingFunctionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.UnresolvableConventionViolationUsageInfo;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aA\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0004\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000eH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u001a4\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\u0012\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\b0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u001a&\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00132\u0016\u0010\u0014\u001a\u0012\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\b0\u0015H\u0002\u001a\f\u0010\u001b\u001a\u00020\u0011*\u00020\u0002H\u0007\u001a\f\u0010\u001c\u001a\u00020\n*\u00020\u001dH\u0002\u001a>\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!2\u0006\u0010\"\u001a\u00020#2\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130!\u0012\u0004\u0012\u00020\u00110$\u001a\"\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130!2\u0006\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!\u001a%\u0010&\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b'2\u0006\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"useScopeForRename", "Lcom/intellij/psi/search/SearchScope;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getUseScopeForRename", "(Lorg/jetbrains/kotlin/psi/KtParameter;)Lcom/intellij/psi/search/SearchScope;", "runProcessWithProgressSynchronously", "T", "progressTitle", "", "canBeCancelled", "", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lkotlin/Function0;", "(Ljava/lang/String;ZLcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "checkConflictsAndReplaceUsageInfos", "", "element", "Lcom/intellij/psi/PsiElement;", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "getOverriddenFunctionWithDefaultValues", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "dropDefaultValue", "isAbstract", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "checkSuperMethodsWithPopup", "declaration", "deepestSuperMethods", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lkotlin/Function1;", "checkSuperMethods", "getRenameBaseTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\ncommonRenameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 commonRenameUtils.kt\norg/jetbrains/kotlin/idea/refactoring/rename/CommonRenameUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,216:1\n1642#2,10:217\n1915#2:227\n1916#2:229\n1652#2:230\n812#2,12:231\n296#2:243\n1807#2,3:244\n297#2:247\n1642#2,10:249\n1915#2:259\n1916#2:261\n1652#2:262\n1807#2,3:263\n1807#2,3:266\n1#3:228\n1#3:260\n73#4:248\n73#4:269\n*S KotlinDebug\n*F\n+ 1 commonRenameUtils.kt\norg/jetbrains/kotlin/idea/refactoring/rename/CommonRenameUtilsKt\n*L\n107#1:217,10\n107#1:227\n107#1:229\n107#1:230\n111#1:231,12\n112#1:243\n112#1:244,3\n112#1:247\n148#1:249,10\n148#1:259\n148#1:261\n148#1:262\n149#1:263,3\n150#1:266,3\n107#1:228\n148#1:260\n140#1:248\n182#1:269\n*E\n"})
public final class CommonRenameUtilsKt {
    @NotNull
    public static final SearchScope getUseScopeForRename(@NotNull KtParameter $this$useScopeForRename) {
        Intrinsics.checkNotNullParameter((Object)$this$useScopeForRename, (String)"<this>");
        KtDeclarationWithBody ktDeclarationWithBody = $this$useScopeForRename.getOwnerFunction();
        KtFunction owner = ktDeclarationWithBody instanceof KtFunction ? (KtFunction)ktDeclarationWithBody : null;
        KtFunction ktFunction = owner;
        if (ktFunction == null || (ktFunction = ktFunction.getUseScope()) == null) {
            SearchScope searchScope = $this$useScopeForRename.getUseScope();
            ktFunction = searchScope;
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        }
        return ktFunction;
    }

    public static final <T> T runProcessWithProgressSynchronously(@NlsContexts.DialogMessage @NotNull String progressTitle, boolean canBeCancelled, @NotNull Project project, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)progressTitle, (String)"progressTitle");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$runProcessWithProgressSynchronously = false;
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(action2){
            final /* synthetic */ Function0<T> $action;
            {
                this.$action = $action;
            }

            public final T compute() {
                return (T)this.$action.invoke();
            }
        }, progressTitle, canBeCancelled, project);
    }

    public static final void checkConflictsAndReplaceUsageInfos(@NotNull PsiElement element, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        KtNamedFunction ktNamedFunction = CommonRenameUtilsKt.getOverriddenFunctionWithDefaultValues(element, allRenames);
        if (ktNamedFunction != null) {
            KtNamedFunction baseFunction = ktNamedFunction;
            boolean bl = false;
            collection = result2;
            PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)element);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            collection.add(new LostDefaultValuesInOverridingFunctionUsageInfo((KtNamedFunction)psiElement, baseFunction));
        }
        ListIterator<UsageInfo> usageIterator = result2.listIterator();
        while (usageIterator.hasNext()) {
            PsiElement referencedElement;
            PsiElement refElement;
            AbstractKtReference ref;
            UsageInfo bl = usageIterator.next();
            MoveRenameUsageInfo moveRenameUsageInfo = bl instanceof MoveRenameUsageInfo ? (MoveRenameUsageInfo)bl : null;
            if (moveRenameUsageInfo == null) continue;
            MoveRenameUsageInfo usageInfo = moveRenameUsageInfo;
            collection = usageInfo.getReference();
            AbstractKtReference abstractKtReference = collection instanceof AbstractKtReference ? (AbstractKtReference)collection : null;
            if (abstractKtReference == null || (ref = abstractKtReference).canRename() || usageInfo.getElement() == null || usageInfo.getReferencedElement() == null) continue;
            usageIterator.set((UsageInfo)new UnresolvableConventionViolationUsageInfo(refElement, referencedElement));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final KtNamedFunction getOverriddenFunctionWithDefaultValues(PsiElement $this$getOverriddenFunctionWithDefaultValues, Map<? extends PsiElement, String> allRenames) {
        Object element$iv;
        Object v2;
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapNotNull$iv = allRenames.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        Iterable $this$forEach$iv$iv$iv = iterable;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl3 = false;
            PsiElement psiElement = it;
            if ((psiElement != null ? LightClassUtilsKt.getUnwrapped((PsiElement)psiElement) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elementsToRename = (List)destination$iv$iv;
        PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)$this$getOverriddenFunctionWithDefaultValues);
        if (!(psiElement instanceof KtNamedFunction)) return null;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement;
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction function = ktNamedFunction;
        List<PsiElement> overridenFunctions = KotlinRenameRefactoringSupport.Companion.getInstance().getAllOverridenFunctions(function);
        Iterable iterable2 = overridenFunctions;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$mapNotNullTo22 = iterable2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv2;
        boolean $i$f$firstOrNull = false;
        Iterator iterator3 = iterable3.iterator();
        do {
            if (!iterator3.hasNext()) {
                v2 = null;
                return v2;
            }
            element$iv = iterator3.next();
            KtNamedFunction it = (KtNamedFunction)element$iv;
            boolean bl5 = false;
            if (!elementsToRename.contains(it)) {
                boolean bl6;
                block10: {
                    Iterable $this$any$iv = it.getValueParameters();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            KtParameter it2 = (KtParameter)element$iv2;
                            boolean bl7 = false;
                            if (!it2.hasDefaultValue()) continue;
                            bl6 = true;
                            break block10;
                        }
                        bl6 = false;
                    }
                }
                if (bl6) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v2 = element$iv;
        return v2;
    }

    @ApiStatus.Internal
    public static final void dropDefaultValue(@NotNull KtParameter $this$dropDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$dropDefaultValue, (String)"<this>");
        PsiElement psiElement = $this$dropDefaultValue.getEqualsToken();
        if (psiElement == null) {
            return;
        }
        PsiElement from = psiElement;
        KtExpression ktExpression = $this$dropDefaultValue.getDefaultValue();
        PsiElement to2 = ktExpression != null ? (PsiElement)ktExpression : from;
        $this$dropDefaultValue.deleteChildRange(from, to2);
    }

    private static final boolean isAbstract(KtNamedDeclaration $this$isAbstract) {
        boolean bl;
        if ($this$isAbstract.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            bl = true;
        } else {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$isAbstract));
            KtClass ktClass = ktClassOrObject instanceof KtClass ? (KtClass)ktClassOrObject : null;
            boolean bl2 = ktClass != null ? ktClass.isInterface() : false;
            bl = !bl2 ? false : ($this$isAbstract instanceof KtProperty ? ((KtProperty)$this$isAbstract).getInitializer() == null && ((KtProperty)$this$isAbstract).getDelegate() == null && ((KtProperty)$this$isAbstract).getAccessors().isEmpty() : ($this$isAbstract instanceof KtNamedFunction ? !((KtNamedFunction)$this$isAbstract).hasBody() : false));
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkSuperMethodsWithPopup(@NotNull KtNamedDeclaration declaration, @NotNull List<? extends PsiElement> deepestSuperMethods2, @NotNull Editor editor, @NotNull Function1<? super List<? extends PsiElement>, Unit> action2) {
        boolean bl;
        boolean hasJavaMethods;
        int kindIndex;
        String title;
        block15: {
            boolean bl2;
            List unwrappedSupers;
            block14: {
                void $this$mapNotNullTo$iv$iv;
                int n;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter(deepestSuperMethods2, (String)"deepestSuperMethods");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter(action2, (String)"action");
                if (deepestSuperMethods2.isEmpty()) {
                    action2.invoke((Object)CollectionsKt.listOf((Object)declaration));
                    return;
                }
                String string = CommonRenameUtilsKt.getRenameBaseTitle(declaration, deepestSuperMethods2);
                if (string == null) {
                    action2.invoke((Object)CollectionsKt.listOf((Object)declaration));
                    return;
                }
                title = string;
                boolean $i$f$isUnitTestMode = false;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    action2.invoke(deepestSuperMethods2);
                    return;
                }
                KtNamedDeclaration ktNamedDeclaration = declaration;
                if (ktNamedDeclaration instanceof KtNamedFunction) {
                    n = 1;
                } else if (ktNamedDeclaration instanceof KtProperty || ktNamedDeclaration instanceof KtParameter) {
                    n = 2;
                } else {
                    return;
                }
                kindIndex = n;
                Iterable $this$mapNotNull$iv = deepestSuperMethods2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiNamedElement it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl4 = false;
                    if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)it) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                unwrappedSupers = (List)destination$iv$iv;
                Iterable $this$any$iv = unwrappedSupers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiNamedElement it = (PsiNamedElement)element$iv;
                        boolean bl6 = false;
                        if (!(it instanceof PsiMethod)) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            hasJavaMethods = bl2;
            Iterable $this$any$iv = unwrappedSupers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiNamedElement it = (PsiNamedElement)element$iv;
                    boolean bl7 = false;
                    if (!(it instanceof KtNamedDeclaration)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        boolean hasKtMembers = bl;
        int superKindIndex = hasJavaMethods && hasKtMembers ? 3 : (hasJavaMethods ? 4 : kindIndex);
        Object[] element$iv = new Object[]{superKindIndex + (deepestSuperMethods2.size() > 1 ? 10 : 0)};
        String renameBase = KotlinBundle.message((String)"rename.base.0", (Object[])element$iv);
        Object[] objectArray = new Object[]{kindIndex};
        String renameCurrent = KotlinBundle.message((String)"rename.only.current.0", (Object[])objectArray);
        objectArray = new String[]{renameBase, renameCurrent};
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.listOf((Object[])objectArray)).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(arg_0 -> CommonRenameUtilsKt.checkSuperMethodsWithPopup$lambda$4(arg_0 -> CommonRenameUtilsKt.checkSuperMethodsWithPopup$lambda$3(renameBase, deepestSuperMethods2, declaration, action2, arg_0), arg_0)).createPopup().showInBestPositionFor(editor);
    }

    @NotNull
    public static final List<PsiElement> checkSuperMethods(@NotNull KtNamedDeclaration declaration, @NotNull List<? extends PsiElement> deepestSuperMethods2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(deepestSuperMethods2, (String)"deepestSuperMethods");
        if (deepestSuperMethods2.isEmpty()) {
            return CollectionsKt.listOf((Object)declaration);
        }
        String string = CommonRenameUtilsKt.getRenameBaseTitle(declaration, deepestSuperMethods2);
        if (string == null) {
            return CollectionsKt.listOf((Object)declaration);
        }
        String title = string;
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return deepestSuperMethods2;
        }
        int exitCode = Messages.showYesNoCancelDialog((Project)declaration.getProject(), (String)title, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (String)KotlinBundle.message((String)"button.rename.base", (Object[])new Object[0]), (String)KotlinBundle.message((String)"button.rename.current", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
        return switch (exitCode) {
            case 0 -> deepestSuperMethods2;
            case 1 -> CollectionsKt.listOf((Object)declaration);
            default -> CollectionsKt.emptyList();
        };
    }

    private static final String getRenameBaseTitle(KtNamedDeclaration declaration, List<? extends PsiElement> deepestSuperMethods2) {
        PsiElement superMethod = (PsiElement)CollectionsKt.first(deepestSuperMethods2);
        PsiElement psiElement = superMethod;
        Pair pair = psiElement instanceof PsiMember ? TuplesKt.to((Object)((PsiMember)superMethod).getContainingClass(), (Object)((PsiMember)superMethod).hasModifierProperty("abstract")) : (psiElement instanceof KtNamedDeclaration ? TuplesKt.to((Object)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)superMethod)), (Object)CommonRenameUtilsKt.isAbstract((KtNamedDeclaration)superMethod)) : null);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        PsiElement superClass = (PsiElement)pair2.component1();
        boolean isAbstract = (Boolean)pair2.component2();
        if (superClass == null) {
            return null;
        }
        Object[] objectArray = new Object[4];
        String string = declaration.getName();
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        objectArray[1] = isAbstract ? 1 : 2;
        Intrinsics.checkNotNullExpressionValue((Object)ElementDescriptionUtil.getElementDescription((PsiElement)superMethod, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE)), (String)"getElementDescription(...)");
        Intrinsics.checkNotNullExpressionValue((Object)SymbolPresentationUtil.getSymbolPresentableText((PsiElement)superClass), (String)"getSymbolPresentableText(...)");
        return KotlinBundle.message((String)"rename.declaration.title.0.implements.1.2.of.3", (Object[])objectArray);
    }

    private static final Unit checkSuperMethodsWithPopup$lambda$3(String $renameBase, List $deepestSuperMethods, KtNamedDeclaration $declaration, Function1 $action, String value) {
        if (value == null) {
            return Unit.INSTANCE;
        }
        List chosenElements = Intrinsics.areEqual((Object)value, (Object)$renameBase) ? CollectionsKt.plus((Collection)$deepestSuperMethods, (Object)$declaration) : CollectionsKt.listOf((Object)$declaration);
        $action.invoke((Object)chosenElements);
        return Unit.INSTANCE;
    }

    private static final void checkSuperMethodsWithPopup$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

