/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticTestRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.testIntegration.framework.KotlinPsiBasedTestFramework;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinAutomaticTestRenamerFactory;", "Lcom/intellij/refactoring/rename/naming/AutomaticTestRenamerFactory;", "<init>", "()V", "isApplicable", "", "element", "Lcom/intellij/psi/PsiElement;", "createRenamer", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKotlinAutomaticTestRenamerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAutomaticTestRenamerFactory.kt\norg/jetbrains/kotlin/idea/refactoring/rename/KotlinAutomaticTestRenamerFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n2792#2,3:34\n*S KotlinDebug\n*F\n+ 1 KotlinAutomaticTestRenamerFactory.kt\norg/jetbrains/kotlin/idea/refactoring/rename/KotlinAutomaticTestRenamerFactory\n*L\n19#1:34,3\n*E\n"})
public final class KotlinAutomaticTestRenamerFactory
extends AutomaticTestRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof KtFile) {
            boolean bl;
            block5: {
                Iterable $this$none$iv = ((KtFile)element).getDeclarations();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtDeclaration it = (KtDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof KtClassOrObject && KotlinPsiBasedTestFramework.Companion.findTestFramework$default(KotlinPsiBasedTestFramework.Companion, (KtNamedDeclaration)it, false, 2, null) != null)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        KtClassOrObject ktClassOrObject = element instanceof KtClassOrObject ? (KtClassOrObject)element : null;
        if (ktClassOrObject == null) {
            return false;
        }
        KtClassOrObject namedDeclaration = ktClassOrObject;
        return KotlinPsiBasedTestFramework.Companion.findTestFramework$default(KotlinPsiBasedTestFramework.Companion, (KtNamedDeclaration)namedDeclaration, false, 2, null) == null;
    }

    @NotNull
    public AutomaticRenamer createRenamer(@NotNull PsiElement element, @NotNull String newName, @NotNull Collection<UsageInfo> usages2) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(usages2, (String)"usages");
        if (element instanceof KtFile) {
            String string = ((KtFile)element).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            pair = TuplesKt.to((Object)PackagePartClassUtils.getFilePartShortName((String)string), (Object)PackagePartClassUtils.getFilePartShortName((String)newName));
        } else {
            pair = TuplesKt.to((Object)((KtNamedDeclaration)element).getName(), (Object)newName);
        }
        Pair pair2 = pair;
        String oldClassName = (String)pair2.component1();
        String newPsiClassName = (String)pair2.component2();
        return (AutomaticRenamer)new AutomaticTestRenamerFactory.TestsRenamer((PsiNamedElement)element, newPsiClassName, oldClassName);
    }
}

