/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u001a&\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"canDeleteElement", "", "Lcom/intellij/psi/PsiElement;", "cleanUpOverrides", "", "Lcom/intellij/psi/PsiMethod;", "checkParametersInMethodHierarchy", "", "parameter", "Lcom/intellij/psi/PsiParameter;", "collectParametersHierarchy", "", "method", "addParameter", "result", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/refactoring/safeDelete/UtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1253#2,2:103\n73#3:105\n3938#4:106\n4474#4,2:107\n1915#5,2:109\n777#5:111\n873#5,2:112\n1915#5,2:114\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/refactoring/safeDelete/UtilsKt\n*L\n46#1:103,2\n59#1:105\n81#1:106\n81#1:107,2\n82#1:109,2\n85#1:111\n85#1:112,2\n86#1:114,2\n*E\n"})
public final class UtilsKt {
    public static final boolean canDeleteElement(@NotNull PsiElement $this$canDeleteElement) {
        Intrinsics.checkNotNullParameter((Object)$this$canDeleteElement, (String)"<this>");
        if ($this$canDeleteElement instanceof KtObjectDeclaration && ((KtObjectDeclaration)$this$canDeleteElement).isObjectLiteral()) {
            return false;
        }
        if ($this$canDeleteElement instanceof KtParameter) {
            PsiElement psiElement = ((KtParameter)$this$canDeleteElement).getParent();
            KtParameterList ktParameterList = psiElement instanceof KtParameterList ? (KtParameterList)psiElement : null;
            if (ktParameterList == null) {
                return false;
            }
            KtParameterList parameterList = ktParameterList;
            PsiElement psiElement2 = parameterList.getParent();
            KtDeclaration ktDeclaration = psiElement2 instanceof KtDeclaration ? (KtDeclaration)psiElement2 : null;
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration declaration = ktDeclaration;
            return !(declaration instanceof KtPropertyAccessor);
        }
        return $this$canDeleteElement instanceof KtClassOrObject || $this$canDeleteElement instanceof KtSecondaryConstructor || $this$canDeleteElement instanceof KtNamedFunction || $this$canDeleteElement instanceof PsiMethod || $this$canDeleteElement instanceof PsiClass || $this$canDeleteElement instanceof KtProperty || $this$canDeleteElement instanceof KtTypeParameter || $this$canDeleteElement instanceof KtTypeAlias;
    }

    public static final void cleanUpOverrides(@NotNull PsiMethod $this$cleanUpOverrides) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanUpOverrides, (String)"<this>");
        Object[] objectArray = $this$cleanUpOverrides.findSuperMethods(true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findSuperMethods(...)");
        Object[] superMethods = objectArray;
        for (PsiMethod overridingMethod : OverridingMethodsSearch.search((PsiMethod)$this$cleanUpOverrides, (boolean)true).findAll()) {
            boolean bl;
            block2: {
                Sequence currentSuperMethods;
                if (JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)overridingMethod) != null) continue;
                PsiMethod[] psiMethodArray = overridingMethod.findSuperMethods(true);
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
                Sequence $this$all$iv = currentSuperMethods = SequencesKt.plus((Sequence)ArraysKt.asSequence((Object[])psiMethodArray), (Sequence)ArraysKt.asSequence((Object[])superMethods));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    PsiMethod superMethod = (PsiMethod)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)superMethod);
                    if (Intrinsics.areEqual((Object)LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)superMethod)), (Object)LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)$this$cleanUpOverrides)))) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            Intrinsics.checkNotNull((Object)overridingMethod);
            PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)overridingMethod));
            if (psiElement == null) continue;
            KotlinCommonRefactoringUtilKt.removeOverrideModifier(psiElement);
        }
    }

    @Nullable
    public static final Collection<PsiElement> checkParametersInMethodHierarchy(@NotNull PsiParameter parameter) {
        Collection parametersToDelete;
        PsiMethod method;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                PsiElement psiElement = parameter.getDeclarationScope();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                method = (PsiMethod)psiElement;
                ProgressManager progressManager = ProgressManager.getInstance();
                ThrowableComputable throwableComputable = () -> UtilsKt.checkParametersInMethodHierarchy$lambda$0(method, parameter);
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)parameter.getName(), (String)"getName(...)");
                parametersToDelete = (Collection)progressManager.runProcessWithProgressSynchronously(throwableComputable, KotlinBundle.message((String)"progress.title.collect.hierarchy", (Object[])objectArray), true, parameter.getProject());
                if (parametersToDelete == null || parametersToDelete.size() <= 1) break block2;
                boolean $i$f$isUnitTestMode = false;
                if (!ApplicationManager.getApplication().isUnitTestMode()) break block3;
            }
            return parametersToDelete;
        }
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ElementDescriptionUtil.getElementDescription((PsiElement)((PsiElement)method), (ElementDescriptionLocation)((ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT)), (String)"getElementDescription(...)");
        String message2 = KotlinBundle.message((String)"override.declaration.delete.multiple.parameters", (Object[])objectArray);
        int exitCode = Messages.showOkCancelDialog((Project)parameter.getProject(), (String)message2, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        return exitCode == 0 ? parametersToDelete : null;
    }

    private static final Set<PsiElement> collectParametersHierarchy(PsiMethod method, PsiParameter parameter) {
        ArrayDeque<PsiMethod> queue = new ArrayDeque<PsiMethod>();
        HashSet visited = new HashSet();
        HashSet parametersToDelete = new HashSet();
        queue.add(method);
        while (!queue.isEmpty()) {
            Iterable $this$forEach$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            PsiMethod currentMethod = (PsiMethod)queue.poll();
            ((Collection)visited).add(currentMethod);
            Intrinsics.checkNotNull((Object)currentMethod);
            UtilsKt.addParameter(currentMethod, parametersToDelete, parameter);
            PsiMethod[] psiMethodArray = currentMethod.findSuperMethods(true);
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
            Object[] objectArray = psiMethodArray;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiMethod it = (PsiMethod)element$iv$iv;
                boolean bl = false;
                if (!(!visited.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl = false;
                queue.offer(it);
            }
            $this$forEach$iv = OverridingMethodsSearch.search((PsiMethod)currentMethod).asIterable();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            Iterator bl = $this$filterTo$iv$iv.iterator();
            while (bl.hasNext()) {
                Object element$iv$iv = bl.next();
                PsiMethod it = (PsiMethod)element$iv$iv;
                boolean bl2 = false;
                if (!(!visited.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl3 = false;
                queue.offer(it);
            }
        }
        return parametersToDelete;
    }

    private static final void addParameter(PsiMethod method, Set<PsiElement> result2, PsiParameter parameter) {
        PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)parameter));
        Intrinsics.checkNotNull((Object)psiElement);
        int parameterIndex = KtPsiUtilKt.parameterIndex((PsiElement)psiElement);
        if (method instanceof KtLightMethod) {
            KtDeclaration declaration = (KtDeclaration)((KtLightMethod)method).getKotlinOrigin();
            if (declaration instanceof KtFunction) {
                Object e = ((KtFunction)declaration).getValueParameters().get(parameterIndex);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                result2.add((PsiElement)e);
            }
        } else {
            PsiParameter psiParameter = method.getParameterList().getParameters()[parameterIndex];
            Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"get(...)");
            result2.add((PsiElement)psiParameter);
        }
    }

    private static final Set checkParametersInMethodHierarchy$lambda$0$0(PsiMethod $method, PsiParameter $parameter) {
        return UtilsKt.collectParametersHierarchy($method, $parameter);
    }

    private static final Collection checkParametersInMethodHierarchy$lambda$0(PsiMethod $method, PsiParameter $parameter) {
        return (Collection)ActionsKt.runReadAction(() -> UtilsKt.checkParametersInMethodHierarchy$lambda$0$0($method, $parameter));
    }
}

