/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.suggested;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.suggested.KotlinSuggestedRefactoringStateChanges;
import org.jetbrains.kotlin.idea.refactoring.suggested.KotlinSuggestedRefactoringUI;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/suggested/KotlinSuggestedRefactoringSupportBase;", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "<init>", "()V", "isAnchor", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "signatureRange", "Lcom/intellij/openapi/util/TextRange;", "anchor", "importsRange", "psiFile", "Lcom/intellij/psi/PsiFile;", "nameRange", "hasSyntaxError", "isIdentifierStart", "c", "", "isIdentifierPart", "stateChanges", "Lorg/jetbrains/kotlin/idea/refactoring/suggested/KotlinSuggestedRefactoringStateChanges;", "getStateChanges", "()Lorg/jetbrains/kotlin/idea/refactoring/suggested/KotlinSuggestedRefactoringStateChanges;", "ui", "Lorg/jetbrains/kotlin/idea/refactoring/suggested/KotlinSuggestedRefactoringUI;", "getUi", "()Lorg/jetbrains/kotlin/idea/refactoring/suggested/KotlinSuggestedRefactoringUI;", "Companion", "kotlin.refactorings.common"})
public abstract class KotlinSuggestedRefactoringSupportBase
implements SuggestedRefactoringSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinSuggestedRefactoringStateChanges stateChanges = new KotlinSuggestedRefactoringStateChanges(this);

    public boolean isAnchor(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof KtDeclaration)) {
            return false;
        }
        return !(psiElement instanceof KtParameter) || ((KtParameter)psiElement).getOwnerFunction() == null;
    }

    @Nullable
    public TextRange signatureRange(@NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        PsiElement psiElement = anchor;
        if (psiElement instanceof KtPrimaryConstructor) {
            return ((KtPrimaryConstructor)anchor).getTextRange();
        }
        if (psiElement instanceof KtSecondaryConstructor) {
            KtParameterList ktParameterList = ((KtSecondaryConstructor)anchor).getValueParameterList();
            return ktParameterList != null ? ktParameterList.getTextRange() : null;
        }
        if (psiElement instanceof KtCallableDeclaration) {
            TextRange textRange;
            PsiElement psiElement2;
            int n;
            if (Companion.isOnlyRenameSupported((KtCallableDeclaration)anchor)) {
                PsiElement psiElement3 = ((KtCallableDeclaration)anchor).getNameIdentifier();
                return psiElement3 != null ? psiElement3.getTextRange() : null;
            }
            KtModifierList ktModifierList = ((KtCallableDeclaration)anchor).getModifierList();
            if (ktModifierList != null && (ktModifierList = ktModifierList.getContextParameterList()) != null && (ktModifierList = ktModifierList.getTextRange()) != null) {
                n = ktModifierList.getStartOffset();
            } else {
                KtTypeReference ktTypeReference = ((KtCallableDeclaration)anchor).getReceiverTypeReference();
                if (ktTypeReference != null && (ktTypeReference = ktTypeReference.getTextRange()) != null) {
                    n = ktTypeReference.getStartOffset();
                } else {
                    PsiElement psiElement4 = ((KtCallableDeclaration)anchor).getNameIdentifier();
                    Integer n2 = psiElement4 != null && (psiElement4 = psiElement4.getTextRange()) != null ? Integer.valueOf(psiElement4.getStartOffset()) : null;
                    if (n2 != null) {
                        n = n2;
                    } else {
                        return null;
                    }
                }
            }
            int start2 = n;
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)anchor).getTypeReference();
            if (ktTypeReference != null) {
                v8 = (PsiElement)ktTypeReference;
            } else {
                KtParameterList ktParameterList = ((KtCallableDeclaration)anchor).getValueParameterList();
                v8 = psiElement2 = ktParameterList != null ? (PsiElement)ktParameterList : ((KtCallableDeclaration)anchor).getNameIdentifier();
            }
            if (psiElement2 == null || (textRange = psiElement2.getTextRange()) == null) {
                return null;
            }
            int end = textRange.getEndOffset();
            return new TextRange(start2, end);
        }
        if (psiElement instanceof KtNamedDeclaration) {
            PsiElement psiElement5 = ((KtNamedDeclaration)anchor).getNameIdentifier();
            return psiElement5 != null ? psiElement5.getTextRange() : null;
        }
        return null;
    }

    @Nullable
    public TextRange importsRange(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        KtImportList ktImportList = ((KtFile)psiFile).getImportList();
        return ktImportList != null ? ktImportList.getTextRange() : null;
    }

    @Nullable
    public TextRange nameRange(@NotNull PsiElement anchor) {
        PsiElement identifier;
        Object object;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        PsiElement psiElement = anchor;
        if (psiElement instanceof KtPrimaryConstructor) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)anchor));
            object = ktClassOrObject != null ? ktClassOrObject.getNameIdentifier() : null;
        } else {
            object = psiElement instanceof KtSecondaryConstructor ? ((KtSecondaryConstructor)anchor).getConstructorKeyword() : (psiElement instanceof KtNamedDeclaration ? ((KtNamedDeclaration)anchor).getNameIdentifier() : null);
        }
        PsiElement psiElement2 = identifier = object;
        return psiElement2 != null ? psiElement2.getTextRange() : null;
    }

    public boolean hasSyntaxError(@NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (super.hasSyntaxError(anchor)) {
            return true;
        }
        return anchor instanceof KtProperty && ((KtProperty)anchor).isLocal() && ((KtProperty)anchor).getTypeReference() == null && ((KtProperty)anchor).getInitializer() == null;
    }

    public boolean isIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    @NotNull
    public KotlinSuggestedRefactoringStateChanges getStateChanges() {
        return this.stateChanges;
    }

    @NotNull
    public KotlinSuggestedRefactoringUI getUi() {
        return KotlinSuggestedRefactoringUI.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/suggested/KotlinSuggestedRefactoringSupportBase$Companion;", "", "<init>", "()V", "isOnlyRenameSupported", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "kotlin.refactorings.common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isOnlyRenameSupported(@NotNull KtCallableDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            return declaration instanceof KtVariableDeclaration && KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)declaration));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

