/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/run/LocalFileHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "path", "", "line", "", "column", "<init>", "(Ljava/lang/String;II)V", "getPath", "()Ljava/lang/String;", "getLine", "()I", "getColumn", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.runConfigurations.jvm"})
public final class LocalFileHyperlinkInfo
implements HyperlinkInfo {
    @NotNull
    private final String path;
    private final int line;
    private final int column;

    public LocalFileHyperlinkInfo(@NotNull String path2, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.path = path2;
        this.line = line;
        this.column = column;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public void navigate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile f = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.path));
        if (f != null) {
            new OpenFileDescriptor(project, f, this.line, this.column).navigate(true);
        }
    }
}

