/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinTodoOccurrence;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinTodoSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/search/IndexPatternOccurrence;", "Lcom/intellij/psi/search/searches/IndexPatternSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "intellij.kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nKotlinTodoSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTodoSearcher.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinTodoSearcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,53:1\n1401#2,2:54\n*S KotlinDebug\n*F\n+ 1 KotlinTodoSearcher.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinTodoSearcher\n*L\n32#1:54,2\n*E\n"})
public final class KotlinTodoSearcher
extends QueryExecutorBase<IndexPatternOccurrence, IndexPatternSearch.SearchParameters> {
    /*
     * WARNING - void declaration
     */
    public void processQuery(@NotNull IndexPatternSearch.SearchParameters queryParameters, @NotNull Processor<? super IndexPatternOccurrence> consumer) {
        int count;
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiFile psiFile = queryParameters.getFile();
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile file = ktFile2;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Ref.ObjectRef pattern2 = new Ref.ObjectRef();
        pattern2.element = queryParameters.getPattern();
        if (pattern2.element != null) {
            String string = ((IndexPattern)pattern2.element).getPatternString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPatternString(...)");
            if (!StringsKt.contains((CharSequence)string, (CharSequence)"TODO", (boolean)true)) {
                return;
            }
        }
        if (pattern2.element == null) {
            Object v5;
            block8: {
                void $this$firstOrNull$iv;
                IndexPattern[] indexPatternArray = queryParameters.getPatternProvider().getIndexPatterns();
                Intrinsics.checkNotNullExpressionValue((Object)indexPatternArray, (String)"getIndexPatterns(...)");
                Object[] objectArray = indexPatternArray;
                Ref.ObjectRef objectRef = pattern2;
                boolean $i$f$firstOrNull = false;
                for (void element$iv : $this$firstOrNull$iv) {
                    IndexPattern it = (IndexPattern)element$iv;
                    boolean bl = false;
                    String string = it.getPatternString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPatternString(...)");
                    if (!StringsKt.contains((CharSequence)string, (CharSequence)"TODO", (boolean)true)) continue;
                    v5 = element$iv;
                    break block8;
                }
                v5 = null;
            }
            IndexPattern indexPattern = v5;
            if (indexPattern == null) {
                return;
            }
            objectRef.element = indexPattern;
        }
        TodoCacheManager cacheManager = TodoCacheManager.getInstance((Project)file.getProject());
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        int n = count = patternProvider != null ? cacheManager.getTodoCount(virtualFile2, patternProvider) : cacheManager.getTodoCount(virtualFile2, (IndexPattern)pattern2.element);
        if (count == 0) {
            return;
        }
        file.accept((PsiElementVisitor)new KtTreeVisitorVoid(consumer, file, (Ref.ObjectRef<IndexPattern>)pattern2){
            final /* synthetic */ Processor<? super IndexPatternOccurrence> $consumer;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ Ref.ObjectRef<IndexPattern> $pattern;
            {
                this.$consumer = $consumer;
                this.$file = $file;
                this.$pattern = $pattern;
            }

            public void visitCallExpression(KtCallExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitCallExpression(expression);
                KtExpression ktExpression = expression.getCalleeExpression();
                if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"TODO")) {
                    PsiFile psiFile = (PsiFile)this.$file;
                    TextRange textRange = expression.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    this.$consumer.process((Object)new KotlinTodoOccurrence(psiFile, textRange, (IndexPattern)this.$pattern.element));
                }
            }
        });
    }
}

