/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.refIndex.jps;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.io.CorruptedException;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.kotlin.idea.search.refIndex.KotlinCompilerReferenceIndexStorage;
import org.jetbrains.kotlin.idea.search.refIndex.jps.JpsClassOneToManyStorage;
import org.jetbrains.kotlin.idea.search.refIndex.jps.JpsKotlinCompilerReferenceIndexStorageKt;
import org.jetbrains.kotlin.idea.search.refIndex.jps.JpsLookupStorageReader;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0005H\u0007J\u0015\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/jps/JpsKotlinCompilerReferenceIndexStorageImpl;", "Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage;", "lookupStorageReader", "Lorg/jetbrains/kotlin/idea/search/refIndex/jps/JpsLookupStorageReader;", "subtypesStorage", "Lorg/jetbrains/kotlin/idea/search/refIndex/jps/JpsClassOneToManyStorage;", "<init>", "(Lorg/jetbrains/kotlin/idea/search/refIndex/jps/JpsLookupStorageReader;Lorg/jetbrains/kotlin/idea/search/refIndex/jps/JpsClassOneToManyStorage;)V", "getUsages", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getSubtypesOf", "Lkotlin/sequences/Sequence;", "deep", "", "close", "", "visitSubtypeStorages", "buildDataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "processor", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "initializeSubtypeStorage", "destination", "initializeForTests", "initialize", "initialize$intellij_kotlin_compilerReferenceIndex", "Companion", "intellij.kotlin.compilerReferenceIndex"})
@SourceDebugExtension(value={"SMAP\nJpsKotlinCompilerReferenceIndexStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsKotlinCompilerReferenceIndexStorage.kt\norg/jetbrains/kotlin/idea/search/refIndex/jps/JpsKotlinCompilerReferenceIndexStorageImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,144:1\n1642#2,10:145\n1915#2:155\n1916#2:157\n1652#2:158\n1#3:156\n1#3:159\n29#4,3:160\n29#4,3:163\n13#5:166\n*S KotlinDebug\n*F\n+ 1 JpsKotlinCompilerReferenceIndexStorage.kt\norg/jetbrains/kotlin/idea/search/refIndex/jps/JpsKotlinCompilerReferenceIndexStorageImpl\n*L\n49#1:145,10\n49#1:155\n49#1:157\n49#1:158\n49#1:156\n80#1:160,3\n104#1:163,3\n45#1:166\n*E\n"})
public final class JpsKotlinCompilerReferenceIndexStorageImpl
implements KotlinCompilerReferenceIndexStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JpsLookupStorageReader lookupStorageReader;
    @NotNull
    private final JpsClassOneToManyStorage subtypesStorage;
    @NotNull
    private static final String SUBTYPES_STORAGE_NAME = "subtypes." + BasicMapsOwner.Companion.getCACHE_EXTENSION();
    @NotNull
    private static final ExecutorService STORAGE_INDEXING_EXECUTOR;
    @NotNull
    private static final Logger LOG;

    public JpsKotlinCompilerReferenceIndexStorageImpl(@NotNull JpsLookupStorageReader lookupStorageReader, @NotNull JpsClassOneToManyStorage subtypesStorage) {
        Intrinsics.checkNotNullParameter((Object)lookupStorageReader, (String)"lookupStorageReader");
        Intrinsics.checkNotNullParameter((Object)subtypesStorage, (String)"subtypesStorage");
        this.lookupStorageReader = lookupStorageReader;
        this.subtypesStorage = subtypesStorage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VirtualFile> getUsages(@NotNull FqName fqName2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Iterable $this$mapNotNull$iv = this.lookupStorageReader.get(fqName2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            if (VfsUtil.findFile((Path)it, (boolean)false) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Sequence<FqName> getSubtypesOf(@NotNull FqName fqName2, boolean deep) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.subtypesStorage.get(fqName2, deep);
    }

    @Override
    public void close() {
        this.lookupStorageReader.close();
        this.subtypesStorage.closeAndClean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void visitSubtypeStorages(BuildDataPaths buildDataPaths, Function1<? super Path, Unit> processor2) {
        for (JavaModuleBuildTargetType buildTargetType : JavaModuleBuildTargetType.ALL_TYPES) {
            Path buildTargetPath;
            Intrinsics.checkNotNullExpressionValue((Object)buildDataPaths.getTargetTypeDataRootDir((BuildTargetType)buildTargetType), (String)"getTargetTypeDataRootDir(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(buildTargetPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(buildTargetPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
            Path path2 = buildTargetPath;
            Closeable closeable = Files.newDirectoryStream(path2, "*");
            Throwable throwable = null;
            try {
                DirectoryStream directoryStream = (DirectoryStream)closeable;
                Intrinsics.checkNotNull((Object)directoryStream);
                Iterable iterable = directoryStream;
                for (Path targetDataRoot : iterable) {
                    Path path3;
                    Path path4;
                    Path path5;
                    boolean bl = false;
                    Path it = path5 = targetDataRoot;
                    boolean bl2 = false;
                    LinkOption[] linkOptionArray3 = new LinkOption[]{};
                    Path path6 = Files.isDirectory(it, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? path5 : null;
                    if (path6 == null || (path5 = path6.resolve("kotlin")) == null || (path4 = path5.resolve(SUBTYPES_STORAGE_NAME)) == null) continue;
                    Path it2 = path3 = path4;
                    boolean bl3 = false;
                    LinkOption[] linkOptionArray4 = new LinkOption[]{};
                    Path path7 = !Files.notExists(it2, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)) ? path3 : null;
                    if (path7 == null) continue;
                    Path workingPath = path7;
                    processor2.invoke((Object)workingPath);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    private final boolean initializeSubtypeStorage(BuildDataPaths buildDataPaths, JpsClassOneToManyStorage destination) {
        Ref.BooleanRef wasCorrupted = new Ref.BooleanRef();
        MultiMap multiMap = MultiMap.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrentSet(...)");
        MultiMap destinationMap = multiMap;
        List futures = new ArrayList();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.visitSubtypeStorages(buildDataPaths, (Function1<? super Path, Unit>)((Function1)arg_0 -> JpsKotlinCompilerReferenceIndexStorageImpl.initializeSubtypeStorage$lambda$0$0(futures, destinationMap, wasCorrupted, arg_0)));
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("KCRI initialization was interrupted");
            throw e;
        }
        long timeOfFilling = System.currentTimeMillis() - start$iv;
        if (wasCorrupted.element) {
            return false;
        }
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv2 = System.currentTimeMillis();
        boolean bl2 = false;
        for (Map.Entry entry : destinationMap.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String key = (String)entry.getKey();
            Collection values2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)key);
            Intrinsics.checkNotNull((Object)values2);
            destination.put(key, values2);
        }
        long timeOfFlush = System.currentTimeMillis() - start$iv2;
        LOG.info("KCRI storage is opened: took " + (timeOfFilling + timeOfFlush) + " ms for " + futures.size() + " storages (filling map: " + timeOfFilling + " ms, flush to storage: " + timeOfFlush + " ms)");
        return true;
    }

    @TestOnly
    public final boolean initializeForTests(@NotNull BuildDataPaths buildDataPaths, @NotNull JpsClassOneToManyStorage destination) {
        Intrinsics.checkNotNullParameter((Object)buildDataPaths, (String)"buildDataPaths");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.initializeSubtypeStorage(buildDataPaths, destination);
    }

    public final boolean initialize$intellij_kotlin_compilerReferenceIndex(@NotNull BuildDataPaths buildDataPaths) {
        Intrinsics.checkNotNullParameter((Object)buildDataPaths, (String)"buildDataPaths");
        return this.initializeSubtypeStorage(buildDataPaths, this.subtypesStorage);
    }

    private static final void initializeSubtypeStorage$lambda$0$0$0(MultiMap $destinationMap, Path $storagePath, Ref.BooleanRef $wasCorrupted) {
        try {
            JpsKotlinCompilerReferenceIndexStorageKt.access$initializeStorage($destinationMap, $storagePath);
        }
        catch (CorruptedException e) {
            $wasCorrupted.element = true;
            LOG.warn("KCRI storage was corrupted", (Throwable)e);
        }
    }

    private static final Unit initializeSubtypeStorage$lambda$0$0(List $futures, MultiMap $destinationMap, Ref.BooleanRef $wasCorrupted, Path storagePath) {
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        ((Collection)$futures).add(STORAGE_INDEXING_EXECUTOR.submit(() -> JpsKotlinCompilerReferenceIndexStorageImpl.initializeSubtypeStorage$lambda$0$0$0($destinationMap, storagePath, $wasCorrupted)));
        return Unit.INSTANCE;
    }

    static {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Kotlin compiler references indexing", (int)UnindexedFilesUpdater.getMaxNumberOfIndexingThreads());
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        STORAGE_INDEXING_EXECUTOR = executorService;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JpsKotlinCompilerReferenceIndexStorageImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/jps/JpsKotlinCompilerReferenceIndexStorageImpl$Companion;", "", "<init>", "()V", "SUBTYPES_STORAGE_NAME", "", "getSUBTYPES_STORAGE_NAME$intellij_kotlin_compilerReferenceIndex", "()Ljava/lang/String;", "STORAGE_INDEXING_EXECUTOR", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.compilerReferenceIndex"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSUBTYPES_STORAGE_NAME$intellij_kotlin_compilerReferenceIndex() {
            return SUBTYPES_STORAGE_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

