/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0018\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0007J\u0010\u0010\u001a\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0018\u0010\u001b\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinCodeVisionUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "CLASS_LOCATION", "", "INTERFACE_LOCATION", "FUNCTION_LOCATION", "PROPERTY_LOCATION", "GROUP", "LOCATION_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "USAGES_CLICKED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "INHERITORS_CLICKED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "SETTINGS_CLICKED_EVENT", "CODE_AUTHOR_CLICKED_EVENT", "logUsagesClicked", "", "project", "Lcom/intellij/openapi/project/Project;", "logInheritorsClicked", "location", "logSettingsClicked", "logCodeAuthorClicked", "intellij.kotlin.base.statistics"})
public final class KotlinCodeVisionUsagesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final KotlinCodeVisionUsagesCollector INSTANCE = new KotlinCodeVisionUsagesCollector();
    @NotNull
    public static final String CLASS_LOCATION = "class";
    @NotNull
    public static final String INTERFACE_LOCATION = "interface";
    @NotNull
    public static final String FUNCTION_LOCATION = "function";
    @NotNull
    public static final String PROPERTY_LOCATION = "property";
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("kotlin.code.vision", 2, null, 4, null);
    @NotNull
    private static final StringEventField LOCATION_FIELD;
    @NotNull
    private static final EventId USAGES_CLICKED_EVENT;
    @NotNull
    private static final EventId1<String> INHERITORS_CLICKED_EVENT;
    @NotNull
    private static final EventId SETTINGS_CLICKED_EVENT;
    @NotNull
    private static final EventId1<String> CODE_AUTHOR_CLICKED_EVENT;

    private KotlinCodeVisionUsagesCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void logUsagesClicked(@Nullable Project project) {
        USAGES_CLICKED_EVENT.log(project);
    }

    public final void logInheritorsClicked(@Nullable Project project, @NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        INHERITORS_CLICKED_EVENT.log(project, (Object)location);
    }

    public final void logSettingsClicked(@Nullable Project project) {
        SETTINGS_CLICKED_EVENT.log(project);
    }

    public final void logCodeAuthorClicked(@Nullable Project project, @NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CODE_AUTHOR_CLICKED_EVENT.log(project, (Object)location);
    }

    static {
        Object[] objectArray = new String[]{CLASS_LOCATION, INTERFACE_LOCATION, FUNCTION_LOCATION, PROPERTY_LOCATION};
        LOCATION_FIELD = EventFields.String((String)"location", (List)CollectionsKt.listOf((Object[])objectArray));
        USAGES_CLICKED_EVENT = GROUP.registerEvent("usages.clicked");
        INHERITORS_CLICKED_EVENT = GROUP.registerEvent("inheritors.clicked", (EventField)LOCATION_FIELD);
        SETTINGS_CLICKED_EVENT = GROUP.registerEvent("setting.clicked");
        CODE_AUTHOR_CLICKED_EVENT = GROUP.registerEvent("code.author.clicked", (EventField)LOCATION_FIELD);
    }
}

