/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.statistics.KotlinProjectOpenEvent;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\f\u0010\u001e\u001a\u00020\u0015*\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinProjectOpenerCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "utmSourceList", "", "", "utmMediumList", "UTM_SOURCE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "UTM_MEDIUM", "UTM_CAMPAIGN", "PROJECT_OPENED_FROM_WEBSITE", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "requiresReadAccess", "", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getReceiptFile", "Ljava/nio/file/Path;", "readReceiptFile", "Lorg/jetbrains/kotlin/idea/statistics/KotlinProjectOpenEvent;", "receiptPath", "readAndDeserializeJson", "toMetricEvent", "intellij.kotlin.base.statistics"})
@SourceDebugExtension(value={"SMAP\nKotlinProjectOpenerCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectOpenerCollector.kt\norg/jetbrains/kotlin/idea/statistics/KotlinProjectOpenerCollector\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,120:1\n222#2:121\n*S KotlinDebug\n*F\n+ 1 KotlinProjectOpenerCollector.kt\norg/jetbrains/kotlin/idea/statistics/KotlinProjectOpenerCollector\n*L\n87#1:121\n*E\n"})
public final class KotlinProjectOpenerCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kotlin.project.opener", 1, null, 4, null);
    @NotNull
    private final List<String> utmSourceList;
    @NotNull
    private final List<String> utmMediumList;
    @NotNull
    private final StringEventField UTM_SOURCE;
    @NotNull
    private final StringEventField UTM_MEDIUM;
    @NotNull
    private final StringEventField UTM_CAMPAIGN;
    @NotNull
    private final EventId3<String, String, String> PROJECT_OPENED_FROM_WEBSITE;

    public KotlinProjectOpenerCollector() {
        Object[] objectArray = new String[]{"google", "twitter", "facebook", "linkedin", "instagram", "youtube.com", "newsletter", "reddit", "kotlinlang.org", "jetbrains.com", "other"};
        this.utmSourceList = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"social", "referral", "cpc", "email", "banner", "conference", "organic", "integration", "sticky_banner", "other"};
        this.utmMediumList = CollectionsKt.listOf((Object[])objectArray);
        this.UTM_SOURCE = EventFields.String((String)"utm_source", this.utmSourceList);
        this.UTM_MEDIUM = EventFields.String((String)"utm_medium", this.utmMediumList);
        this.UTM_CAMPAIGN = EventFields.StringValidatedByInlineRegexp((String)"utm_campaign", (String)"ktor3-wave2|organic|other|c-(\\d)+");
        this.PROJECT_OPENED_FROM_WEBSITE = this.GROUP.registerEvent("project.opened.from.website", (EventField)this.UTM_SOURCE, (EventField)this.UTM_MEDIUM, (EventField)this.UTM_CAMPAIGN);
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path2 = this.getReceiptFile(project);
        if (path2 == null) {
            return SetsKt.emptySet();
        }
        Path receiptFile = path2;
        KotlinProjectOpenEvent kotlinProjectOpenEvent = this.readReceiptFile(receiptFile);
        if (kotlinProjectOpenEvent == null) {
            return SetsKt.emptySet();
        }
        KotlinProjectOpenEvent wizardReceipt = kotlinProjectOpenEvent;
        return SetsKt.setOf((Object)this.toMetricEvent(wizardReceipt));
    }

    private final Path getReceiptFile(Project project) {
        IComponentStore iComponentStore = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)project));
        IProjectStore projectStore = iComponentStore instanceof IProjectStore ? (IProjectStore)iComponentStore : null;
        Object object = projectStore;
        if (object == null || (object = object.getDirectoryStorePath()) == null) {
            return null;
        }
        Object projectFileDir = object;
        return projectFileDir.resolve("receipt.json");
    }

    private final KotlinProjectOpenEvent readReceiptFile(Path receiptPath) {
        Object object;
        Object object2 = this;
        try {
            KotlinProjectOpenerCollector $this$readReceiptFile_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$readReceiptFile_u24lambda_u240.readAndDeserializeJson(receiptPath));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (KotlinProjectOpenEvent)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinProjectOpenEvent readAndDeserializeJson(Path receiptPath) {
        void this_$iv;
        Json json;
        String text = PathsKt.readText$default((Path)receiptPath, null, (int)1, null);
        Json json2 = json = JsonKt.Json$default(null, KotlinProjectOpenerCollector::readAndDeserializeJson$lambda$0, (int)1, null);
        String string$iv = text;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        KotlinProjectOpenEvent event = (KotlinProjectOpenEvent)this_$iv.decodeFromString((DeserializationStrategy)KotlinProjectOpenEvent.Companion.serializer(), string$iv);
        Files.deleteIfExists(receiptPath);
        return event;
    }

    private final MetricEvent toMetricEvent(KotlinProjectOpenEvent $this$toMetricEvent) {
        KotlinProjectOpenEvent.Parameters parameters2 = $this$toMetricEvent.getSpec().getParameters();
        String utmSource = parameters2.component1();
        String utmMedium = parameters2.component2();
        String utmCampaign = parameters2.component3();
        return this.PROJECT_OPENED_FROM_WEBSITE.metric((Object)utmSource, (Object)utmMedium, (Object)utmCampaign);
    }

    private static final Unit readAndDeserializeJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }
}

