/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structureView;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.structureView.KotlinStructureViewUtilKt;
import org.jetbrains.kotlin.idea.structureView.KotlinVisibilitySorter;
import org.jetbrains.kotlin.idea.structureView.PropertiesFilter;
import org.jetbrains.kotlin.idea.structureView.PublicElementsFilter;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/structureView/KotlinStructureViewModel;", "Lcom/intellij/ide/structureView/StructureViewModelBase;", "Lcom/intellij/ide/structureView/StructureViewModel$ElementInfoProvider;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rootElement", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ide/structureView/StructureViewTreeElement;)V", "isSuitable", "", "element", "Lcom/intellij/psi/PsiElement;", "getFilters", "", "Lcom/intellij/ide/util/treeView/smartTree/Filter;", "()[Lcom/intellij/ide/util/treeView/smartTree/Filter;", "isAlwaysShowsPlus", "isAlwaysLeaf", "Companion", "intellij.kotlin.codeInsight.shared"})
public class KotlinStructureViewModel
extends StructureViewModelBase
implements StructureViewModel.ElementInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Filter[] FILTERS;

    public KotlinStructureViewModel(@NotNull KtFile ktFile2, @Nullable Editor editor, @NotNull StructureViewTreeElement rootElement) {
        Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        super((PsiFile)ktFile2, editor, rootElement);
        Sorter[] sorterArray = new Sorter[]{KotlinVisibilitySorter.INSTANCE, Sorter.ALPHA_SORTER};
        this.withSorters(sorterArray);
    }

    protected boolean isSuitable(@Nullable PsiElement element) {
        return KotlinStructureViewUtilKt.isStructureViewNode((PsiElement)element);
    }

    @NotNull
    public Filter[] getFilters() {
        return FILTERS;
    }

    public boolean isAlwaysShowsPlus(@NotNull StructureViewTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object value = element.getValue();
        return value instanceof KtClassOrObject && !(value instanceof KtEnumEntry) || value instanceof KtFile;
    }

    public boolean isAlwaysLeaf(@NotNull StructureViewTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return false;
    }

    static {
        Filter[] filterArray = new Filter[]{PropertiesFilter.INSTANCE, PublicElementsFilter.INSTANCE};
        FILTERS = filterArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/structureView/KotlinStructureViewModel$Companion;", "", "<init>", "()V", "FILTERS", "", "Lcom/intellij/ide/util/treeView/smartTree/Filter;", "[Lcom/intellij/ide/util/treeView/smartTree/Filter;", "intellij.kotlin.codeInsight.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

