/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubElement;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.stubindex.KotlinExtensionsByReceiverTypeStubIndexHelper;
import org.jetbrains.kotlin.idea.stubindex.KotlinExtensionsInObjectsByReceiverTypeIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinJvmNameAnnotationIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinOverridableInternalMembersShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelExtensionsByReceiverTypeIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTypeAliasByExpansionShortNameIndex;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIntersectionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinCallableStubBase;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyAccessorStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeAliasStub;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\b\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a,\u0010\t\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\n2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a0\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00010\u0014H\u0002\u001a\u001a\u0010\u0016\u001a\u00020\u00012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\"\u001a\u00020#\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0005\"\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u0015*\u0006\u0012\u0002\b\u00030\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u0006\u0012\u0002\b\u00030\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"indexTopLevelExtension", "", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinCallableStubBase;", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "indexExtensionInObject", "indexExtension", "Lorg/jetbrains/kotlin/idea/stubindex/KotlinExtensionsByReceiverTypeStubIndexHelper;", "indexTypeAliasExpansion", "Lorg/jetbrains/kotlin/psi/stubs/KotlinTypeAliasStub;", "index", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "containingTypeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "occurrence", "Lkotlin/Function1;", "", "indexInternals", "indexJvmNameAnnotation", "Lorg/jetbrains/kotlin/psi/stubs/KotlinAnnotationEntryStub;", "annotatedJvmNameElementName", "Lcom/intellij/psi/stubs/StubElement;", "getAnnotatedJvmNameElementName", "(Lcom/intellij/psi/stubs/StubElement;)Ljava/lang/String;", "modifierList", "Lorg/jetbrains/kotlin/psi/stubs/KotlinModifierListStub;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinStubWithFqName;", "getModifierList", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinStubWithFqName;)Lorg/jetbrains/kotlin/psi/stubs/KotlinModifierListStub;", "isDeclaredInObject", "", "kotlin.core"})
@SourceDebugExtension(value={"SMAP\nIndexUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexUtils.kt\norg/jetbrains/kotlin/idea/stubindex/IndexUtilsKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n137#2:153\n296#3,2:154\n1915#3,2:156\n*S KotlinDebug\n*F\n+ 1 IndexUtils.kt\norg/jetbrains/kotlin/idea/stubindex/IndexUtilsKt\n*L\n139#1:153\n70#1:154,2\n83#1:156,2\n*E\n"})
public final class IndexUtilsKt {
    public static final <TDeclaration extends KtCallableDeclaration> void indexTopLevelExtension(@NotNull KotlinCallableStubBase<TDeclaration> stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        IndexUtilsKt.indexExtension(KotlinTopLevelExtensionsByReceiverTypeIndex.Helper, stub, sink);
    }

    public static final <TDeclaration extends KtCallableDeclaration> void indexExtensionInObject(@NotNull KotlinCallableStubBase<TDeclaration> stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        IndexUtilsKt.indexExtension(KotlinExtensionsInObjectsByReceiverTypeIndex.Helper, stub, sink);
    }

    private static final <TDeclaration extends KtCallableDeclaration> void indexExtension(KotlinExtensionsByReceiverTypeStubIndexHelper $this$indexExtension, KotlinCallableStubBase<TDeclaration> stub, IndexSink sink) {
        block2: {
            if (!stub.isExtension()) {
                return;
            }
            KtCallableDeclaration declaration = (KtCallableDeclaration)stub.getPsi();
            String string = declaration.getName();
            if (string == null) {
                return;
            }
            String callableName = string;
            KtTypeReference ktTypeReference = declaration.getReceiverTypeReference();
            Intrinsics.checkNotNull((Object)ktTypeReference);
            KtTypeReference containingTypeReference = ktTypeReference;
            KtTypeElement ktTypeElement = containingTypeReference.getTypeElement();
            if (ktTypeElement == null) break block2;
            Intrinsics.checkNotNull((Object)declaration);
            IndexUtilsKt.index(ktTypeElement, (KtTypeParameterListOwner)declaration, containingTypeReference, (Function1<? super String, Unit>)((Function1)arg_0 -> IndexUtilsKt.indexExtension$lambda$0(callableName, sink, $this$indexExtension, arg_0)));
        }
    }

    public static final void indexTypeAliasExpansion(@NotNull KotlinTypeAliasStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        KtTypeAlias declaration = (KtTypeAlias)stub.getPsi();
        KtTypeReference ktTypeReference = declaration.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        if (ktTypeElement == null) {
            return;
        }
        KtTypeElement typeElement2 = ktTypeElement;
        Intrinsics.checkNotNull((Object)declaration);
        IndexUtilsKt.index(typeElement2, (KtTypeParameterListOwner)declaration, typeReference, (Function1<? super String, Unit>)((Function1)arg_0 -> IndexUtilsKt.indexTypeAliasExpansion$lambda$0(sink, arg_0)));
    }

    private static final void index(KtTypeElement $this$index, KtTypeParameterListOwner declaration, KtTypeReference containingTypeReference, Function1<? super String, Unit> occurrence) {
        IndexUtilsKt.index$indexWithVisited($this$index, declaration, containingTypeReference, new LinkedHashSet(), occurrence);
    }

    public static final void indexInternals(@NotNull KotlinCallableStubBase<?> stub, @NotNull IndexSink sink) {
        block8: {
            String name2;
            block7: {
                Intrinsics.checkNotNullParameter(stub, (String)"stub");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                String string = stub.getName();
                if (string == null) {
                    return;
                }
                name2 = string;
                KotlinModifierListStub kotlinModifierListStub = IndexUtilsKt.getModifierList((KotlinStubWithFqName)stub);
                if (kotlinModifierListStub == null) {
                    return;
                }
                KotlinModifierListStub modifierListStub = kotlinModifierListStub;
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"INTERNAL_KEYWORD");
                if (!modifierListStub.hasModifier(ktModifierKeywordToken)) {
                    return;
                }
                if (stub.isTopLevel()) {
                    return;
                }
                KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"OPEN_KEYWORD");
                if (modifierListStub.hasModifier(ktModifierKeywordToken2)) break block7;
                KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.ABSTRACT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken3, (String)"ABSTRACT_KEYWORD");
                if (!modifierListStub.hasModifier(ktModifierKeywordToken3)) break block8;
            }
            sink.occurrence(KotlinOverridableInternalMembersShortNameIndex.Helper.getIndexKey(), (Object)name2);
        }
    }

    public static final void indexJvmNameAnnotation(@NotNull KotlinAnnotationEntryStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!Intrinsics.areEqual((Object)stub.getShortName(), (Object)JvmFileClassUtil.INSTANCE.getJVM_NAME_SHORT())) {
            return;
        }
        PsiElement psiElement = stub.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        String string = JvmFileClassUtil.INSTANCE.getLiteralStringFromAnnotation((KtAnnotationEntry)psiElement);
        if (string == null) {
            return;
        }
        String jvmName = string;
        StubElement stubElement = stub.getParentStub().getParentStub();
        Intrinsics.checkNotNullExpressionValue((Object)stubElement, (String)"getParentStub(...)");
        String string2 = IndexUtilsKt.getAnnotatedJvmNameElementName(stubElement);
        if (string2 == null) {
            return;
        }
        String annotatedElementName = string2;
        if (!Intrinsics.areEqual((Object)annotatedElementName, (Object)jvmName)) {
            sink.occurrence(KotlinJvmNameAnnotationIndex.Helper.getIndexKey(), (Object)jvmName);
        }
    }

    private static final String getAnnotatedJvmNameElementName(StubElement<?> $this$annotatedJvmNameElementName) {
        String string;
        StubElement<?> stubElement = $this$annotatedJvmNameElementName;
        if (stubElement instanceof KotlinFileStub) {
            string = ((KtFile)((KotlinFileStub)$this$annotatedJvmNameElementName).getPsi()).getName();
        } else if (stubElement instanceof NamedStub) {
            string = ((NamedStub)$this$annotatedJvmNameElementName).getName();
            if (string == null) {
                string = "";
            }
        } else if (stubElement instanceof KotlinPropertyAccessorStub) {
            StubElement $this$safeAs$iv = ((KotlinPropertyAccessorStub)$this$annotatedJvmNameElementName).getParentStub();
            boolean $i$f$safeAs = false;
            StubElement stubElement2 = $this$safeAs$iv;
            if (!(stubElement2 instanceof KotlinPropertyStub)) {
                stubElement2 = null;
            }
            if ((string = (KotlinPropertyStub)stubElement2) == null || (string = string.getName()) == null) {
                string = "";
            }
        } else if (stubElement instanceof KotlinPlaceHolderStub) {
            StubElement stubElement3 = ((KotlinPlaceHolderStub)$this$annotatedJvmNameElementName).getParentStub();
            string = stubElement3 != null ? IndexUtilsKt.getAnnotatedJvmNameElementName(stubElement3) : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final KotlinModifierListStub getModifierList(KotlinStubWithFqName<?> $this$modifierList) {
        StubElement stubElement = $this$modifierList.findChildStubByElementType(KtNodeTypes.MODIFIER_LIST);
        return stubElement instanceof KotlinModifierListStub ? (KotlinModifierListStub)stubElement : null;
    }

    public static final <TDeclaration extends KtCallableDeclaration> boolean isDeclaredInObject(@NotNull KotlinCallableStubBase<TDeclaration> $this$isDeclaredInObject) {
        Intrinsics.checkNotNullParameter($this$isDeclaredInObject, (String)"<this>");
        if ($this$isDeclaredInObject.isTopLevel()) {
            return false;
        }
        StubElement stubElement = $this$isDeclaredInObject.getParentStub();
        PsiElement containingDeclaration = stubElement != null && (stubElement = stubElement.getParentStub()) != null ? stubElement.getPsi() : null;
        return containingDeclaration instanceof KtObjectDeclaration && !((KtObjectDeclaration)containingDeclaration).isObjectLiteral();
    }

    private static final Unit indexExtension$lambda$0(String $callableName, IndexSink $sink, KotlinExtensionsByReceiverTypeStubIndexHelper $this_indexExtension, String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        KotlinExtensionsByReceiverTypeStubIndexHelper.Companion.Key key = new KotlinExtensionsByReceiverTypeStubIndexHelper.Companion.Key(typeName, $callableName);
        $sink.occurrence($this_indexExtension.getIndexKey(), (Object)key.getKey());
        return Unit.INSTANCE;
    }

    private static final Unit indexTypeAliasExpansion$lambda$0(IndexSink $sink, String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        $sink.occurrence(KotlinTypeAliasByExpansionShortNameIndex.Helper.getIndexKey(), (Object)typeName);
        return Unit.INSTANCE;
    }

    private static final void index$indexWithVisited(KtTypeElement $this$index_u24indexWithVisited, KtTypeParameterListOwner declaration, KtTypeReference containingTypeReference, Set<KtTypeElement> visited, Function1<? super String, Unit> occurrence) {
        if (visited.contains($this$index_u24indexWithVisited)) {
            return;
        }
        visited.add($this$index_u24indexWithVisited);
        KtTypeElement ktTypeElement = $this$index_u24indexWithVisited;
        if (ktTypeElement instanceof KtUserType) {
            Object v2;
            Object it;
            String referenceName;
            block20: {
                String string = ((KtUserType)$this$index_u24indexWithVisited).getReferencedName();
                if (string == null) {
                    return;
                }
                referenceName = string;
                List list2 = declaration.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (KtTypeParameter)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)referenceName)) continue;
                    v2 = element$iv;
                    break block20;
                }
                v2 = null;
            }
            KtTypeParameter typeParameter = v2;
            if (typeParameter != null) {
                KtTypeReference bound2 = typeParameter.getExtendsBound();
                if (bound2 != null) {
                    KtTypeElement ktTypeElement2 = bound2.getTypeElement();
                    if (ktTypeElement2 != null) {
                        IndexUtilsKt.index$indexWithVisited(ktTypeElement2, declaration, containingTypeReference, visited, occurrence);
                    }
                } else {
                    occurrence.invoke((Object)"Any");
                }
                return;
            }
            occurrence.invoke((Object)referenceName);
            Iterable $this$forEach$iv = KotlinPsiHeuristics.unwrapImportAlias((KtUserType)$this$index_u24indexWithVisited, referenceName);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                occurrence.invoke(it);
            }
        } else if (ktTypeElement instanceof KtNullableType) {
            KtTypeElement ktTypeElement3 = ((KtNullableType)$this$index_u24indexWithVisited).getInnerType();
            if (ktTypeElement3 != null) {
                IndexUtilsKt.index$indexWithVisited(ktTypeElement3, declaration, containingTypeReference, visited, occurrence);
            }
        } else if (ktTypeElement instanceof KtFunctionType) {
            int arity = ((KtFunctionType)$this$index_u24indexWithVisited).getParameters().size() + (((KtFunctionType)$this$index_u24indexWithVisited).getReceiverTypeReference() != null ? 1 : 0);
            KtModifierList ktModifierList = containingTypeReference.getModifierList();
            String suspendPrefix = (ktModifierList != null ? ktModifierList.hasModifier(KtTokens.SUSPEND_KEYWORD) : false) ? "Suspend" : "";
            occurrence.invoke((Object)(suspendPrefix + "Function" + arity));
        } else if (ktTypeElement instanceof KtDynamicType) {
            occurrence.invoke((Object)"Any");
        } else if (ktTypeElement instanceof KtIntersectionType) {
            KtTypeReference ktTypeReference = ((KtIntersectionType)$this$index_u24indexWithVisited).getLeftTypeRef();
            if (ktTypeReference != null && (ktTypeReference = ktTypeReference.getTypeElement()) != null) {
                IndexUtilsKt.index$indexWithVisited((KtTypeElement)ktTypeReference, declaration, containingTypeReference, visited, occurrence);
            }
        } else {
            throw new IllegalStateException(("Unsupported type: " + $this$index_u24indexWithVisited).toString());
        }
    }
}

