/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex.resolve;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.idea.base.indices.KotlinPackageIndexUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfoUtils;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListener;
import org.jetbrains.kotlin.idea.stubindex.resolve.InconsistencyIndexException;
import org.jetbrains.kotlin.idea.stubindex.resolve.StubBasedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010\nH\u0016J\u0006\u0010(\u001a\u00020!J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0018H\u0002J\b\u0010+\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/resolve/PluginDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractDeclarationProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "indexedFilesScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "nonIndexedFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/kotlin/storage/StorageManager;Ljava/util/Collection;Lorg/jetbrains/kotlin/analyzer/ModuleInfo;)V", "fileBasedDeclarationProviderFactory", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "getClassMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/ClassMemberDeclarationProvider;", "classLikeInfo", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassLikeInfo;", "createPackageMemberDeclarationProvider", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "name", "Lorg/jetbrains/kotlin/name/FqName;", "packageExists", "", "fqName", "stubBasedPackageExists", "getStubBasedPackageMemberDeclarationProvider", "diagnoseMissingPackageFragmentPartialPackageIndexCorruption", "", "message", "", "diagnoseMissingPackageFragmentPerModulePackageCacheMiss", "diagnoseMissingPackageFragmentUnknownReason", "diagnoseMissingPackageFragment", "", "file", "onCreationDebugInfo", "debugToString", "oldPackageExists", "packageFqName", "debugInfo", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nPluginDeclarationProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginDeclarationProviderFactory.kt\norg/jetbrains/kotlin/idea/stubindex/resolve/PluginDeclarationProviderFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,160:1\n1807#2,3:161\n1915#2,2:167\n1#3:164\n30#4,2:165\n*S KotlinDebug\n*F\n+ 1 PluginDeclarationProviderFactory.kt\norg/jetbrains/kotlin/idea/stubindex/resolve/PluginDeclarationProviderFactory\n*L\n56#1:161,3\n150#1:167,2\n90#1:165,2\n*E\n"})
public final class PluginDeclarationProviderFactory
extends AbstractDeclarationProviderFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope indexedFilesScope;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final Collection<KtFile> nonIndexedFiles;
    @NotNull
    private final ModuleInfo moduleInfo;
    @NotNull
    private final FileBasedDeclarationProviderFactory fileBasedDeclarationProviderFactory;
    @NotNull
    private final String onCreationDebugInfo;

    public PluginDeclarationProviderFactory(@NotNull Project project, @NotNull GlobalSearchScope indexedFilesScope, @NotNull StorageManager storageManager, @NotNull Collection<? extends KtFile> nonIndexedFiles, @NotNull ModuleInfo moduleInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indexedFilesScope, (String)"indexedFilesScope");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(nonIndexedFiles, (String)"nonIndexedFiles");
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        super(storageManager);
        this.project = project;
        this.indexedFilesScope = indexedFilesScope;
        this.storageManager = storageManager;
        this.nonIndexedFiles = nonIndexedFiles;
        this.moduleInfo = moduleInfo;
        this.fileBasedDeclarationProviderFactory = new FileBasedDeclarationProviderFactory(this.storageManager, this.nonIndexedFiles);
        this.onCreationDebugInfo = this.debugInfo();
    }

    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull KtClassLikeInfo classLikeInfo) {
        Intrinsics.checkNotNullParameter((Object)classLikeInfo, (String)"classLikeInfo");
        return (ClassMemberDeclarationProvider)new PsiBasedClassMemberDeclarationProvider(this.storageManager, classLikeInfo);
    }

    @ApiStatus.Internal
    @Nullable
    public PackageMemberDeclarationProvider createPackageMemberDeclarationProvider(@NotNull FqName name2) {
        PackageMemberDeclarationProvider packageMemberDeclarationProvider;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        PackageMemberDeclarationProvider fileBasedProvider = this.fileBasedDeclarationProviderFactory.getPackageMemberDeclarationProvider(name2);
        PackageMemberDeclarationProvider stubBasedProvider = this.getStubBasedPackageMemberDeclarationProvider(name2);
        if (fileBasedProvider == null && stubBasedProvider == null) {
            packageMemberDeclarationProvider = null;
        } else if (fileBasedProvider == null) {
            packageMemberDeclarationProvider = stubBasedProvider;
        } else if (stubBasedProvider == null) {
            packageMemberDeclarationProvider = fileBasedProvider;
        } else {
            Object[] objectArray = new PackageMemberDeclarationProvider[]{stubBasedProvider, fileBasedProvider};
            packageMemberDeclarationProvider = (PackageMemberDeclarationProvider)new CombinedPackageMemberDeclarationProvider((Collection)CollectionsKt.listOf((Object[])objectArray));
        }
        return packageMemberDeclarationProvider;
    }

    public boolean packageExists(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.fileBasedDeclarationProviderFactory.packageExists(fqName2) || this.stubBasedPackageExists(fqName2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean stubBasedPackageExists(FqName name2) {
        boolean bl;
        block5: {
            IdeaModuleInfo ideaModuleInfo;
            Object object = this.moduleInfo;
            IdeaModuleInfo ideaModuleInfo2 = ideaModuleInfo = object instanceof IdeaModuleInfo ? (IdeaModuleInfo)object : null;
            if (ideaModuleInfo != null && (object = IdeaModuleInfoUtils.projectSourceModules(ideaModuleInfo)) != null) {
                void $this$any$iv;
                Iterable iterable = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ModuleSourceInfo it = (ModuleSourceInfo)element$iv;
                        boolean bl2 = false;
                        if (!PerModulePackageCacheService.Companion.getInstance(this.project).packageExists(name2, it)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final PackageMemberDeclarationProvider getStubBasedPackageMemberDeclarationProvider(FqName name2) {
        if (!this.stubBasedPackageExists(name2)) {
            return null;
        }
        return new StubBasedPackageMemberDeclarationProvider(name2, this.project, this.indexedFilesScope);
    }

    private final Void diagnoseMissingPackageFragmentPartialPackageIndexCorruption(String message2) {
        PerModulePackageCacheService.Companion.getInstance(this.project).onTooComplexChange();
        throw new InconsistencyIndexException("KotlinPartialPackageNamesIndex inconsistency.\n" + message2);
    }

    private final Void diagnoseMissingPackageFragmentPerModulePackageCacheMiss(String message2) {
        PerModulePackageCacheService.Companion.getInstance(this.project).onTooComplexChange();
        throw new InconsistencyIndexException("PerModulePackageCache miss.\n" + message2);
    }

    private final Void diagnoseMissingPackageFragmentUnknownReason(String message2) {
        throw new IllegalStateException(message2);
    }

    public void diagnoseMissingPackageFragment(@NotNull FqName fqName2, @Nullable KtFile file) {
        String string;
        Boolean bl;
        ModuleInfo moduleInfo;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        if (file != null) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (DumbService.Companion.isDumb(project) && FileBasedIndex.getInstance().getCurrentDumbModeAccessType(file.getProject()) != null) {
                IndexNotReadyException indexNotReadyException = IndexNotReadyException.create();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)indexNotReadyException), (String)"create(...)");
                throw (Throwable)indexNotReadyException;
            }
        }
        ModuleSourceInfo moduleSourceInfo = (moduleInfo = this.moduleInfo) instanceof ModuleSourceInfo ? (ModuleSourceInfo)moduleInfo : null;
        boolean packageExists = KotlinPackageIndexUtils.INSTANCE.packageExists(fqName2, this.indexedFilesScope);
        boolean spiPackageExists = KotlinPackageIndexUtils.INSTANCE.packageExists(fqName2, this.project);
        boolean oldPackageExists = this.oldPackageExists(fqName2);
        ModuleSourceInfo moduleSourceInfo2 = moduleSourceInfo;
        if (moduleSourceInfo2 != null) {
            ModuleSourceInfo it = moduleSourceInfo2;
            boolean bl2 = false;
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<PerModulePackageCacheService> serviceClass$iv = PerModulePackageCacheService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            bl = ((PerModulePackageCacheService)object).packageExists(fqName2, it);
        } else {
            bl = null;
        }
        Boolean cachedPackageExists = bl;
        ModuleSourceInfo moduleSourceInfo3 = moduleSourceInfo;
        Long moduleModificationCount = moduleSourceInfo3 != null && (moduleSourceInfo3 = moduleSourceInfo3.createModificationTracker()) != null ? Long.valueOf(moduleSourceInfo3.getModificationCount()) : null;
        String common = StringsKt.trimIndent((String)("\n                packageExists = " + packageExists + ", cachedPackageExists = " + cachedPackageExists + ",\n                oldPackageExists = " + oldPackageExists + ",\n                SPI.packageExists = " + spiPackageExists + ",\n                OOCB count = " + KotlinCodeBlockModificationListener.Companion.getInstance(this.project).getKotlinOutOfCodeBlockTracker().getModificationCount() + "\n                moduleModificationCount = " + moduleModificationCount + "\n            "));
        if (file != null) {
            VirtualFile virtualFile = file.getVirtualFile();
            boolean inScope = this.indexedFilesScope.contains(virtualFile);
            FqName packageFqName = file.getPackageFqName();
            KtPackageDirective ktPackageDirective = file.getPackageDirective();
            string = StringsKt.trimMargin$default((String)("\n                |Cannot find package fragment '" + fqName2 + "' for file " + file.getName() + ", file package = '" + packageFqName + "':\n                |vFile: " + virtualFile + ",\n                |nonIndexedFiles = " + this.nonIndexedFiles + ", isNonIndexed = " + this.nonIndexedFiles.contains(file) + ",\n                |scope = " + this.indexedFilesScope + ", isInScope = " + inScope + ",\n                |" + common + ",\n                |packageFqNameByTree = '" + file.getPackageFqNameByTree() + "', packageDirectiveText = '" + (ktPackageDirective != null ? ktPackageDirective.getText() : null) + "'\n            "), null, (int)1, null);
        } else {
            string = StringsKt.trimMargin$default((String)("\n                |Cannot find package fragment '" + fqName2 + "' for unspecified file:\n                |nonIndexedFiles = " + this.nonIndexedFiles + ",\n                |scope = " + this.indexedFilesScope + ",\n                |" + common + "\n            "), null, (int)1, null);
        }
        String message2 = string;
        boolean scopeNotEmptyAndContainsFile = !GlobalSearchScope.isEmptyScope((SearchScope)((SearchScope)this.indexedFilesScope)) && (file == null || this.indexedFilesScope.contains(file.getVirtualFile()));
        if (scopeNotEmptyAndContainsFile && !packageExists && !oldPackageExists) {
            this.diagnoseMissingPackageFragmentPartialPackageIndexCorruption(message2);
            throw new KotlinNothingValueException();
        }
        if (scopeNotEmptyAndContainsFile && packageExists && Intrinsics.areEqual((Object)cachedPackageExists, (Object)false)) {
            this.diagnoseMissingPackageFragmentPerModulePackageCacheMiss(message2);
            throw new KotlinNothingValueException();
        }
        this.diagnoseMissingPackageFragmentUnknownReason(message2);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public final String debugToString() {
        Object[] objectArray = new String[]{"PluginDeclarationProviderFactory", "On failure:", this.debugInfo(), "On creation:", this.onCreationDebugInfo, "moduleInfo:" + this.moduleInfo + ".name", "moduleInfo dependencies: " + this.moduleInfo.dependencies()};
        return ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final boolean oldPackageExists(FqName packageFqName) {
        return KotlinPackageIndexUtils.INSTANCE.packageExists(packageFqName, this.indexedFilesScope);
    }

    private final String debugInfo() {
        StringBuilder stringBuilder;
        if (this.nonIndexedFiles.isEmpty()) {
            return "-no synthetic files-\n";
        }
        StringBuilder $this$debugInfo_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = this.nonIndexedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile it = (KtFile)element$iv;
            boolean bl2 = false;
            $this$debugInfo_u24lambda_u240.append(it.getName());
            $this$debugInfo_u24lambda_u240.append(" isPhysical=" + it.isPhysical());
            $this$debugInfo_u24lambda_u240.append(" modStamp=" + it.getModificationStamp());
            $this$debugInfo_u24lambda_u240.append('\n');
        }
        return stringBuilder.toString();
    }
}

