/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.suggestions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.suggestions.JupyterNotebookSuggestionProviderKt;
import org.jetbrains.kotlin.idea.suggestions.JupyterPluginSuggestion;
import org.jetbrains.kotlin.idea.suggestions.PluginEnablementChecker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/suggestions/JupyterNotebookSuggestionProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestionProvider;", "<init>", "()V", "getSuggestion", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getNotebookLanguage", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/JupyterNotebookSuggestionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n231#2,2:149\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/JupyterNotebookSuggestionProvider\n*L\n66#1:149,2\n*E\n"})
public final class JupyterNotebookSuggestionProvider
implements PluginSuggestionProvider {
    @Nullable
    public PluginSuggestion getSuggestion(@NotNull Project project, @NotNull VirtualFile file) {
        Object element$iv2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"ipynb")) {
                return null;
            }
            String notebookLanguage = this.getNotebookLanguage(file);
            Iterable $this$first$iv = JupyterNotebookSuggestionProviderKt.access$getEnablementCheckers$p();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                PluginEnablementChecker checker = (PluginEnablementChecker)element$iv2;
                boolean bl = false;
                if (!checker.isNotebookLanguageSupported(notebookLanguage)) continue;
                break block4;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        PluginEnablementChecker enablementChecker = (PluginEnablementChecker)element$iv2;
        if (enablementChecker.isSuggestionDismissed()) {
            return null;
        }
        if (enablementChecker.pluginsInstalledAndEnabled()) {
            return null;
        }
        return new JupyterPluginSuggestion(project, enablementChecker);
    }

    private final String getNotebookLanguage(VirtualFile file) {
        String string;
        try {
            String string2;
            String string3;
            JsonElement jsonElement;
            JsonObject jsonObject;
            JsonElement jsonElement2;
            JsonObject jsonObject2;
            JsonElement json = JsonParser.parseString((String)VirtualFileUtil.readText((VirtualFile)file));
            JsonElement jsonElement3 = json.getAsJsonObject().get("metadata");
            if (jsonElement3 != null && (jsonObject2 = jsonElement3.getAsJsonObject()) != null && (jsonElement2 = jsonObject2.get("language_info")) != null && (jsonObject = jsonElement2.getAsJsonObject()) != null && (jsonElement = jsonObject.get("name")) != null && (string3 = jsonElement.getAsString()) != null) {
                String string4 = string3.toLowerCase(Locale.ROOT);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }
}

