/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.update;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.update.KotlinPluginUpdaterBundle;
import org.jetbrains.kotlin.idea.update.PluginUpdateVerifier;
import org.jetbrains.kotlin.idea.update.PluginVerifyResult;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier;", "Lorg/jetbrains/kotlin/idea/update/PluginUpdateVerifier;", "<init>", "()V", "verifierName", "", "getVerifierName", "()Ljava/lang/String;", "verify", "Lorg/jetbrains/kotlin/idea/update/PluginVerifyResult;", "pluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getRelease", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "pluginCompatibility", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$PluginCompatibility;", "buildInRange", "", "name", "sinceBuild", "untilBuild", "Companion", "intellij.kotlin.plugin.updater"})
@SourceDebugExtension(value={"SMAP\nGooglePluginUpdateVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GooglePluginUpdateVerifier.kt\norg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,157:1\n13225#2,2:158\n*S KotlinDebug\n*F\n+ 1 GooglePluginUpdateVerifier.kt\norg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier\n*L\n42#1:158,2\n*E\n"})
public final class GooglePluginUpdateVerifier
extends PluginUpdateVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KOTLIN_PLUGIN_ID = "org.jetbrains.kotlin";
    @NotNull
    private static final String METADATA_FILE_URL = "https://dl.google.com/android/studio/plugins/compatibility.xml";
    @NotNull
    private static final Logger LOG;

    @Override
    @NotNull
    public String getVerifierName() {
        return KotlinPluginUpdaterBundle.message("update.name.android.studio", new Object[0]);
    }

    @Override
    @Nullable
    public PluginVerifyResult verify(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        String pluginVersion = KotlinIdePlugin.INSTANCE.getVersion();
        if (!Intrinsics.areEqual((Object)pluginDescriptor.getPluginId(), (Object)KotlinIdePlugin.INSTANCE.getId()) || KotlinIdePlugin.INSTANCE.isPostProcessed()) {
            return null;
        }
        if (KotlinIdePlugin.INSTANCE.isPreRelease()) {
            return PluginVerifyResult.Companion.accept();
        }
        try {
            boolean bl;
            block10: {
                URL url = new URL(METADATA_FILE_URL);
                InputStream stream = url.openStream();
                Class[] classArray = new Class[]{Companion.PluginCompatibility.class};
                JAXBContext context2 = JAXBContext.newInstance((Class[])classArray);
                Unmarshaller unmarshaller = context2.createUnmarshaller();
                Object object = unmarshaller.unmarshal(stream);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.update.GooglePluginUpdateVerifier.Companion.PluginCompatibility");
                Companion.PluginCompatibility pluginCompatibility = (Companion.PluginCompatibility)object;
                Companion.StudioRelease studioRelease = this.getRelease(pluginCompatibility);
                if (studioRelease == null) {
                    return PluginVerifyResult.Companion.decline(KotlinPluginUpdaterBundle.message("update.reason.text.no.verified.versions.for.this.build", new Object[0]));
                }
                Companion.StudioRelease release = studioRelease;
                Companion.IdeaPlugin[] $this$any$iv = GooglePluginUpdateVerifier.Companion.plugins(release);
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    Companion.IdeaPlugin element$iv;
                    Companion.IdeaPlugin it = element$iv = $this$any$iv[j];
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)KOTLIN_PLUGIN_ID, (Object)it.getId()) && Intrinsics.areEqual((Object)pluginVersion, (Object)it.getVersion()))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            return bl ? PluginVerifyResult.Companion.accept() : PluginVerifyResult.Companion.decline(KotlinPluginUpdaterBundle.message("update.reason.text.version.to.be.verified", new Object[0]));
        }
        catch (Exception e) {
            PluginVerifyResult pluginVerifyResult;
            LOG.info("Exception when verifying plugin " + pluginDescriptor.getPluginId().getIdString() + " version " + pluginVersion, (Throwable)e);
            Exception exception = e;
            if (exception instanceof IOException) {
                String message2 = KotlinPluginUpdaterBundle.message("update.reason.text.unable.to.connect.to.compatibility.verification.repository", new Object[0]);
                pluginVerifyResult = PluginVerifyResult.Companion.decline(message2);
            } else if (exception instanceof JAXBException) {
                String message3 = KotlinPluginUpdaterBundle.message("update.reason.text.unable.to.parse.compatibility.verification.metadata", new Object[0]);
                pluginVerifyResult = PluginVerifyResult.Companion.decline(message3);
            } else {
                Object[] objectArray = new Object[]{String.valueOf(e.getMessage())};
                String message4 = KotlinPluginUpdaterBundle.message("update.reason.text.exception.during.verification", objectArray);
                pluginVerifyResult = PluginVerifyResult.Companion.decline(message4);
            }
            return pluginVerifyResult;
        }
    }

    private final Companion.StudioRelease getRelease(Companion.PluginCompatibility pluginCompatibility) {
        for (Companion.StudioRelease studioRelease : GooglePluginUpdateVerifier.Companion.releases(pluginCompatibility)) {
            if (!this.buildInRange(studioRelease.getName(), studioRelease.getSinceBuild(), studioRelease.getUntilBuild())) continue;
            return studioRelease;
        }
        return null;
    }

    private final boolean buildInRange(String name2, String sinceBuild, String untilBuild) {
        PluginNode descriptor2 = new PluginNode(PluginId.Companion.getId(KOTLIN_PLUGIN_ID));
        descriptor2.setName(name2);
        descriptor2.setSinceBuild(sinceBuild);
        descriptor2.setUntilBuild(untilBuild);
        return PluginManagerCore.isCompatible((IdeaPluginDescriptor)((IdeaPluginDescriptor)descriptor2));
    }

    static {
        Logger logger = Logger.getInstance(GooglePluginUpdateVerifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b*\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion;", "", "<init>", "()V", "KOTLIN_PLUGIN_ID", "", "METADATA_FILE_URL", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "releases", "", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$PluginCompatibility;", "(Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$PluginCompatibility;)[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "plugins", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "(Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;)[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "PluginCompatibility", "StudioRelease", "IdeaPlugin", "IdeaVersion", "intellij.kotlin.plugin.updater"})
    public static final class Companion {
        private Companion() {
        }

        private final StudioRelease[] releases(PluginCompatibility $this$releases) {
            StudioRelease[] studioReleaseArray = $this$releases.getStudioRelease();
            if (studioReleaseArray == null) {
                studioReleaseArray = new StudioRelease[]{};
            }
            return studioReleaseArray;
        }

        private final IdeaPlugin[] plugins(StudioRelease $this$plugins) {
            IdeaPlugin[] ideaPluginArray = $this$plugins.getIdeaPlugin();
            if (ideaPluginArray == null) {
                ideaPluginArray = new IdeaPlugin[]{};
            }
            return ideaPluginArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0019\u001a\u00020\u0005H\u0096\u0080\u0004R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR \u0010\r\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR \u0010\u0010\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR \u0010\u0013\u001a\u0004\u0018\u00010\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "sha256", "getSha256", "setSha256", "channel", "getChannel", "setChannel", "version", "getVersion", "setVersion", "ideaVersion", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaVersion;", "getIdeaVersion", "()Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaVersion;", "setIdeaVersion", "(Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaVersion;)V", "toString", "intellij.kotlin.plugin.updater"})
        public static final class IdeaPlugin {
            @XmlAttribute
            @Nullable
            private String id;
            @XmlAttribute
            @Nullable
            private String sha256;
            @XmlAttribute
            @Nullable
            private String channel;
            @XmlAttribute
            @Nullable
            private String version;
            @XmlElement(name="idea-version")
            @Nullable
            private IdeaVersion ideaVersion;

            @Nullable
            public final String getId() {
                return this.id;
            }

            public final void setId(@Nullable String string) {
                this.id = string;
            }

            @Nullable
            public final String getSha256() {
                return this.sha256;
            }

            public final void setSha256(@Nullable String string) {
                this.sha256 = string;
            }

            @Nullable
            public final String getChannel() {
                return this.channel;
            }

            public final void setChannel(@Nullable String string) {
                this.channel = string;
            }

            @Nullable
            public final String getVersion() {
                return this.version;
            }

            public final void setVersion(@Nullable String string) {
                this.version = string;
            }

            @Nullable
            public final IdeaVersion getIdeaVersion() {
                return this.ideaVersion;
            }

            public final void setIdeaVersion(@Nullable IdeaVersion ideaVersion) {
                this.ideaVersion = ideaVersion;
            }

            @NotNull
            public String toString() {
                return "IdeaPlugin(id=" + this.id + ", sha256=" + this.sha256 + ", ideaVersion=" + this.ideaVersion + ", channel=" + this.channel + ", version=" + this.version + ")";
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\r\u001a\u00020\u0005H\u0096\u0080\u0004R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaVersion;", "", "<init>", "()V", "untilBuild", "", "getUntilBuild", "()Ljava/lang/String;", "setUntilBuild", "(Ljava/lang/String;)V", "sinceBuild", "getSinceBuild", "setSinceBuild", "toString", "intellij.kotlin.plugin.updater"})
        public static final class IdeaVersion {
            @XmlAttribute(name="until-build")
            @Nullable
            private String untilBuild;
            @XmlAttribute(name="since-build")
            @Nullable
            private String sinceBuild;

            @Nullable
            public final String getUntilBuild() {
                return this.untilBuild;
            }

            public final void setUntilBuild(@Nullable String string) {
                this.untilBuild = string;
            }

            @Nullable
            public final String getSinceBuild() {
                return this.sinceBuild;
            }

            public final void setSinceBuild(@Nullable String string) {
                this.sinceBuild = string;
            }

            @NotNull
            public String toString() {
                return "IdeaVersion(untilBuild=" + this.untilBuild + ", sinceBuild=" + this.sinceBuild + ")";
            }
        }

        @XmlRootElement(name="plugin-compatibility")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\f\u001a\u00020\rH\u0096\u0080\u0004R(\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$PluginCompatibility;", "", "<init>", "()V", "studioRelease", "", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "getStudioRelease", "()[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "setStudioRelease", "([Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;)V", "[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "toString", "", "intellij.kotlin.plugin.updater"})
        public static final class PluginCompatibility {
            @XmlElement(name="studio-release")
            @Nullable
            private StudioRelease[] studioRelease;

            @Nullable
            public final StudioRelease[] getStudioRelease() {
                return this.studioRelease;
            }

            public final void setStudioRelease(@Nullable StudioRelease[] studioReleaseArray) {
                this.studioRelease = studioReleaseArray;
            }

            @NotNull
            public String toString() {
                String string = Arrays.toString(this.studioRelease);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return "PluginCompatibility(studioRelease=" + string + ")";
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u001b\u001a\u00020\u0005H\u0096\u0080\u0004R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR \u0010\r\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR \u0010\u0010\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR(\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$StudioRelease;", "", "<init>", "()V", "untilBuild", "", "getUntilBuild", "()Ljava/lang/String;", "setUntilBuild", "(Ljava/lang/String;)V", "sinceBuild", "getSinceBuild", "setSinceBuild", "name", "getName", "setName", "channel", "getChannel", "setChannel", "ideaPlugin", "", "Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "getIdeaPlugin", "()[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "setIdeaPlugin", "([Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;)V", "[Lorg/jetbrains/kotlin/idea/update/GooglePluginUpdateVerifier$Companion$IdeaPlugin;", "toString", "intellij.kotlin.plugin.updater"})
        public static final class StudioRelease {
            @XmlAttribute(name="until-build")
            @Nullable
            private String untilBuild;
            @XmlAttribute(name="since-build")
            @Nullable
            private String sinceBuild;
            @XmlAttribute
            @Nullable
            private String name;
            @XmlAttribute
            @Nullable
            private String channel;
            @XmlElement(name="idea-plugin")
            @Nullable
            private IdeaPlugin[] ideaPlugin;

            @Nullable
            public final String getUntilBuild() {
                return this.untilBuild;
            }

            public final void setUntilBuild(@Nullable String string) {
                this.untilBuild = string;
            }

            @Nullable
            public final String getSinceBuild() {
                return this.sinceBuild;
            }

            public final void setSinceBuild(@Nullable String string) {
                this.sinceBuild = string;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }

            public final void setName(@Nullable String string) {
                this.name = string;
            }

            @Nullable
            public final String getChannel() {
                return this.channel;
            }

            public final void setChannel(@Nullable String string) {
                this.channel = string;
            }

            @Nullable
            public final IdeaPlugin[] getIdeaPlugin() {
                return this.ideaPlugin;
            }

            public final void setIdeaPlugin(@Nullable IdeaPlugin[] ideaPluginArray) {
                this.ideaPlugin = ideaPluginArray;
            }

            @NotNull
            public String toString() {
                String string = Arrays.toString(this.ideaPlugin);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return "StudioRelease(untilBuild=" + this.untilBuild + ", name=" + this.name + ", ideaPlugin=" + string + ", sinceBuild=" + this.sinceBuild + ", channel=" + this.channel + ")";
            }
        }
    }
}

