/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J^\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000fJ&\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/util/AnnotationModificationHelper;", "", "<init>", "()V", "addAnnotation", "", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "annotationInnerText", "", "useSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "searchForExistingEntry", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "whiteSpaceText", "addToExistingAnnotation", "buildAnnotationText", "fqName", "intellij.kotlin.base.codeInsight"})
public final class AnnotationModificationHelper {
    @NotNull
    public static final AnnotationModificationHelper INSTANCE = new AnnotationModificationHelper();

    private AnnotationModificationHelper() {
    }

    public final boolean addAnnotation(@NotNull KtModifierListOwner element, @NotNull FqName annotationFqName, @Nullable String annotationInnerText, @Nullable AnnotationUseSiteTarget useSiteTarget, @NotNull Function1<? super KtAnnotated, ? extends KtAnnotationEntry> searchForExistingEntry, @NotNull String whiteSpaceText, @Nullable Function1<? super KtAnnotationEntry, Boolean> addToExistingAnnotation) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        Intrinsics.checkNotNullParameter(searchForExistingEntry, (String)"searchForExistingEntry");
        Intrinsics.checkNotNullParameter((Object)whiteSpaceText, (String)"whiteSpaceText");
        String annotationText = this.buildAnnotationText(annotationFqName, annotationInnerText, useSiteTarget);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtModifierList modifierList = element.getModifierList();
        if (modifierList == null) {
            KtAnnotationEntry ktAnnotationEntry = element.addAnnotationEntry(psiFactory.createAnnotationEntry(annotationText));
            Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"addAnnotationEntry(...)");
            KtAnnotationEntry addedAnnotation = ktAnnotationEntry;
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)addedAnnotation);
            if (!(element instanceof KtScriptInitializer)) {
                return true;
            }
            PsiElement psiElement = addedAnnotation.getParent();
            KtModifierList ktModifierList = psiElement instanceof KtModifierList ? (KtModifierList)psiElement : null;
            if (ktModifierList == null) {
                return false;
            }
            KtModifierList addedModifierList = ktModifierList;
            PsiElement newLine = psiFactory.createNewLine();
            addedModifierList.addAfter(newLine, (PsiElement)addedAnnotation);
            return true;
        }
        KtAnnotationEntry entry = (KtAnnotationEntry)searchForExistingEntry.invoke((Object)element);
        if (entry == null) {
            KtAnnotationEntry newAnnotation = psiFactory.createAnnotationEntry(annotationText);
            PsiElement psiElement = modifierList.addBefore((PsiElement)newAnnotation, modifierList.getFirstChild());
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            KtElement addedAnnotation = (KtElement)psiElement;
            PsiElement whiteSpace = psiFactory.createWhiteSpace(whiteSpaceText);
            modifierList.addAfter(whiteSpace, (PsiElement)addedAnnotation);
            ShortenReferencesFacility.Companion.getInstance().shorten(addedAnnotation);
            return true;
        }
        if (addToExistingAnnotation != null) {
            return (Boolean)addToExistingAnnotation.invoke((Object)entry);
        }
        return false;
    }

    @NotNull
    public final String buildAnnotationText(@NotNull FqName fqName2, @Nullable String annotationInnerText, @Nullable AnnotationUseSiteTarget useSiteTarget) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        StringBuilder $this$buildAnnotationText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildAnnotationText_u24lambda_u240.append('@');
        if (useSiteTarget != null) {
            $this$buildAnnotationText_u24lambda_u240.append(useSiteTarget.getRenderName() + ":");
        }
        $this$buildAnnotationText_u24lambda_u240.append(RenderingUtilsKt.render((FqName)fqName2));
        if (annotationInnerText != null) {
            $this$buildAnnotationText_u24lambda_u240.append("(" + annotationInnerText + ")");
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String buildAnnotationText$default(AnnotationModificationHelper annotationModificationHelper, FqName fqName2, String string, AnnotationUseSiteTarget annotationUseSiteTarget, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            annotationUseSiteTarget = null;
        }
        return annotationModificationHelper.buildAnnotationText(fqName2, string, annotationUseSiteTarget);
    }
}

