/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lang.BinaryOperationPrecedence;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/util/PsiPrecedences;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PRECEDENCE_OF_ATOMIC_EXPRESSION", "", "getPrecedence", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isTighter", "", "subject", "tighterThan", "intellij.kotlin.base.codeInsight"})
public final class PsiPrecedences {
    @NotNull
    public static final PsiPrecedences INSTANCE = new PsiPrecedences();
    @NotNull
    private static final Logger LOG;
    private static final int PRECEDENCE_OF_ATOMIC_EXPRESSION = -1;

    private PsiPrecedences() {
    }

    public final int getPrecedence(@NotNull KtExpression expression) {
        int n;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtAnnotatedExpression || ktExpression instanceof KtLabeledExpression || ktExpression instanceof KtPostfixExpression) {
            n = 0;
        } else if (ktExpression instanceof KtPrefixExpression) {
            n = 1;
        } else if (ktExpression instanceof KtOperationExpression) {
            IElementType operation = ((KtOperationExpression)expression).getOperationReference().getReferencedNameElementType();
            BinaryOperationPrecedence binaryOperationPrecedence = (BinaryOperationPrecedence)BinaryOperationPrecedence.TOKEN_TO_BINARY_PRECEDENCE_MAP.get(operation);
            if (binaryOperationPrecedence == null) {
                LOG.error("No precedence for operation: " + operation);
                n = 14;
            } else {
                n = binaryOperationPrecedence.ordinal();
            }
        } else {
            n = -1;
        }
        return n;
    }

    public final boolean isTighter(int subject, int tighterThan) {
        return subject < tighterThan;
    }

    static {
        Logger logger = Logger.getInstance(PsiPrecedences.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

