/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ScalarIndexExtension;
import java.util.Collections;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.vfilefinder.FqNameKeyDescriptor;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0012H\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinFileIndexBase;", "Lcom/intellij/util/indexing/ScalarIndexExtension;", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "dependsOnFileContent", "", "getKeyDescriptor", "Lorg/jetbrains/kotlin/idea/vfilefinder/FqNameKeyDescriptor;", "indexer", "Lcom/intellij/util/indexing/DataIndexer;", "Ljava/lang/Void;", "Lcom/intellij/util/indexing/FileContent;", "f", "Lkotlin/Function1;", "intellij.kotlin.base.indices"})
public abstract class KotlinFileIndexBase
extends ScalarIndexExtension<FqName> {
    @NotNull
    private final Logger LOG;

    public KotlinFileIndexBase() {
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    @NotNull
    protected final Logger getLOG() {
        return this.LOG;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FqNameKeyDescriptor getKeyDescriptor() {
        return FqNameKeyDescriptor.INSTANCE;
    }

    @NotNull
    protected final DataIndexer<FqName, Void, FileContent> indexer(@NotNull Function1<? super FileContent, FqName> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return arg_0 -> KotlinFileIndexBase.indexer$lambda$0(f, this, arg_0);
    }

    private static final Map indexer$lambda$0(Function1 $f, KotlinFileIndexBase this$0, FileContent it) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            FqName fqName2 = (FqName)$f.invoke((Object)it);
            map2 = fqName2 != null ? Collections.singletonMap(fqName2, null) : MapsKt.emptyMap();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            this$0.LOG.warn("Error while indexing file " + it.getFileName() + ": " + e.getMessage());
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }
}

