/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.UtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001(B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J \u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u00042\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J(\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010'\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u000b\u001a>\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f0\fj\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0012j\b\u0012\u0004\u0012\u00020\u0004`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/j2k/OverloadReducer;", "", "methods", "", "Lcom/intellij/psi/PsiMethod;", "isOpenClass", "", "referenceSearcher", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "<init>", "(Ljava/util/Collection;ZLorg/jetbrains/kotlin/j2k/ReferenceSearcher;)V", "methodToLastParameterDefaults", "Ljava/util/HashMap;", "Ljava/util/ArrayList;", "Lcom/intellij/psi/PsiExpression;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/HashMap;", "methodsToDrop", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "shouldDropMethod", "method", "parameterDefault", "parameterIndex", "", "buildOverloadEquivalenceMap", "", "Lorg/jetbrains/kotlin/j2k/OverloadReducer$EquivalentOverloadInfo;", "shouldSkipOverload", "findEquivalentOverload", "overloads", "calcTargetParameterDefaults", "", "target", "targetCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "dropOverloadsForDefaultValues", "", "equivalenceMap", "getAnnotationsFingerprint", "EquivalentOverloadInfo", "kotlin.j2k.k1.old"})
@SourceDebugExtension(value={"SMAP\nOverloadReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverloadReducer.kt\norg/jetbrains/kotlin/j2k/OverloadReducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,185:1\n1512#2:186\n1538#2,3:187\n1541#2,3:197\n777#2:200\n873#2,2:201\n1586#2:203\n1661#2,2:204\n832#2:206\n862#2,2:207\n1663#2:209\n777#2:210\n873#2,2:211\n1080#2:217\n383#3,7:190\n383#3,7:218\n129#4:213\n158#4,3:214\n11705#5:225\n12052#5,3:226\n*S KotlinDebug\n*F\n+ 1 OverloadReducer.kt\norg/jetbrains/kotlin/j2k/OverloadReducer\n*L\n41#1:186\n41#1:187,3\n41#1:197,3\n47#1:200\n47#1:201,2\n48#1:203\n48#1:204,2\n48#1:206\n48#1:207,2\n48#1:209\n49#1:210\n49#1:211,2\n129#1:217\n41#1:190,7\n140#1:218,7\n128#1:213\n128#1:214,3\n157#1:225\n157#1:226,3\n*E\n"})
public final class OverloadReducer {
    @NotNull
    private final Collection<PsiMethod> methods;
    private final boolean isOpenClass;
    @NotNull
    private final ReferenceSearcher referenceSearcher;
    @NotNull
    private final HashMap<PsiMethod, ArrayList<PsiExpression>> methodToLastParameterDefaults;
    @NotNull
    private final HashSet<PsiMethod> methodsToDrop;

    public OverloadReducer(@NotNull Collection<? extends PsiMethod> methods, boolean isOpenClass, @NotNull ReferenceSearcher referenceSearcher) {
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        Intrinsics.checkNotNullParameter((Object)referenceSearcher, (String)"referenceSearcher");
        this.methods = methods;
        this.isOpenClass = isOpenClass;
        this.referenceSearcher = referenceSearcher;
        this.methodToLastParameterDefaults = new HashMap();
        this.methodsToDrop = new HashSet();
        Map<PsiMethod, EquivalentOverloadInfo> map2 = this.buildOverloadEquivalenceMap();
        this.dropOverloadsForDefaultValues(map2);
    }

    public final boolean shouldDropMethod(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return this.methodsToDrop.contains(method);
    }

    @Nullable
    public final PsiExpression parameterDefault(@NotNull PsiMethod method, int parameterIndex) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        ArrayList<PsiExpression> arrayList = this.methodToLastParameterDefaults.get(method);
        if (arrayList == null) {
            return null;
        }
        ArrayList<PsiExpression> defaults = arrayList;
        int index2 = method.getParameterList().getParametersCount() - parameterIndex - 1;
        return index2 < defaults.size() ? defaults.get(index2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PsiMethod, EquivalentOverloadInfo> buildOverloadEquivalenceMap() {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$getOrPut$iv$iv$iv;
        Object it;
        Iterable $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.methods;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (PsiMethod)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.isConstructor() ? null : it.getName(), UtilsKt.accessModifier((PsiModifierListOwner)it), it.getReturnType(), it.hasModifierProperty("static"), this.getAnnotationsFingerprint((PsiMethod)it)};
            List key$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            Object object2 = destination$iv$iv;
            List key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = destination$iv$iv.values();
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterNotTo$iv$iv;
            it = (List)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filterNot$iv = (Iterable)it;
            boolean $i$f$filterNot = false;
            $this$getOrPut$iv$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                PsiMethod it2 = (PsiMethod)element$iv$iv;
                boolean bl3 = false;
                if (this.shouldSkipOverload(it2)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            object.add((List)destination$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List overloadGroups = (List)destination$iv$iv;
        HashMap map2 = new HashMap();
        for (List group : overloadGroups) {
            for (PsiMethod method : group) {
                EquivalentOverloadInfo overloadInfo;
                if (this.findEquivalentOverload(method, group) == null) continue;
                EquivalentOverloadInfo furtherOverloadInfo = (EquivalentOverloadInfo)map2.get(overloadInfo.getMethod());
                EquivalentOverloadInfo resultOverloadInfo = furtherOverloadInfo != null ? new EquivalentOverloadInfo(furtherOverloadInfo.getMethod(), CollectionsKt.plus((Collection)overloadInfo.getParameterDefaults(), (Iterable)furtherOverloadInfo.getParameterDefaults())) : overloadInfo;
                ((Map)map2).put(method, resultOverloadInfo);
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                    if (!Intrinsics.areEqual((Object)((EquivalentOverloadInfo)entry.getValue()).getMethod(), (Object)method)) continue;
                    List newParameterDefaults = CollectionsKt.plus((Collection)((EquivalentOverloadInfo)entry.getValue()).getParameterDefaults(), (Iterable)resultOverloadInfo.getParameterDefaults());
                    entry.setValue(new EquivalentOverloadInfo(resultOverloadInfo.getMethod(), newParameterDefaults));
                }
            }
        }
        return map2;
    }

    private final boolean shouldSkipOverload(PsiMethod method) {
        if (method.isConstructor()) {
            return false;
        }
        if (method.hasModifierProperty("abstract")) {
            return true;
        }
        if (method.hasModifierProperty("native")) {
            return true;
        }
        if (method.hasModifierProperty("synchronized")) {
            return true;
        }
        List list2 = method.getHierarchicalMethodSignature().getSuperSignatures();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSuperSignatures(...)");
        if (!((Collection)list2).isEmpty()) {
            return true;
        }
        return this.isOpenClass && this.referenceSearcher.hasOverrides(method);
    }

    private final EquivalentOverloadInfo findEquivalentOverload(PsiMethod method, Collection<? extends PsiMethod> overloads) {
        String string;
        PsiStatement psiStatement = method.getBody();
        if (psiStatement == null || (psiStatement = psiStatement.getStatements()) == null || (psiStatement = (PsiStatement)ArraysKt.singleOrNull((Object[])psiStatement)) == null) {
            return null;
        }
        PsiStatement statement = psiStatement;
        PsiStatement psiStatement2 = statement;
        PsiExpression psiExpression = psiStatement2 instanceof PsiExpressionStatement ? ((PsiExpressionStatement)statement).getExpression() : (psiStatement2 instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : null);
        PsiMethodCallExpression psiMethodCallExpression = psiExpression instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)psiExpression : null;
        if (psiMethodCallExpression == null) {
            return null;
        }
        PsiMethodCallExpression methodCall = psiMethodCallExpression;
        if (method.isConstructor()) {
            string = "this";
        } else {
            String string2 = method.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        String expectedMethodName = string;
        PsiReferenceExpression psiReferenceExpression = methodCall.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression, (String)"getMethodExpression(...)");
        PsiReferenceExpression refExpr = psiReferenceExpression;
        if (refExpr.isQualified() || !Intrinsics.areEqual((Object)refExpr.getReferenceName(), (Object)expectedMethodName)) {
            return null;
        }
        PsiElement psiElement = refExpr.resolve();
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (psiMethod == null) {
            return null;
        }
        PsiMethod target = psiMethod;
        if (!overloads.contains(target)) {
            return null;
        }
        List<PsiExpression> list2 = this.calcTargetParameterDefaults(method, target, methodCall);
        if (list2 == null) {
            return null;
        }
        List<PsiExpression> parameterDefaults = list2;
        return new EquivalentOverloadInfo(target, parameterDefaults);
    }

    private final List<PsiExpression> calcTargetParameterDefaults(PsiMethod method, PsiMethod target, PsiMethodCallExpression targetCall) {
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter[] parameters2 = psiParameterArray;
        PsiParameter[] psiParameterArray2 = target.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray2, (String)"getParameters(...)");
        PsiParameter[] targetParameters = psiParameterArray2;
        if (parameters2.length >= targetParameters.length) {
            return null;
        }
        Object[] objectArray = targetCall.getArgumentList().getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExpressions(...)");
        Object[] args = objectArray;
        if (args.length != targetParameters.length) {
            return null;
        }
        int n = parameters2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            PsiParameter parameter = parameters2[i2];
            PsiParameter targetParameter = targetParameters[i2];
            if (!Intrinsics.areEqual((Object)parameter.getName(), (Object)targetParameter.getName()) || !Intrinsics.areEqual((Object)parameter.getType(), (Object)targetParameter.getType())) {
                return null;
            }
            Object arg = args[i2];
            if (arg instanceof PsiReferenceExpression && Intrinsics.areEqual((Object)((PsiReferenceExpression)arg).resolve(), (Object)parameter)) continue;
            return null;
        }
        return ArraysKt.drop((Object[])args, (int)parameters2.length);
    }

    /*
     * WARNING - void declaration
     */
    private final void dropOverloadsForDefaultValues(Map<PsiMethod, EquivalentOverloadInfo> equivalenceMap) {
        void $this$mapTo$iv$iv;
        Map<PsiMethod, EquivalentOverloadInfo> $this$map$iv = equivalenceMap;
        boolean $i$f$map = false;
        Map<PsiMethod, EquivalentOverloadInfo> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PsiMethod)it.getKey());
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List dropCandidates = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PsiMethod it = (PsiMethod)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getParameterList().getParametersCount());
                it = (PsiMethod)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getParameterList().getParametersCount()));
            }
        });
        block1: for (PsiMethod method : dropCandidates) {
            Object object;
            void $this$getOrPut$iv;
            boolean bl;
            boolean bl2;
            EquivalentOverloadInfo targetInfo;
            int paramCount = method.getParameterList().getParametersCount();
            Intrinsics.checkNotNull((Object)equivalenceMap.get(method));
            int targetParamCount = targetInfo.getMethod().getParameterList().getParametersCount();
            boolean bl3 = bl2 = paramCount < targetParamCount;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            List<PsiExpression> defaults = targetInfo.getParameterDefaults();
            boolean bl4 = bl = defaults.size() == targetParamCount - paramCount;
            if (_Assertions.ENABLED && !bl) {
                String it = "Assertion failed";
                throw new AssertionError((Object)it);
            }
            Map it = this.methodToLastParameterDefaults;
            PsiMethod key$iv = targetInfo.getMethod();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl42 = false;
                ArrayList answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ArrayList arrayList = (ArrayList)object;
            int n = ((Collection)defaults).size();
            for (int i2 = 0; i2 < n; ++i2) {
                PsiExpression psiExpression = defaults.get(defaults.size() - i2 - 1);
                if (i2 < arrayList.size()) {
                    if (Intrinsics.areEqual((Object)((PsiExpression)arrayList.get(i2)).getText(), (Object)psiExpression.getText())) continue;
                    continue block1;
                }
                arrayList.add(psiExpression);
            }
            this.methodsToDrop.add(method);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object getAnnotationsFingerprint(PsiMethod method) {
        void $this$mapTo$iv$iv;
        PsiAnnotation[] psiAnnotationArray = method.getModifierList().getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
        Object[] $this$map$iv = psiAnnotationArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiAnnotation psiAnnotation = (PsiAnnotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getText());
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/j2k/OverloadReducer$EquivalentOverloadInfo;", "", "method", "Lcom/intellij/psi/PsiMethod;", "parameterDefaults", "", "Lcom/intellij/psi/PsiExpression;", "<init>", "(Lcom/intellij/psi/PsiMethod;Ljava/util/List;)V", "getMethod", "()Lcom/intellij/psi/PsiMethod;", "getParameterDefaults", "()Ljava/util/List;", "kotlin.j2k.k1.old"})
    private static final class EquivalentOverloadInfo {
        @NotNull
        private final PsiMethod method;
        @NotNull
        private final List<PsiExpression> parameterDefaults;

        public EquivalentOverloadInfo(@NotNull PsiMethod method, @NotNull List<? extends PsiExpression> parameterDefaults) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(parameterDefaults, (String)"parameterDefaults");
            this.method = method;
            this.parameterDefaults = parameterDefaults;
        }

        @NotNull
        public final PsiMethod getMethod() {
            return this.method;
        }

        @NotNull
        public final List<PsiExpression> getParameterDefaults() {
            return this.parameterDefaults;
        }
    }
}

