/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Statement;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/ForeachStatement;", "Lorg/jetbrains/kotlin/j2k/ast/Statement;", "variableName", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "explicitVariableType", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "collection", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "body", "Lorg/jetbrains/kotlin/j2k/ast/Element;", "singleLine", "", "<init>", "(Lorg/jetbrains/kotlin/j2k/ast/Identifier;Lorg/jetbrains/kotlin/j2k/ast/Type;Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Element;Z)V", "getCollection", "()Lorg/jetbrains/kotlin/j2k/ast/Expression;", "getBody", "()Lorg/jetbrains/kotlin/j2k/ast/Element;", "br", "", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "kotlin.j2k.k1.old"})
public final class ForeachStatement
extends Statement {
    @NotNull
    private final Identifier variableName;
    @Nullable
    private final Type explicitVariableType;
    @NotNull
    private final Expression collection;
    @NotNull
    private final Element body;
    @NotNull
    private final String br;

    public ForeachStatement(@NotNull Identifier variableName, @Nullable Type explicitVariableType, @NotNull Expression collection, @NotNull Element body2, boolean singleLine) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        this.variableName = variableName;
        this.explicitVariableType = explicitVariableType;
        this.collection = collection;
        this.body = body2;
        this.br = singleLine ? " " : "\n";
    }

    @NotNull
    public final Expression getCollection() {
        return this.collection;
    }

    @NotNull
    public final Element getBody() {
        return this.body;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        builder2.append("for (").append(this.variableName);
        if (this.explicitVariableType != null) {
            builder2.append(":").append(this.explicitVariableType);
        }
        builder2.append(" in ").append(this.collection).append(")").append(this.br).append(UtilKt.wrapToBlockIfRequired(this.body));
        if (this.body.isEmpty()) {
            builder2.append(";");
        }
    }
}

