/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/IfStatement;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "condition", "thenStatement", "Lorg/jetbrains/kotlin/j2k/ast/Element;", "elseStatement", "singleLine", "", "<init>", "(Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Element;Lorg/jetbrains/kotlin/j2k/ast/Element;Z)V", "getCondition", "()Lorg/jetbrains/kotlin/j2k/ast/Expression;", "br", "", "brAfterElse", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "kotlin.j2k.k1.old"})
public final class IfStatement
extends Expression {
    @NotNull
    private final Expression condition;
    @NotNull
    private final Element thenStatement;
    @NotNull
    private final Element elseStatement;
    @NotNull
    private final String br;
    @NotNull
    private final String brAfterElse;

    public IfStatement(@NotNull Expression condition2, @NotNull Element thenStatement, @NotNull Element elseStatement, boolean singleLine) {
        Intrinsics.checkNotNullParameter((Object)condition2, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)thenStatement, (String)"thenStatement");
        Intrinsics.checkNotNullParameter((Object)elseStatement, (String)"elseStatement");
        this.condition = condition2;
        this.thenStatement = thenStatement;
        this.elseStatement = elseStatement;
        this.br = singleLine ? " " : "\n";
        this.brAfterElse = singleLine || this.elseStatement instanceof IfStatement ? " " : "\n";
    }

    @NotNull
    public final Expression getCondition() {
        return this.condition;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        builder2.append("if (").append(this.condition).append(")").append(this.br).append(UtilKt.wrapToBlockIfRequired(this.thenStatement));
        if (!this.elseStatement.isEmpty()) {
            builder2.append(this.br).append("else").append(this.brAfterElse).append(UtilKt.wrapToBlockIfRequired(this.elseStatement));
        } else if (this.thenStatement.isEmpty()) {
            builder2.append(";");
        }
    }
}

