/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.AnonymousClassBody;
import org.jetbrains.kotlin.j2k.ast.ArgumentList;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.ReferenceElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/NewClassExpression;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "name", "Lorg/jetbrains/kotlin/j2k/ast/ReferenceElement;", "argumentList", "Lorg/jetbrains/kotlin/j2k/ast/ArgumentList;", "qualifier", "anonymousClass", "Lorg/jetbrains/kotlin/j2k/ast/AnonymousClassBody;", "<init>", "(Lorg/jetbrains/kotlin/j2k/ast/ReferenceElement;Lorg/jetbrains/kotlin/j2k/ast/ArgumentList;Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/AnonymousClassBody;)V", "getName", "()Lorg/jetbrains/kotlin/j2k/ast/ReferenceElement;", "getArgumentList", "()Lorg/jetbrains/kotlin/j2k/ast/ArgumentList;", "getQualifier", "()Lorg/jetbrains/kotlin/j2k/ast/Expression;", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "kotlin.j2k.k1.old"})
public final class NewClassExpression
extends Expression {
    @Nullable
    private final ReferenceElement name;
    @NotNull
    private final ArgumentList argumentList;
    @NotNull
    private final Expression qualifier;
    @Nullable
    private final AnonymousClassBody anonymousClass;

    public NewClassExpression(@Nullable ReferenceElement name2, @NotNull ArgumentList argumentList, @NotNull Expression qualifier2, @Nullable AnonymousClassBody anonymousClass) {
        Intrinsics.checkNotNullParameter((Object)argumentList, (String)"argumentList");
        Intrinsics.checkNotNullParameter((Object)qualifier2, (String)"qualifier");
        this.name = name2;
        this.argumentList = argumentList;
        this.qualifier = qualifier2;
        this.anonymousClass = anonymousClass;
    }

    public /* synthetic */ NewClassExpression(ReferenceElement referenceElement, ArgumentList argumentList, Expression expression, AnonymousClassBody anonymousClassBody, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            expression = Expression.Empty.INSTANCE;
        }
        if ((n & 8) != 0) {
            anonymousClassBody = null;
        }
        this(referenceElement, argumentList, expression, anonymousClassBody);
    }

    @Nullable
    public final ReferenceElement getName() {
        return this.name;
    }

    @NotNull
    public final ArgumentList getArgumentList() {
        return this.argumentList;
    }

    @NotNull
    public final Expression getQualifier() {
        return this.qualifier;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        if (this.anonymousClass != null) {
            builder2.append("object:");
        }
        if (!this.qualifier.isEmpty()) {
            builder2.append(this.qualifier).append(this.qualifier.isNullable() ? "!!." : ".");
        }
        if (this.name != null) {
            builder2.append(this.name);
        }
        if (this.anonymousClass == null || !this.anonymousClass.getExtendsInterface()) {
            builder2.append(this.argumentList);
        }
        if (this.anonymousClass != null) {
            builder2.append(this.anonymousClass);
        }
    }
}

