/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.copyPaste;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017JW\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00152\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f0\u001d\u00a2\u0006\u0002\b\u001e2\u001d\u0010\u001f\u001a\u0019\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0 0\u001d\u00a2\u0006\u0002\b\u001eH\u0002\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/j2k/copyPaste/ConversionTextClipper;", "", "<init>", "()V", "clipTextIfNeeded", "", "file", "Lcom/intellij/psi/PsiJavaFile;", "fileText", "startOffsets", "", "endOffsets", "maximalParentToClip", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "minimizedTextRange", "canDropElementFromText", "", "element", "tryClipLeftSide", "", "leftBound", "(Lcom/intellij/psi/PsiElement;I)Ljava/lang/Integer;", "tryClipRightSide", "rightBound", "tryClipSide", "rangeBound", "rangeFunction", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "childrenFunction", "Lkotlin/sequences/Sequence;", "(Lcom/intellij/psi/PsiElement;ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Integer;", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nConversionTextClipper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionTextClipper.kt\norg/jetbrains/kotlin/j2k/copyPaste/ConversionTextClipper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,173:1\n1586#2:174\n1661#2,3:175\n1068#2:178\n1786#2,3:192\n184#3,2:179\n321#3,7:181\n184#3,2:188\n128#3,2:190\n*S KotlinDebug\n*F\n+ 1 ConversionTextClipper.kt\norg/jetbrains/kotlin/j2k/copyPaste/ConversionTextClipper\n*L\n19#1:174\n19#1:175,3\n20#1:178\n22#1:192,3\n95#1:179,2\n97#1:181,7\n101#1:188,2\n102#1:190,2\n*E\n"})
public final class ConversionTextClipper {
    @NotNull
    public static final ConversionTextClipper INSTANCE = new ConversionTextClipper();

    private ConversionTextClipper() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String clipTextIfNeeded(@NotNull PsiJavaFile file, @NotNull String fileText, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Iterable $this$map$iv = (Iterable)ArraysKt.getIndices((int[])startOffsets);
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TextRange(startOffsets[it], endOffsets[it]));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List ranges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
        ArrayList<TextRange> rangesToDrop = new ArrayList<TextRange>();
        for (TextRange range2 : ranges) {
            TextRange rangeToDrop;
            Integer clipBound;
            int elementEnd;
            PsiElement endToken;
            TextRange rangeToDrop2;
            Integer clipBound2;
            int elementStart;
            PsiElement startToken;
            int end;
            int start2 = range2.getStartOffset();
            if (start2 == (end = range2.getEndOffset())) continue;
            Intrinsics.checkNotNull((Object)file.findElementAt(start2));
            PsiElement elementToClipLeft = this.maximalParentToClip(startToken, range2);
            if (elementToClipLeft != null && (elementStart = elementToClipLeft.getTextRange().getStartOffset()) < start2 && (clipBound2 = this.tryClipLeftSide(elementToClipLeft, start2)) != null && ConversionTextClipper.clipTextIfNeeded$canDropRange(ranges, rangeToDrop2 = new TextRange(elementStart, clipBound2.intValue()))) {
                rangesToDrop.add(rangeToDrop2);
            }
            Intrinsics.checkNotNull((Object)file.findElementAt(end - 1));
            PsiElement elementToClipRight = this.maximalParentToClip(endToken, range2);
            if (elementToClipRight == null || (elementEnd = elementToClipRight.getTextRange().getEndOffset()) <= end || (clipBound = this.tryClipRightSide(elementToClipRight, end)) == null || !ConversionTextClipper.clipTextIfNeeded$canDropRange(ranges, rangeToDrop = new TextRange(clipBound.intValue(), elementEnd))) continue;
            rangesToDrop.add(rangeToDrop);
        }
        if (rangesToDrop.isEmpty()) {
            return null;
        }
        Object $this$clipTextIfNeeded_u24lambda_u243 = object = new StringBuilder();
        boolean bl = false;
        int offset = 0;
        Iterator iterator3 = rangesToDrop.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        Iterator iterator4 = iterator3;
        while (iterator4.hasNext()) {
            boolean bl2;
            Object e = iterator4.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            TextRange range3 = (TextRange)e;
            boolean bl3 = bl2 = range3.getStartOffset() >= offset;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            String string = fileText.substring(offset, range3.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            ((StringBuilder)$this$clipTextIfNeeded_u24lambda_u243).append(string);
            offset = range3.getEndOffset();
        }
        String string = fileText.substring(offset, fileText.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        ((StringBuilder)$this$clipTextIfNeeded_u24lambda_u243).append(string);
        String newFileText = ((StringBuilder)object).toString();
        ConversionTextClipper.clipTextIfNeeded$update(startOffsets, rangesToDrop);
        ConversionTextClipper.clipTextIfNeeded$update(endOffsets, rangesToDrop);
        return newFileText;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement maximalParentToClip(PsiElement $this$maximalParentToClip, TextRange range2) {
        Object v0;
        PsiElement it;
        block3: {
            void $this$firstOrNull$iv;
            Sequence sequence = SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)$this$maximalParentToClip), ConversionTextClipper::maximalParentToClip$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!range2.contains(it.getTextRange()))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PsiElement psiElement = v0;
        if (psiElement == null) {
            return null;
        }
        PsiElement firstNotInRange = psiElement;
        Sequence $this$lastOrNull$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)firstNotInRange);
        boolean $i$f$lastOrNull = false;
        Object last$iv = null;
        for (Object element$iv : $this$lastOrNull$iv) {
            it = (PsiElement)element$iv;
            boolean bl = false;
            if (!range2.contains(INSTANCE.minimizedTextRange(it))) continue;
            last$iv = element$iv;
        }
        return last$iv;
    }

    private final TextRange minimizedTextRange(PsiElement $this$minimizedTextRange) {
        Object element$iv3;
        PsiElement firstChild;
        block5: {
            PsiElement psiElement;
            block7: {
                block6: {
                    Object v1;
                    block4: {
                        psiElement = $this$minimizedTextRange.getFirstChild();
                        if (psiElement == null || (psiElement = PsiUtilsKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null)) == null) break block6;
                        PsiElement $this$firstOrNull$iv = psiElement;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            PsiElement it = (PsiElement)element$iv2;
                            boolean bl = false;
                            if (!(!INSTANCE.canDropElementFromText(it))) continue;
                            v1 = element$iv2;
                            break block4;
                        }
                        v1 = null;
                    }
                    if ((psiElement = (PsiElement)v1) != null) break block7;
                }
                TextRange textRange = $this$minimizedTextRange.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                return textRange;
            }
            firstChild = psiElement;
            PsiElement psiElement2 = $this$minimizedTextRange.getLastChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getLastChild(...)");
            Sequence $this$first$iv = PsiUtilsKt.siblings$default((PsiElement)psiElement2, (boolean)false, (boolean)false, (int)2, null);
            boolean $i$f$first = false;
            for (Object element$iv3 : $this$first$iv) {
                PsiElement it = (PsiElement)element$iv3;
                boolean bl = false;
                if (!(!INSTANCE.canDropElementFromText(it))) continue;
                break block5;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        PsiElement lastChild = (PsiElement)element$iv3;
        return new TextRange(this.minimizedTextRange(firstChild).getStartOffset(), this.minimizedTextRange(lastChild).getEndOffset());
    }

    private final boolean canDropElementFromText(PsiElement element) {
        IElementType iElementType;
        PsiElement psiElement = element;
        boolean bl = psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiModifierList || psiElement instanceof PsiAnnotation ? true : (psiElement instanceof PsiJavaToken ? (Intrinsics.areEqual((Object)(iElementType = ((PsiJavaToken)element).getTokenType()), (Object)JavaTokenType.PUBLIC_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.PROTECTED_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.PRIVATE_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.STATIC_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.ABSTRACT_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.FINAL_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.NATIVE_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.SYNCHRONIZED_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.STRICTFP_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.TRANSIENT_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.VOLATILE_KEYWORD) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.DEFAULT_KEYWORD) ? element.getParent() instanceof PsiModifierList : Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.SEMICOLON)) : (psiElement instanceof PsiCodeBlock ? element.getParent() instanceof PsiMethod : element.getFirstChild() == null));
        return bl;
    }

    private final Integer tryClipLeftSide(PsiElement element, int leftBound) {
        return this.tryClipSide(element, leftBound, (Function1<? super PsiElement, ? extends TextRange>)((Function1)ConversionTextClipper::tryClipLeftSide$lambda$0), (Function1<? super PsiElement, ? extends Sequence<? extends PsiElement>>)((Function1)ConversionTextClipper::tryClipLeftSide$lambda$1));
    }

    private final Integer tryClipRightSide(PsiElement element, int rightBound) {
        Integer n = this.tryClipSide(element, ConversionTextClipper.tryClipRightSide$transform(rightBound), (Function1<? super PsiElement, ? extends TextRange>)((Function1)ConversionTextClipper::tryClipRightSide$lambda$1), (Function1<? super PsiElement, ? extends Sequence<? extends PsiElement>>)((Function1)ConversionTextClipper::tryClipRightSide$lambda$2));
        return n != null ? Integer.valueOf(ConversionTextClipper.tryClipRightSide$transform(n)) : null;
    }

    private final Integer tryClipSide(PsiElement element, int rangeBound, Function1<? super PsiElement, ? extends TextRange> rangeFunction, Function1<? super PsiElement, ? extends Sequence<? extends PsiElement>> childrenFunction) {
        PsiElement child;
        TextRange childRange;
        boolean bl;
        if (element.getFirstChild() == null) {
            return null;
        }
        TextRange elementRange = (TextRange)rangeFunction.invoke((Object)element);
        boolean bl2 = bl = elementRange.getStartOffset() < rangeBound && rangeBound < elementRange.getEndOffset();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int clipTo = elementRange.getStartOffset();
        Iterator iterator2 = ((Sequence)childrenFunction.invoke((Object)element)).iterator();
        while (iterator2.hasNext() && (childRange = (TextRange)rangeFunction.invoke((Object)(child = (PsiElement)iterator2.next()))).getStartOffset() < rangeBound) {
            if (childRange.getEndOffset() <= rangeBound) {
                if (!this.canDropElementFromText(child)) {
                    return null;
                }
                clipTo = childRange.getEndOffset();
                continue;
            }
            if (child instanceof PsiWhiteSpace) break;
            return this.tryClipSide(child, rangeBound, rangeFunction, childrenFunction);
        }
        return clipTo;
    }

    private static final boolean clipTextIfNeeded$canDropRange(List<? extends TextRange> ranges, TextRange range2) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = ranges;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TextRange it = (TextRange)element$iv;
                    boolean bl2 = false;
                    if (!it.contains(range2)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final void clipTextIfNeeded$update(int[] $this$clipTextIfNeeded_u24update, ArrayList<TextRange> rangesToDrop) {
        for (TextRange range2 : CollectionsKt.asReversedMutable((List)rangesToDrop)) {
            for (int offset : $this$clipTextIfNeeded_u24update) {
                boolean bl;
                if (offset >= range2.getEndOffset()) {
                    $this$clipTextIfNeeded_u24update[i] = offset - range2.getLength();
                    continue;
                }
                boolean bl2 = bl = offset <= range2.getStartOffset();
                if (!_Assertions.ENABLED || bl) continue;
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
    }

    private static final boolean maximalParentToClip$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof PsiDirectory);
    }

    private static final TextRange tryClipLeftSide$lambda$0(PsiElement $this$tryClipSide) {
        Intrinsics.checkNotNullParameter((Object)$this$tryClipSide, (String)"$this$tryClipSide");
        TextRange textRange = $this$tryClipSide.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    private static final Sequence tryClipLeftSide$lambda$1(PsiElement $this$tryClipSide) {
        Intrinsics.checkNotNullParameter((Object)$this$tryClipSide, (String)"$this$tryClipSide");
        return (Sequence)PsiUtilsKt.getAllChildren((PsiElement)$this$tryClipSide);
    }

    private static final int tryClipRightSide$transform(int $this$tryClipRightSide_u24transform) {
        return Integer.MAX_VALUE - $this$tryClipRightSide_u24transform;
    }

    private static final TextRange tryClipRightSide$transform$0(TextRange $this$tryClipRightSide_u24transform_u240) {
        return new TextRange(ConversionTextClipper.tryClipRightSide$transform($this$tryClipRightSide_u24transform_u240.getEndOffset()), ConversionTextClipper.tryClipRightSide$transform($this$tryClipRightSide_u24transform_u240.getStartOffset()));
    }

    private static final TextRange tryClipRightSide$lambda$1(PsiElement $this$tryClipSide) {
        Intrinsics.checkNotNullParameter((Object)$this$tryClipSide, (String)"$this$tryClipSide");
        TextRange textRange = $this$tryClipSide.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return ConversionTextClipper.tryClipRightSide$transform$0(textRange);
    }

    private static final Sequence tryClipRightSide$lambda$2(PsiElement $this$tryClipSide) {
        Intrinsics.checkNotNullParameter((Object)$this$tryClipSide, (String)"$this$tryClipSide");
        PsiElement psiElement = $this$tryClipSide.getLastChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getLastChild(...)");
        return PsiUtilsKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)2, null);
    }
}

