/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.postProcessings;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinOptimizeImportsFacility;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.j2k.FileBasedPostProcessing;
import org.jetbrains.kotlin.j2k.PostProcessingApplier;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/j2k/postProcessings/OptimizeImportsProcessing;", "Lorg/jetbrains/kotlin/j2k/FileBasedPostProcessing;", "<init>", "()V", "runProcessing", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "allFiles", "", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "converterContext", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "shouldTryToOptimizeImports", "", "computeApplier", "Lorg/jetbrains/kotlin/j2k/PostProcessingApplier;", "Applier", "kotlin.j2k.shared"})
@SourceDebugExtension(value={"SMAP\nOptimizeImportsProcessing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimizeImportsProcessing.kt\norg/jetbrains/kotlin/j2k/postProcessings/OptimizeImportsProcessing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1807#2,3:83\n*S KotlinDebug\n*F\n+ 1 OptimizeImportsProcessing.kt\norg/jetbrains/kotlin/j2k/postProcessings/OptimizeImportsProcessing\n*L\n47#1:83,3\n*E\n"})
public final class OptimizeImportsProcessing
extends FileBasedPostProcessing {
    @Override
    public void runProcessing(@NotNull KtFile file, @NotNull List<? extends KtFile> allFiles, @Nullable RangeMarker rangeMarker, @NotNull ConverterContext converterContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(allFiles, (String)"allFiles");
        Intrinsics.checkNotNullParameter((Object)converterContext, (String)"converterContext");
        if (!this.shouldTryToOptimizeImports(file, rangeMarker)) {
            return;
        }
        KotlinOptimizeImportsFacility optimizeImportsFacility = KotlinOptimizeImportsFacility.Companion.getInstance();
        List optimizedImports = (List)ActionsKt.runReadAction(() -> OptimizeImportsProcessing.runProcessing$lambda$0(optimizeImportsFacility, file));
        if (optimizedImports != null) {
            org.jetbrains.kotlin.nj2k.PsiUtilsKt.runUndoTransparentActionInEdt(true, () -> OptimizeImportsProcessing.runProcessing$lambda$1(optimizeImportsFacility, file, optimizedImports));
        }
    }

    private final boolean shouldTryToOptimizeImports(KtFile file, RangeMarker rangeMarker) {
        boolean bl;
        block3: {
            List elements = (List)ActionsKt.runReadAction(() -> OptimizeImportsProcessing.shouldTryToOptimizeImports$lambda$0(rangeMarker, file));
            Iterable $this$any$iv = elements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof KtElement && !(it instanceof KtImportDirective) && !(it instanceof KtImportList) && !(it instanceof KtPackageDirective))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public PostProcessingApplier computeApplier(@NotNull KtFile file, @NotNull List<? extends KtFile> allFiles, @Nullable RangeMarker rangeMarker, @NotNull ConverterContext converterContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(allFiles, (String)"allFiles");
        Intrinsics.checkNotNullParameter((Object)converterContext, (String)"converterContext");
        if (!this.shouldTryToOptimizeImports(file, rangeMarker)) {
            return Applier.Companion.getEMPTY();
        }
        KotlinOptimizeImportsFacility optimizeImportsFacility = KotlinOptimizeImportsFacility.Companion.getInstance();
        KotlinOptimizeImportsFacility.ImportData importData = optimizeImportsFacility.analyzeImports(file);
        if (importData == null) {
            return Applier.Companion.getEMPTY();
        }
        KotlinOptimizeImportsFacility.ImportData importData2 = importData;
        List<ImportPath> optimizedImports = optimizeImportsFacility.prepareOptimizedImports(file, importData2);
        return new Applier((SmartPsiElementPointer<KtFile>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)file)), optimizedImports);
    }

    private static final List runProcessing$lambda$0(KotlinOptimizeImportsFacility $optimizeImportsFacility, KtFile $file) {
        KotlinOptimizeImportsFacility.ImportData importData = $optimizeImportsFacility.analyzeImports($file);
        if (importData == null) {
            return null;
        }
        KotlinOptimizeImportsFacility.ImportData importData2 = importData;
        return $optimizeImportsFacility.prepareOptimizedImports($file, importData2);
    }

    private static final Unit runProcessing$lambda$1(KotlinOptimizeImportsFacility $optimizeImportsFacility, KtFile $file, List $optimizedImports) {
        $optimizeImportsFacility.replaceImports($file, $optimizedImports);
        return Unit.INSTANCE;
    }

    private static final List shouldTryToOptimizeImports$lambda$0(RangeMarker $rangeMarker, KtFile $file) {
        List list2;
        if ($rangeMarker != null && $rangeMarker.isValid()) {
            PsiFile psiFile = (PsiFile)$file;
            TextRange textRange = RangeMarkersKt.getAsTextRange((RangeMarker)$rangeMarker);
            Intrinsics.checkNotNull((Object)textRange);
            list2 = PsiUtilsKt.elementsInRange((PsiFile)psiFile, (TextRange)textRange);
        } else if ($rangeMarker != null && !$rangeMarker.isValid()) {
            list2 = CollectionsKt.emptyList();
        } else {
            PsiElement[] psiElementArray = $file.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            list2 = ArraysKt.asList((Object[])psiElementArray);
        }
        return list2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/j2k/postProcessings/OptimizeImportsProcessing$Applier;", "Lorg/jetbrains/kotlin/j2k/PostProcessingApplier;", "filePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtFile;", "optimizedImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Ljava/util/List;)V", "apply", "", "Companion", "kotlin.j2k.shared"})
    private static final class Applier
    implements PostProcessingApplier {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final SmartPsiElementPointer<KtFile> filePointer;
        @Nullable
        private final List<ImportPath> optimizedImports;
        @NotNull
        private static final Applier EMPTY = new Applier(null, null);

        public Applier(@Nullable SmartPsiElementPointer<KtFile> filePointer, @Nullable List<ImportPath> optimizedImports) {
            this.filePointer = filePointer;
            this.optimizedImports = optimizedImports;
        }

        @Override
        public void apply() {
            if (this.optimizedImports == null) {
                return;
            }
            KtFile ktFile2 = this.filePointer;
            if (ktFile2 == null || (ktFile2 = (KtFile)ktFile2.getElement()) == null) {
                return;
            }
            KtFile file = ktFile2;
            KotlinOptimizeImportsFacility.Companion.getInstance().replaceImports(file, (Iterable<ImportPath>)this.optimizedImports);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/j2k/postProcessings/OptimizeImportsProcessing$Applier$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/jetbrains/kotlin/j2k/postProcessings/OptimizeImportsProcessing$Applier;", "getEMPTY", "()Lorg/jetbrains/kotlin/j2k/postProcessings/OptimizeImportsProcessing$Applier;", "kotlin.j2k.shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Applier getEMPTY() {
                return EMPTY;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

