/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.AccessorKind;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.AssignmentExpression;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Operator;
import org.jetbrains.kotlin.j2k.ast.QualifiedExpression;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.j2k.usageProcessing.ConvertedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ExternalCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.UsageProcessing;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0002 !B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/AccessorToPropertyProcessing;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/UsageProcessing;", "accessorMethod", "Lcom/intellij/psi/PsiMethod;", "accessorKind", "Lorg/jetbrains/kotlin/j2k/AccessorKind;", "propertyName", "", "<init>", "(Lcom/intellij/psi/PsiMethod;Lorg/jetbrains/kotlin/j2k/AccessorKind;Ljava/lang/String;)V", "getAccessorMethod", "()Lcom/intellij/psi/PsiMethod;", "getAccessorKind", "()Lorg/jetbrains/kotlin/j2k/AccessorKind;", "getPropertyName", "()Ljava/lang/String;", "targetElement", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "()Lcom/intellij/psi/PsiElement;", "convertedCodeProcessor", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "getConvertedCodeProcessor", "()Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "javaCodeProcessors", "", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "getJavaCodeProcessors", "()Ljava/util/List;", "kotlinCodeProcessors", "Lorg/jetbrains/kotlin/j2k/usageProcessing/AccessorToPropertyProcessing$AccessorToPropertyProcessor;", "getKotlinCodeProcessors", "AccessorToPropertyProcessor", "Companion", "kotlin.j2k.k1.old"})
public final class AccessorToPropertyProcessing
implements UsageProcessing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiMethod accessorMethod;
    @NotNull
    private final AccessorKind accessorKind;
    @NotNull
    private final String propertyName;
    @NotNull
    private final ConvertedCodeProcessor convertedCodeProcessor;
    @NotNull
    private final List<ExternalCodeProcessor> javaCodeProcessors;
    @NotNull
    private final List<AccessorToPropertyProcessor> kotlinCodeProcessors;

    public AccessorToPropertyProcessing(@NotNull PsiMethod accessorMethod, @NotNull AccessorKind accessorKind, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)accessorMethod, (String)"accessorMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)accessorKind), (String)"accessorKind");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.accessorMethod = accessorMethod;
        this.accessorKind = accessorKind;
        this.propertyName = propertyName;
        this.convertedCodeProcessor = new ConvertedCodeProcessor(this){
            final /* synthetic */ AccessorToPropertyProcessing this$0;
            {
                this.this$0 = $receiver;
            }

            public Expression convertMethodUsage(PsiMethodCallExpression methodCall, CodeConverter codeConverter) {
                Expression propertyAccess;
                Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
                Intrinsics.checkNotNullParameter((Object)codeConverter, (String)"codeConverter");
                boolean isNullable = TypesKt.isNullable(codeConverter.getTypeConverter().methodNullability(this.this$0.getAccessorMethod()), codeConverter.getSettings());
                PsiReferenceExpression psiReferenceExpression = methodCall.getMethodExpression();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression, (String)"getMethodExpression(...)");
                PsiReferenceExpression methodExpr = psiReferenceExpression;
                PsiExpression[] psiExpressionArray = methodCall.getArgumentList().getExpressions();
                Intrinsics.checkNotNullExpressionValue((Object)psiExpressionArray, (String)"getExpressions(...)");
                PsiExpression[] arguments2 = psiExpressionArray;
                Identifier propertyName = Identifier.Companion.withNoPrototype$default(Identifier.Companion, this.this$0.getPropertyName(), isNullable, false, null, 12, null);
                PsiExpression qualifier2 = methodExpr.getQualifierExpression();
                Expression expression = propertyAccess = qualifier2 != null ? (Expression)ElementKt.assignNoPrototype((Element)new QualifiedExpression(CodeConverter.convertExpression$default(codeConverter, qualifier2, false, 2, null), propertyName, UtilsKt.dot(methodExpr))) : (Expression)propertyName;
                if (this.this$0.getAccessorKind() == AccessorKind.GETTER) {
                    if (!(arguments2.length == 0)) {
                        return null;
                    }
                    return propertyAccess;
                }
                if (arguments2.length != 1) {
                    return null;
                }
                Expression argument2 = CodeConverter.convertExpression$default(codeConverter, arguments2[0], false, 2, null);
                return new AssignmentExpression(propertyAccess, argument2, Operator.Companion.getEQ());
            }
        };
        this.javaCodeProcessors = CollectionsKt.emptyList();
        this.kotlinCodeProcessors = this.accessorMethod.hasModifierProperty("private") ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new AccessorToPropertyProcessor(this.propertyName, this.accessorKind));
    }

    @NotNull
    public final PsiMethod getAccessorMethod() {
        return this.accessorMethod;
    }

    @NotNull
    public final AccessorKind getAccessorKind() {
        return this.accessorKind;
    }

    @NotNull
    public final String getPropertyName() {
        return this.propertyName;
    }

    @Override
    @NotNull
    public PsiElement getTargetElement() {
        return (PsiElement)this.accessorMethod;
    }

    @Override
    @NotNull
    public ConvertedCodeProcessor getConvertedCodeProcessor() {
        return this.convertedCodeProcessor;
    }

    @Override
    @NotNull
    public List<ExternalCodeProcessor> getJavaCodeProcessors() {
        return this.javaCodeProcessors;
    }

    @NotNull
    public List<AccessorToPropertyProcessor> getKotlinCodeProcessors() {
        return this.kotlinCodeProcessors;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/AccessorToPropertyProcessing$AccessorToPropertyProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "propertyName", "", "accessorKind", "Lorg/jetbrains/kotlin/j2k/AccessorKind;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/j2k/AccessorKind;)V", "processUsage", "", "Lcom/intellij/psi/PsiReference;", "reference", "(Lcom/intellij/psi/PsiReference;)[Lcom/intellij/psi/PsiReference;", "kotlin.j2k.k1.old"})
    public static final class AccessorToPropertyProcessor
    implements ExternalCodeProcessor {
        @NotNull
        private final String propertyName;
        @NotNull
        private final AccessorKind accessorKind;

        public AccessorToPropertyProcessor(@NotNull String propertyName, @NotNull AccessorKind accessorKind) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            Intrinsics.checkNotNullParameter((Object)((Object)accessorKind), (String)"accessorKind");
            this.propertyName = propertyName;
            this.accessorKind = accessorKind;
        }

        @Override
        @Nullable
        public PsiReference[] processUsage(@NotNull PsiReference reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            PsiElement psiElement = reference.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            return Companion.processUsage(psiElement, this.propertyName, this.accessorKind);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/AccessorToPropertyProcessing$Companion;", "", "<init>", "()V", "processUsage", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "propertyName", "", "accessorKind", "Lorg/jetbrains/kotlin/j2k/AccessorKind;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lorg/jetbrains/kotlin/j2k/AccessorKind;)[Lcom/intellij/psi/PsiReference;", "kotlin.j2k.k1.old"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiReference[] processUsage(@NotNull PsiElement element, @NotNull String propertyName, @NotNull AccessorKind accessorKind) {
            PsiReference[] psiReferenceArray;
            KtQualifiedExpression qualifiedExpression;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            Intrinsics.checkNotNullParameter((Object)((Object)accessorKind), (String)"accessorKind");
            KtSimpleNameExpression ktSimpleNameExpression = element instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)element : null;
            if (ktSimpleNameExpression == null) {
                return null;
            }
            KtSimpleNameExpression nameExpr = ktSimpleNameExpression;
            PsiElement psiElement = nameExpr.getParent();
            KtCallExpression ktCallExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression callExpr = ktCallExpression;
            List arguments2 = callExpr.getValueArguments();
            Project project = nameExpr.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            KtSimpleNameExpression propertyNameExpr = factory2.createSimpleName(propertyName);
            if (accessorKind == AccessorKind.GETTER) {
                if (arguments2.size() != 0) {
                    return null;
                }
                PsiElement psiElement2 = callExpr.replace((PsiElement)propertyNameExpr);
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
                propertyNameExpr = (KtSimpleNameExpression)psiElement2;
                return propertyNameExpr.getReferences();
            }
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)arguments2);
            if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
                return null;
            }
            KtValueArgument value = ktValueArgument;
            KtExpression ktExpression = factory2.createExpression("a = b");
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            KtBinaryExpression assignment2 = (KtBinaryExpression)ktExpression;
            KtExpression ktExpression2 = assignment2.getRight();
            Intrinsics.checkNotNull((Object)ktExpression2);
            ktExpression2.replace((PsiElement)value);
            PsiElement psiElement3 = callExpr.getParent();
            KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = psiElement3 instanceof KtQualifiedExpression ? (KtQualifiedExpression)psiElement3 : null;
            if (qualifiedExpression != null && Intrinsics.areEqual((Object)qualifiedExpression.getSelectorExpression(), (Object)callExpr)) {
                callExpr.replace((PsiElement)propertyNameExpr);
                KtExpression ktExpression3 = assignment2.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression3);
                ktExpression3.replace((PsiElement)qualifiedExpression);
                PsiElement psiElement4 = qualifiedExpression.replace((PsiElement)assignment2);
                Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                assignment2 = (KtBinaryExpression)psiElement4;
                KtExpression ktExpression4 = assignment2.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
                KtExpression ktExpression5 = ((KtQualifiedExpression)ktExpression4).getSelectorExpression();
                Intrinsics.checkNotNull((Object)ktExpression5);
                psiReferenceArray = ktExpression5.getReferences();
            } else {
                KtExpression ktExpression6 = assignment2.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression6);
                ktExpression6.replace((PsiElement)propertyNameExpr);
                PsiElement psiElement5 = callExpr.replace((PsiElement)assignment2);
                Intrinsics.checkNotNull((Object)psiElement5, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                assignment2 = (KtBinaryExpression)psiElement5;
                KtExpression ktExpression7 = assignment2.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression7);
                psiReferenceArray = ktExpression7.getReferences();
            }
            return psiReferenceArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

