/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.usageProcessing.ConvertedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ExternalCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.UsageProcessing;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/MemberIntoObjectProcessing;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/UsageProcessing;", "member", "Lcom/intellij/psi/PsiMember;", "objectName", "", "<init>", "(Lcom/intellij/psi/PsiMember;Ljava/lang/String;)V", "targetElement", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "()Lcom/intellij/psi/PsiElement;", "convertedCodeProcessor", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "getConvertedCodeProcessor", "()Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "javaCodeProcessors", "", "Lorg/jetbrains/kotlin/j2k/usageProcessing/MemberIntoObjectProcessing$AppendObjectNameProcessor;", "getJavaCodeProcessors", "()Ljava/util/List;", "kotlinCodeProcessors", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "getKotlinCodeProcessors", "AppendObjectNameProcessor", "kotlin.j2k.k1.old"})
public final class MemberIntoObjectProcessing
implements UsageProcessing {
    @NotNull
    private final PsiMember member;
    @NotNull
    private final String objectName;
    @NotNull
    private final List<AppendObjectNameProcessor> javaCodeProcessors;
    @NotNull
    private final List<ExternalCodeProcessor> kotlinCodeProcessors;

    public MemberIntoObjectProcessing(@NotNull PsiMember member, @NotNull String objectName) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        this.member = member;
        this.objectName = objectName;
        this.javaCodeProcessors = CollectionsKt.listOf((Object)new AppendObjectNameProcessor());
        this.kotlinCodeProcessors = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PsiElement getTargetElement() {
        return (PsiElement)this.member;
    }

    @Override
    @Nullable
    public ConvertedCodeProcessor getConvertedCodeProcessor() {
        return null;
    }

    @NotNull
    public List<AppendObjectNameProcessor> getJavaCodeProcessors() {
        return this.javaCodeProcessors;
    }

    @Override
    @NotNull
    public List<ExternalCodeProcessor> getKotlinCodeProcessors() {
        return this.kotlinCodeProcessors;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/MemberIntoObjectProcessing$AppendObjectNameProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "<init>", "(Lorg/jetbrains/kotlin/j2k/usageProcessing/MemberIntoObjectProcessing;)V", "processUsage", "", "Lcom/intellij/psi/PsiReference;", "reference", "(Lcom/intellij/psi/PsiReference;)[Lcom/intellij/psi/PsiReference;", "kotlin.j2k.k1.old"})
    public final class AppendObjectNameProcessor
    implements ExternalCodeProcessor {
        @Override
        @Nullable
        public PsiReference[] processUsage(@NotNull PsiReference reference) {
            PsiReference[] psiReferenceArray;
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            PsiElement psiElement = reference.getElement();
            PsiReferenceExpression psiReferenceExpression = psiElement instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiElement : null;
            if (psiReferenceExpression == null) {
                return null;
            }
            PsiReferenceExpression refExpr = psiReferenceExpression;
            PsiExpression qualifier2 = refExpr.getQualifierExpression();
            PsiElementFactory factory2 = PsiElementFactory.getInstance((Project)MemberIntoObjectProcessing.this.member.getProject());
            if (qualifier2 != null) {
                PsiExpression psiExpression = factory2.createExpressionFromText(qualifier2.getText() + "." + MemberIntoObjectProcessing.this.objectName, null);
                Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
                PsiExpression newQualifier = psiExpression;
                qualifier2.replace((PsiElement)newQualifier);
                PsiReference[] psiReferenceArray2 = new PsiReference[]{reference};
                psiReferenceArray = psiReferenceArray2;
            } else {
                PsiExpression psiExpression = factory2.createExpressionFromText(MemberIntoObjectProcessing.this.objectName + "." + refExpr.getText(), null);
                Intrinsics.checkNotNull((Object)psiExpression, (String)"null cannot be cast to non-null type com.intellij.psi.PsiReferenceExpression");
                PsiReferenceExpression qualifiedExpr = (PsiReferenceExpression)psiExpression;
                PsiElement psiElement2 = refExpr.replace((PsiElement)qualifiedExpr);
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiReferenceExpression");
                qualifiedExpr = (PsiReferenceExpression)psiElement2;
                PsiReference[] psiReferenceArray3 = new PsiReference[]{qualifiedExpr};
                psiReferenceArray = psiReferenceArray3;
            }
            return psiReferenceArray;
        }
    }
}

