/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.gradle;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.onboarding.gradle.BuildProcessSatisfactionSurveyState;

@State(name="BuildProcessSatisfactionSurveyStore", storages={@Storage(value="kotlin-onboarding.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\r\u0010\u000e\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0011J\r\u0010\u0012\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0013J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u000f\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0002\b\u0018J\r\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bR\u001a\u0010\u0006\u001a\u00020\u0002X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyState;", "<init>", "()V", "getState", "currentState", "getCurrentState$intellij_kotlin_onboarding_gradle", "()Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyState;", "setCurrentState$intellij_kotlin_onboarding_gradle", "(Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyState;)V", "loadState", "", "state", "recordSurveyShown", "recordSurveyShown$intellij_kotlin_onboarding_gradle", "recordNonKotlinBuild", "recordNonKotlinBuild$intellij_kotlin_onboarding_gradle", "recordKotlinBuild", "recordKotlinBuild$intellij_kotlin_onboarding_gradle", "getFirstKotlinGradleUsageDate", "Ljava/time/LocalDate;", "getFirstKotlinGradleUsageDate$intellij_kotlin_onboarding_gradle", "getFirstGradleUsageDate", "getFirstGradleUsageDate$intellij_kotlin_onboarding_gradle", "shouldShowDialog", "", "shouldShowDialog$intellij_kotlin_onboarding_gradle", "Companion", "intellij.kotlin.onboarding.gradle"})
@ApiStatus.Internal
public final class BuildProcessSatisfactionSurveyStore
implements PersistentStateComponent<BuildProcessSatisfactionSurveyState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BuildProcessSatisfactionSurveyState currentState = new BuildProcessSatisfactionSurveyState();
    public static final int MINIMUM_BUILDS_BEFORE_SURVEY = 3;
    private static final Duration MINIMUM_DURATION_SINCE_FIRST_BUILD = Duration.ofDays(14L);

    @NotNull
    public BuildProcessSatisfactionSurveyState getState() {
        return this.currentState;
    }

    @NotNull
    public final BuildProcessSatisfactionSurveyState getCurrentState$intellij_kotlin_onboarding_gradle() {
        return this.currentState;
    }

    public final void setCurrentState$intellij_kotlin_onboarding_gradle(@NotNull BuildProcessSatisfactionSurveyState buildProcessSatisfactionSurveyState) {
        Intrinsics.checkNotNullParameter((Object)((Object)buildProcessSatisfactionSurveyState), (String)"<set-?>");
        this.currentState = buildProcessSatisfactionSurveyState;
    }

    public void loadState(@NotNull BuildProcessSatisfactionSurveyState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.currentState = state;
    }

    public final void recordSurveyShown$intellij_kotlin_onboarding_gradle() {
        this.getState().setUserSawSurvey(true);
    }

    public final void recordNonKotlinBuild$intellij_kotlin_onboarding_gradle() {
        Instant currentTime = Instant.now();
        if (this.currentState.getFirstGradleBuildTime() == 0L) {
            this.currentState.setFirstGradleBuildTime(currentTime.getEpochSecond());
        }
    }

    public final void recordKotlinBuild$intellij_kotlin_onboarding_gradle() {
        Instant currentTime = Instant.now();
        if (currentTime.compareTo(Instant.ofEpochSecond(this.currentState.getNextCountedGradleBuild())) >= 0) {
            BuildProcessSatisfactionSurveyState buildProcessSatisfactionSurveyState = this.currentState;
            int n = buildProcessSatisfactionSurveyState.getDaysWithGradleBuilds();
            buildProcessSatisfactionSurveyState.setDaysWithGradleBuilds(n + 1);
            this.currentState.setNextCountedGradleBuild(currentTime.plus(Duration.ofDays(1L)).getEpochSecond());
        }
        this.currentState.setLastKotlinGradleBuildTime(currentTime.getEpochSecond());
        if (this.currentState.getFirstKotlinGradleBuildTime() == 0L) {
            this.currentState.setFirstKotlinGradleBuildTime(currentTime.getEpochSecond());
        }
        if (this.currentState.getFirstGradleBuildTime() == 0L) {
            this.currentState.setFirstGradleBuildTime(currentTime.getEpochSecond());
        }
    }

    @Nullable
    public final LocalDate getFirstKotlinGradleUsageDate$intellij_kotlin_onboarding_gradle() {
        if (this.getState().getFirstKotlinGradleBuildTime() == 0L) {
            return null;
        }
        return Instant.ofEpochSecond(this.getState().getFirstKotlinGradleBuildTime()).atOffset(ZoneOffset.UTC).toLocalDate();
    }

    @Nullable
    public final LocalDate getFirstGradleUsageDate$intellij_kotlin_onboarding_gradle() {
        if (this.getState().getFirstKotlinGradleBuildTime() > 0L && this.getState().getFirstKotlinGradleBuildTime() < this.getState().getFirstGradleBuildTime()) {
            return this.getFirstKotlinGradleUsageDate$intellij_kotlin_onboarding_gradle();
        }
        if (this.getState().getFirstGradleBuildTime() == 0L) {
            return null;
        }
        return Instant.ofEpochSecond(this.getState().getFirstGradleBuildTime()).atOffset(ZoneOffset.UTC).toLocalDate();
    }

    public final boolean shouldShowDialog$intellij_kotlin_onboarding_gradle() {
        BuildProcessSatisfactionSurveyState state = this.currentState;
        if (state.getUserSawSurvey() || state.getFirstKotlinGradleBuildTime() == 0L || state.getDaysWithGradleBuilds() < 3) {
            return false;
        }
        return Duration.between(Instant.ofEpochSecond(state.getFirstKotlinGradleBuildTime()), Instant.now()).compareTo(MINIMUM_DURATION_SINCE_FIRST_BUILD) >= 0;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore$Companion;", "", "<init>", "()V", "MINIMUM_BUILDS_BEFORE_SURVEY", "", "MINIMUM_DURATION_SINCE_FIRST_BUILD", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getMINIMUM_DURATION_SINCE_FIRST_BUILD$intellij_kotlin_onboarding_gradle", "()Ljava/time/Duration;", "getInstance", "Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore;", "intellij.kotlin.onboarding.gradle"})
    @SourceDebugExtension(value={"SMAP\nBuildProcessSatisfactionSurveyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProcessSatisfactionSurveyStore.kt\norg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,111:1\n42#2,3:112\n*S KotlinDebug\n*F\n+ 1 BuildProcessSatisfactionSurveyStore.kt\norg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionSurveyStore$Companion\n*L\n43#1:112,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final Duration getMINIMUM_DURATION_SINCE_FIRST_BUILD$intellij_kotlin_onboarding_gradle() {
            return MINIMUM_DURATION_SINCE_FIRST_BUILD;
        }

        @NotNull
        public final BuildProcessSatisfactionSurveyStore getInstance() {
            boolean $i$f$service = false;
            Class<BuildProcessSatisfactionSurveyStore> serviceClass$iv = BuildProcessSatisfactionSurveyStore.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (BuildProcessSatisfactionSurveyStore)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

