/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SystemProperties;
import java.util.Locale;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.core.UtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.PipelineTask;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.ValidationResult;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.PathSettingType;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.PluginSetting;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.PluginSettingReference;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.SettingReference;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.SettingType;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.StringSettingType;
import org.jetbrains.kotlin.tools.projectWizard.phases.GenerationPhase;
import org.jetbrains.kotlin.tools.projectWizard.plugins.StructurePlugin;
import org.jetbrains.kotlin.tools.projectWizard.wizard.IdeWizard;
import org.jetbrains.kotlin.tools.projectWizard.wizard.WizardStep;
import org.jetbrains.kotlin.tools.projectWizard.wizard.ui.UiKt;
import org.jetbrains.kotlin.tools.projectWizard.wizard.ui.firstStep.FirstWizardStepComponent;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ModuleNewWizardFirstStep;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/WizardStep;", "wizard", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;Lcom/intellij/openapi/Disposable;)V", "component", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ui/firstStep/FirstWizardStepComponent;", "getComponent", "Ljavax/swing/JComponent;", "runPreparePhase", "Lorg/jetbrains/kotlin/tools/projectWizard/core/TaskResult;", "", "handleErrors", "error", "Lorg/jetbrains/kotlin/tools/projectWizard/core/entity/ValidationResult$ValidationError;", "initDefaultValues", "suggestGroupId", "", "Companion", "intellij.kotlin.projectWizard.idea"})
@SourceDebugExtension(value={"SMAP\nNewProjectWizardModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewProjectWizardModuleBuilder.kt\norg/jetbrains/kotlin/tools/projectWizard/wizard/ModuleNewWizardFirstStep\n+ 2 SettingReference.kt\norg/jetbrains/kotlin/tools/projectWizard/core/entity/settings/SettingReferenceKt\n*L\n1#1,368:1\n33#2:369\n33#2:370\n33#2:371\n33#2:372\n*S KotlinDebug\n*F\n+ 1 NewProjectWizardModuleBuilder.kt\norg/jetbrains/kotlin/tools/projectWizard/wizard/ModuleNewWizardFirstStep\n*L\n296#1:369\n297#1:370\n298#1:371\n301#1:372\n*E\n"})
public final class ModuleNewWizardFirstStep
extends WizardStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirstWizardStepComponent component;
    @NotNull
    private static final String DEFAULT_GROUP_ID = "me.user";

    public ModuleNewWizardFirstStep(@NotNull IdeWizard wizard, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)wizard, (String)"wizard");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(wizard, GenerationPhase.FIRST_STEP);
        this.component = new FirstWizardStepComponent(wizard);
        this.runPreparePhase();
        this.initDefaultValues();
        this.component.onInit();
        Disposer.register((Disposable)disposable, (Disposable)this.component);
    }

    @NotNull
    public JComponent getComponent() {
        return this.component.getComponent();
    }

    private final TaskResult<Unit> runPreparePhase() {
        return (TaskResult)UiKt.runWithProgressBar("", () -> ModuleNewWizardFirstStep.runPreparePhase$lambda$0(this));
    }

    @Override
    protected void handleErrors(@NotNull ValidationResult.ValidationError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.component.navigateTo(error);
    }

    private final void initDefaultValues() {
        String suggestedProjectParentLocation = RecentProjectsManager.Companion.getInstance().suggestNewProjectLocation();
        String suggestedProjectName = ProjectWizardUtil.findNonExistingFileName((String)suggestedProjectParentLocation, (String)"untitled", (String)"");
        this.getWizard().getContext().writeSettings(arg_0 -> ModuleNewWizardFirstStep.initDefaultValues$lambda$0(suggestedProjectName, suggestedProjectParentLocation, this, arg_0));
    }

    private final String suggestGroupId() {
        String string = SystemProperties.getUserName();
        if (string == null) {
            return DEFAULT_GROUP_ID;
        }
        String username = string;
        CharSequence charSequence = username;
        if (!new Regex("[\\w\\s]+").matches(charSequence)) {
            return DEFAULT_GROUP_ID;
        }
        CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)username)).toString();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = charSequence2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        charSequence2 = string2;
        Regex regex = new Regex("\\s+");
        int n = 0;
        String usernameAsGroupId = CollectionsKt.joinToString$default((Iterable)regex.split(charSequence2, n), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return "me." + usernameAsGroupId;
    }

    private static final Unit runPreparePhase$lambda$0$0(PipelineTask task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        String string = task2.getTitle();
        if (string == null) {
            string = "";
        }
        progressIndicator.setText(string);
        return Unit.INSTANCE;
    }

    private static final TaskResult runPreparePhase$lambda$0(ModuleNewWizardFirstStep this$0) {
        return this$0.getWizard().apply(CollectionsKt.emptyList(), SetsKt.setOf((Object)((Object)GenerationPhase.PREPARE)), (Function1<? super PipelineTask, Unit>)((Function1)ModuleNewWizardFirstStep::runPreparePhase$lambda$0$0));
    }

    private static final Unit initDefaultValues$lambda$0(String $suggestedProjectName, String $suggestedProjectParentLocation, ModuleNewWizardFirstStep this$0, Context.SettingsWriter $this$writeSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$writeSettings, (String)"$this$writeSettings");
        PluginSetting<Object, SettingType> $this$reference$iv = StructurePlugin.Companion.getName();
        boolean $i$f$getReference = false;
        SettingReference settingReference = new PluginSettingReference($this$reference$iv.getPath(), Reflection.getOrCreateKotlinClass(StringSettingType.class));
        Intrinsics.checkNotNull((Object)$suggestedProjectName);
        $this$writeSettings.setValue(settingReference, $suggestedProjectName);
        $this$reference$iv = StructurePlugin.Companion.getProjectPath();
        $i$f$getReference = false;
        $this$writeSettings.setValue(new PluginSettingReference($this$reference$iv.getPath(), Reflection.getOrCreateKotlinClass(PathSettingType.class)), UtilsKt.div($suggestedProjectParentLocation, $suggestedProjectName));
        $this$reference$iv = StructurePlugin.Companion.getArtifactId();
        $i$f$getReference = false;
        $this$writeSettings.setValue(new PluginSettingReference($this$reference$iv.getPath(), Reflection.getOrCreateKotlinClass(StringSettingType.class)), $suggestedProjectName);
        if ($this$writeSettings.getNotRequiredSettingValue(StructurePlugin.Companion.getGroupId()) == null) {
            $this$reference$iv = StructurePlugin.Companion.getGroupId();
            $i$f$getReference = false;
            $this$writeSettings.setValue(new PluginSettingReference($this$reference$iv.getPath(), Reflection.getOrCreateKotlinClass(StringSettingType.class)), this$0.suggestGroupId());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ModuleNewWizardFirstStep$Companion;", "", "<init>", "()V", "DEFAULT_GROUP_ID", "", "intellij.kotlin.projectWizard.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

