/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard.service;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.core.UtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.core.service.FileSystemWizardService;
import org.jetbrains.kotlin.tools.projectWizard.wizard.service.IdeaWizardService;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaFileSystemWizardService;", "Lorg/jetbrains/kotlin/tools/projectWizard/core/service/FileSystemWizardService;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/service/IdeaWizardService;", "<init>", "()V", "createDirectory", "Lorg/jetbrains/kotlin/tools/projectWizard/core/TaskResult;", "", "path", "Ljava/nio/file/Path;", "createFile", "text", "", "intellij.kotlin.projectWizard.idea"})
public final class IdeaFileSystemWizardService
implements FileSystemWizardService,
IdeaWizardService {
    @Override
    @NotNull
    public TaskResult<Unit> createDirectory(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return UtilsKt.safe(() -> IdeaFileSystemWizardService.createDirectory$lambda$0(path2));
    }

    @Override
    @NotNull
    public TaskResult<Unit> createFile(@NotNull Path path2, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return UtilsKt.safe(() -> IdeaFileSystemWizardService.createFile$lambda$0(path2, this, text));
    }

    private static final Unit createDirectory$lambda$0$0(Path $path) {
        VfsUtil.createDirectoryIfMissing((String)((Object)$path).toString());
        return Unit.INSTANCE;
    }

    private static final Unit createDirectory$lambda$0(Path $path) {
        ActionsKt.runWriteAction(() -> IdeaFileSystemWizardService.createDirectory$lambda$0$0($path));
        return Unit.INSTANCE;
    }

    private static final Unit createFile$lambda$0$0(Path $path, IdeaFileSystemWizardService this$0, String $text) {
        Path path2 = $path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((String)((Object)path2).toString());
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile directory = virtualFile;
        VirtualFile virtualFile2 = directory.createChildData((Object)this$0, ((Object)$path.getFileName()).toString());
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createChildData(...)");
        VirtualFile virtualFile3 = virtualFile2;
        VfsUtil.saveText((VirtualFile)virtualFile3, (String)StringUtil.convertLineSeparators((String)$text));
        return Unit.INSTANCE;
    }

    private static final Unit createFile$lambda$0(Path $path, IdeaFileSystemWizardService this$0, String $text) {
        ActionsKt.runWriteAction(() -> IdeaFileSystemWizardService.createFile$lambda$0$0($path, this$0, $text));
        return Unit.INSTANCE;
    }
}

